/* structure for filer */

enum{
  FILECX_NAME,
  FILECX_SIZE,
  FILECX_DATE,
  FILECX_MAX
};


typedef struct _dfFile{
  char *name;
  char *ext;
  char *link;
  int flags;
  mode_t attr;
  mode_t r_attr;
  int color;
  off_t size;
  uid_t owner;
  gid_t group;
  time_t atime;
  time_t mtime;
  time_t ctime;
#if DRAW_SIZE
  int cx[FILECX_MAX];
#endif
  int nSelect;
}DfFile;
#define DFFL_NOSTAT 1

typedef struct _dfFileList{
  DfBufCommon b;
  DfFile **files;
  DfFile *raw;
  df_stat stat;
  int n;/* buffer's number */
#if DRAW_SIZE
  int cx[FILECX_MAX];
#endif
  int nHasFiles;/* number of files in directory */
  int nSelects;
  sort_type sort;
  int mode;
  char *cwd;
  char *pszFilenames;
  char *filter;
}DfFileList;

/*  modes */
#define SHOW_DOTS (1)
#define MODE_IFILTER   (1 << 1)

void FL_Init(DfFileList *list);
int MakeSelectList(DfStr *s, DfFileList *list);
void SortFileList(DfFileList *list);
DfFileList *GetNextFileBuf(DfFileList *list);
df_stat SetFilerState(Widget w, DfFileList *list, df_stat s);

int chDir(Widget w, DfFileList *list, const char *new_dir);
int DoExecStr(Widget w, DfBuf *b, DfStr *cmd);
int reload(Widget w, DfFileList *, const char *cursor_pos);

DfFileList *GetFilerBuffer(DfBuf *b);
