inline static int euc_leadbyte(int ch)
{
  if(ch & 0x80){
    return 1;
  }
  return 0;
}

inline static int sjis_leadbyte(int ch)
{
  if((unsigned char)((ch ^ 0x20) - 0xa1) < 0x3c){
    return 1;
  }
  return 0;
}

inline static int utf8_leadbyte(int ch)
{
  if((ch & 0xd0) == 0xd0){
    return 1;
  }
  return 0;
}

inline static int sjis_halfkana(int ch)
{
  unsigned int n = ch;
  return (n - '\xa1') <= (0xdf - 0xa1);
}

inline static int euc_mblen(int ch)
{
  if(euc_leadbyte(ch)){
    return 2;
  }
  return 1;
}

inline static int sjis_mblen(int ch)
{
  if(sjis_leadbyte(ch)){
    return 2;
  }
  return 1;
}

inline static int utf8_mblen(int ch)
{
  if((ch & 0x80) == 0){
    return 1;
  }
  if((ch & 0xe0) == 0xd0){
    return 2;
  }
  if((ch & 0xf0) == 0xe0){
    return 3;
  }
  if((ch & 0xf8) == 0xf0){
    return 4;
  }
  if((ch & 0xf8) == 0xf0){
    return 5;
  }
  if((ch & 0xfd) == 0xf8){
    return 6;
  }
  if((ch & 0xfe) == 0xfd){
    return 7;
  }
  return 1;
}

extern int (*dfx_mblen)(int);
extern int (*dfx_mbbacklen)(char *, int);
extern int (*dfx_leadbyte)(int);
void chcode_init(void);

