#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "config.h"
#include "str.h"
#include "cmdinput.h"
#include "mem.h"
#include "debug.h"


enum{
  NONE,
  WORD,
  QUOTE1,
  QUOTE2,
};


static int parseCmd(InputCmd *arg, const char *pszCmd);
static void setArg(InputCmd *arg, int pos);
static void adjustArg(InputCmd *arg);


static void initInputCmd(InputCmd *p)
{
  p->argc = 0;
  p->size = 32;
  p->argv = bMalloc(sizeof(char*) * 32);
  Str_Init(&p->cmd);
}

void FreeInputCmd(InputCmd *p)
{
  Str_Free(&p->cmd, 0);
  bFree(p->argv);
  bFree(p);
}

InputCmd *BuildArgs(const char *pszCmd)
{
  InputCmd *arg;

  arg = bMalloc(sizeof(InputCmd));
  initInputCmd(arg);

  parseCmd(arg, pszCmd);
  adjustArg(arg);
  return arg;
}

InputCmd *BuildArgs2(const char *pszCmd, InputCmd *arg)
{

  if(arg){
    arg->argc = 0;
    Str_SetLength(&arg->cmd, 0);
  }else{
    arg = bMalloc(sizeof(InputCmd));
    initInputCmd(arg);
  }

  parseCmd(arg, pszCmd);
  adjustArg(arg);
  return arg;
}


static int parseCmd(InputCmd *arg, const char *pszCmd)
{
  MbStr mb;
  const char *p;
  int stat;

  InitMbStr(&mb, pszCmd);
  p = pszCmd;

  stat = NONE;
  while(*p){
    switch(stat){
    case NONE:
      if(mb.c_len == 1){
	switch(p[0]){
	case '\"':
	  stat = QUOTE1;
	  goto NEXT;
	}
      }
      if(!IsSkipChar(&mb)){
	setArg(arg, Str_Length(&arg->cmd));
	stat = WORD;
	continue;
      }
      break;
    case WORD:
      if(IsSkipChar(&mb)){
	Str_AddChar(&arg->cmd, '\0');
	stat = NONE;
      }else{
	if(*p == '\\'){
	  p = MbNextChar(&mb);
	}
	Str_AddLen(&arg->cmd, p, mb.c_len);
      }
      break;
    case QUOTE1:
      setArg(arg, Str_Length(&arg->cmd));
      stat = QUOTE2;
      /*THRU*/
    case QUOTE2:
      if(mb.c_len == 1 && p[0] == '\"'){
	Str_AddChar(&arg->cmd, '\0');
	stat = NONE;
      }else{
	Str_AddLen(&arg->cmd, p, mb.c_len);
      }
      break;
    }
  NEXT:
    p = MbNextChar(&mb);
  }
  return 0;
}

static void setArg(InputCmd *arg, int pos)
{
  int n;
  char **p;

  n = arg->argc;
  if(arg->size <= n + 1){
    /* exterd */
    p = bReAlloc(arg->argv, sizeof(char*) * (arg->size + 8));
    arg->size += 8;
  }
  arg->argv[n] = (char *)pos;
  arg->argc++;
}

static void adjustArg(InputCmd *arg)
{
  int n;
  int argc;
  long int base;

  argc = arg->argc;
  base = (long int)Str_Get(&arg->cmd);
  for(n = 0; n < argc; n++){
    arg->argv[n] += base;
  }
  arg->argv[argc] = NULL;
}

