#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h> 
#include <unistd.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "str.h"
#include "dftype.h"
#include "list.h"
#include "buffer.h"
#include "cmd.h"
#include "cmdinput.h"
#include "mem.h"
#include "debug.h"

void DfxSendMsg(int msg, int err);

int DfxExec(Widget w, DfBuf *b, const char *cwd, const char *cmd, int *builtin)
{
  InputCmd *ic;
  pid_t pid;
  int ec;
  DfCmdStr bi;
  int bin;

  ic = BuildArgs(cmd);

  bin = findCommand(ic->argv[0]);
  if(builtin){
    *builtin = bin;
  }

  if(bin != NOP){
    switch(b->type){
    case DT_FILER:
    case DT_VIEWER:
    case DT_CMDLIST:
    case DT_PATHLIST:
      bi.builtin = bin;
      bi.allow = 0;
      bi.cmd = (char *)cmd;
      CommandHandler(b, w, &bi, 0/* don't parse macro */);
      break;
    default:
      break;
    }
    FreeInputCmd(ic);
    return 0;
  }

  pid = fork();
  if(pid < 0){
    FreeInputCmd(ic);
    return errno;
  }

  if(pid != 0){
    FreeInputCmd(ic);
    return 0;
  }

  /* pid == 0 */
  if(!chdir(cwd)){
    execvp(ic->argv[0], ic->argv);
  }
  ec = errno;

  DfxSendMsg(STM_EXECFAIL, ec);

  _exit(1);
}

int DfxExecArgv(Widget w, DfBuf *b, const char *cwd, const char **argv)
{
  int ec;
  pid_t pid;

  pid = fork();
  if(pid < 0){
    return errno;
  }

  if(pid != 0){
    return 0;
  }

  /* pid == 0 */
  if(!chdir(cwd)){
    execvp(argv[0], argv);
  }

  ec = errno;

  DfxSendMsg(STM_EXECFAIL, ec);

  _exit(1);
}
