#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "info.h"
#include "status.h"
#include "cmdlist.h"
#include "cmdinput.h"
#include "task.h"
#include "dir.h"
#include "cmd.h"
#include "xutil.h"
#include "misc.h"
#include "mem.h"
#include "extmacro.h"
#include "dfxfunc.h"
#include "dfval.h"
#include "debug.h"


static task_result filterInvoke(DfTask *t);
static task_result filterDone(DfTask *t);
static task_result ifilterDone(DfTask *t);

task_vtable vtable_filter ={
  filterInvoke,
  NULL,
  filterDone,
};

task_vtable vtable_ifilter ={
  filterInvoke,
  NULL,
  ifilterDone,
};

static task_result filterDoneCommon(DfTask *t, int update);

static task_result filterInvoke(DfTask *t)
{
  /* mark to use filter */
  t->update = 1;
  DlgSendEvent(t, taskCbDone);

  return TASK_LEAVE;
}

static task_result filterDone(DfTask *t)
{
  DfFileList *list = t->list;

  list->mode &= ~MODE_IFILTER;

  return filterDoneCommon(t, 1);
}
static task_result ifilterDone(DfTask *t)
{
  DfFileList *list = t->list;

  list->mode |= MODE_IFILTER;

  return filterDoneCommon(t, 0);
}

static task_result filterDoneCommon(DfTask *t, int update)
{
  DfFileList *list = t->list;
  char *p = NULL;
  const char *msg = NULL;

  if(t->update){
    /* use filter */
    p = Str_Get(&t->input);
    if(p[0]){
      /* disconnect link for re-use memory.  */
      Str_InitNull(&t->input);
    }else{
      /* not specify, clear the filter. */
      p = NULL;
      msg = vOptions.msg[STM_CLEARFILTER];
    }
  }else{
    /* cancel, clear the filter */
    if(list->filter){
      list->mode &= ~MODE_IFILTER;
      msg = vOptions.msg[STM_CLEARFILTER];
      update = 1;
    }
  }
  list->filter = p;
  if(msg){
    St_SetMsg(t->w, msg);
  }else{
    St_ClearMsg(t->w);
  }

  if(update){
    ApplyFilter(t->w, list, list->mode & MODE_IFILTER);
    SortFileList(list);
    SetCursor(t->w, &list->b, list->b.nCur);
    RedrawFrame(t->w, GetBuffer(list), &GetBuffer(list)->rc);
  }

  return TASK_LEAVE;
}

