#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <sys/stat.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "info.h"
#include "mem.h"
#include "xutil.h"
#include "dfxfunc.h"
#include "dfval.h"

static DfInfo *Info;

static int In_Free(void *list);
static int In_Active(Widget w, void *ptr);
static int In_Inactive(Widget w, void *ptr);
static int In_Draw(void *ptr, struct DfDrawInfo *di);

static int strMode(char *buf, mode_t mode);


static const DfVerb In_Verb = {
  In_Free,
  In_Active,
  In_Inactive,
  BF_KeyPress,
  BF_ResizeNop,
  In_Draw,
};

static int In_Free(void *ptr)
{
  DfInfo *info;

  info = ptr;

  bFree(info);

  return 0;
}

static int In_Active(Widget w, void *ptr)
{
  return 0;
}

static int In_Inactive(Widget w, void *ptr)
{
  return 0;
}


static int In_Draw(void *ptr, struct DfDrawInfo *di)
{
  DfInfo *info;
  DfFile *f;
  int x;
  int y;
  int len;
  int cx;
  struct tm *tm;
  char buf[64];

  info = ptr;
  if(!info->l){
    return 0;
  }

  if(info->l->b.nItems <= info->l->b.nCur){
    return 0;
  }

  f = info->l->files[info->l->b.nCur];
  y = vnFontBase;

  XSetForeground(di->d, di->gc, vOptions.colors[COLOR_FILE]);

  XmbDrawString(di->d, XtWindow(di->w), vFontSet, di->gc, 0, y, f->name, strlen(f->name));
  
  /* modes */
  y += vnFontHeight;
  strMode(buf, f->attr);
  cx = XmbTextEscapement(vFontSet, buf, 10);
  XmbDrawString(di->d, XtWindow(di->w), vFontSet, di->gc, 0, y, buf, 10);
  x = cx + 8;

  /* size */
  if(sizeof(f->size) == sizeof(long long int)){
    len = sprintf(buf, "%lld", (long long int)f->size);
  }else{
    len = sprintf(buf, "%ld", (long int)f->size);
  }
  cx = XmbTextEscapement(vFontSet, buf, len);
  x = vnFontHeight * 10 - cx;
  XmbDrawString(di->d, XtWindow(di->w), vFontSet, di->gc, x, y, buf, len);
  x = vnFontHeight * 10 + 8;

  /* mtime */
  tm = localtime(&f->mtime);
  len = strftime(buf, sizeof(buf), "%Y-%m-%d %H:%M:%S", tm);
  cx = XmbTextEscapement(vFontSet, buf, len);
  XmbDrawString(di->d, XtWindow(di->w), vFontSet, di->gc, x, y, buf, len);

  if(!f->link){
    return 0;
  }

  y += vnFontHeight;
  XmbDrawString(di->d, XtWindow(di->w), vFontSet, di->gc, 0, y, f->link, strlen(f->link));

  return 0;
}

int ToggleInfo(Widget w, DfFileList *l)
{
  if(Info){
    return KillInfo(w);
  }else{
    return ShowInfo(w, l);
  }
}

struct info_resize{
  Widget w;
  int height;
  int cy;
};

static int enum_resize_info(DfBuf *b, void *ptr)
{
  struct info_resize *i = ptr;
  int bottom;

  if(!IS_VISIBLE(b)){
    return 0;
  }

  switch(b->type){
  case DT_PROMPT:
    break;
  default:
    b->rc.y += i->height;
    if(i->cy <= b->rc.y){
      b->rc.height = 0;
      UnlinkBuffer(i->w, b);
      return 0;
    }

    bottom = b->rc.y + b->rc.height;
    if(i->cy < bottom){
      /* just fit */
      b->rc.height = i->cy - b->rc.y;
      if(b->v && b->v->resize){
	(*b->v->resize)(i->w, b);
      }
    }
  }
  return 0;
}

int ShowInfo(Widget w, DfFileList *l)
{
  DfInfo *info;
  struct info_resize i;

  if(Info){
    return 0;
  }

  info = bMalloc(sizeof(*info));
  if(!info){
    return 1;
  }

  i.height = vnFontHeight * 3 + vOptions.borderWidth;
  i.cy = dfx->height - vnFontHeight;/* for status area */
  i.w = w;

  memset(info, 0, sizeof(*info));
  info->b.rc.x = 0;
  info->b.rc.y = 0;
  info->b.rc.width = dfx->width;
  info->b.rc.height = i.height;
  info->b.v = &In_Verb;

  dfx->frame_y = info->b.rc.height;

  EnumBuffers(dfx->lists, enum_resize_info, &i);

  info->b.type = DT_INFO;
  info->b.stat = BS_VISIBLE | BS_DRAWBOTTOMEDGE;

  info->l = l;

  Info = info;
  AddBuffer(dfx->lists, GetBuffer(info));

  InvalidateWindow(w);

  return 0;
}

static int enum_kill_info(DfBuf *b, void *ptr)
{
  struct info_resize *i = ptr;
  int bottom;

  if(!IS_VISIBLE(b)){
    return 0;
  }

  switch(b->type){
  case DT_PROMPT:
    break;
  default:
    bottom = b->rc.y + b->rc.height;
    b->rc.y -= i->height;
    if(i->cy <= bottom){
      /* extend */
      b->rc.height = i->cy - b->rc.y;
      if(b->v && b->v->resize){
	(*b->v->resize)(i->w, b);
      }
    }
  }
  return 0;
}

int KillInfo(Widget w)
{
  struct info_resize i;

  if(!Info){
    return 0;
  }

  dfx->frame_y = 0;

  i.height = Info->b.rc.height;
  i.cy = dfx->height - vnFontHeight;
  i.w = w;
  EnumBuffers(dfx->lists, enum_kill_info, &i);

  if(dfx->lists == (DfBuf*)Info){
    dfx->lists = NextBuffer(Info);
  }
  ListDel(Info);
  In_Free(Info);
  Info = NULL;

  InvalidateWindow(w);

  return 0;
}

int RedrawInfo(Widget w)
{

  if(Info){
    RedrawFrame(w, GetBuffer(Info), &Info->b.rc);
  }

  return 0;
}

int SetInfo(Widget w, DfFileList *l)
{

  if(Info){
    Info->l = l;
    return RedrawInfo(w);
  }

  return 0;
}

static int strRWX(char *buf, mode_t mode)
{
  buf[0] = mode & 4 ? 'r' : '-';
  buf[1] = mode & 2 ? 'w' : '-';
  buf[2] = mode & 1 ? 'x' : '-';

  return 0;
}

static int strMode(char *buf, mode_t mode)
{
  char *p;
  p = buf;
  switch(mode & S_IFMT){
  case S_IFSOCK:
    *p = 's';
    break;
  case S_IFLNK:
    *p = 'l';
    break;
  case S_IFBLK:
    *p = 'B';
    break;
  case S_IFDIR:
    *p = 'd';
    break;
  case S_IFCHR:
    *p = 'C';
    break;
  case S_IFIFO:
    *p = 'f';
    break;
  default:
    *p = '-';
  }
  p++;
  strRWX(p, mode >> 6);
  p += 3;
  strRWX(p, mode >> 3);
  p += 3;
  strRWX(p, mode);

  return 0;
}


