#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "status.h"
#include "cmdlist.h"
#include "cmdinput.h"
#include "task.h"
#include "cmd.h"
#include "misc.h"
#include "mem.h"
#include "extmacro.h"
#include "dfxfunc.h"
#include "dfval.h"
#include "debug.h"

static int linkFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st);
static int symlinkFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st);

task_vtable vtable_link = {
  commonInvoke,
  commonNotify,
  commonDone,
  commonInit,
  commonProcSelectedFile,
  commonProcSubDirectories,
  linkFileOp
};

task_vtable vtable_symlink = {
  commonInvoke,
  commonNotify,
  commonDone,
  commonInit,
  commonProcSelectedFile,
  commonProcSubDirectories,
  symlinkFileOp
};


static int linkFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st)
{
  int ret;

  dprintf("link: %s -> %s\n", Str_Get(src), Str_Get(dst));

  ret = link(Str_Get(src), Str_Get(dst));
  if(ret != 0){
    ret = errno;
    t->err = ret;
    t->state = STATE_FAIL;
  }

  return ret;
}

static int symlinkFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st)
{
  int ret;
  DfStr rel;

  Str_RelativePath(&rel, dst, src);
  dprintf("symlink: %s -> %s (%s)\n", Str_Get(src), Str_Get(dst), Str_Get(&rel));
  ret = symlink(Str_Get(&rel), Str_Get(dst));
  Str_Free(&rel, 0);
  if(ret != 0){
    ret = errno;
    t->err = ret;
    t->state = STATE_FAIL;
    t->state = STATE_FAIL;
  }

  return ret;
}

