#include "list.h"

void ListClear(DfList *list)
{
  list->next = list;
  list->prev = list;
}

void *ListAdd(DfList *a, DfList *b)
{
  DfList *ptr;
  DfList *follow;

  if(a == b){
    return a;
  }
  ptr = a;
  follow = b;

  follow->next = ptr->next;
  follow->prev = ptr;
  follow->next->prev = follow;
  ptr->next = follow;

  return follow;
}

void *ListAddTail(DfList *a, DfList *b)
{
  return ListAdd(a->prev, b);
}

void *ListDel(void *a)
{
  DfList *ptr;
  DfList *prev;
  DfList *next;

  ptr = a;
  prev = ptr->prev;
  next = ptr->next;

  prev->next = next;
  next->prev = prev;

  ListClear(a);

  return ptr;
}

void *ListNext(void *ptr)
{
  DfList *buf;

  buf = ptr;
  return buf->next;
}

void *ListPrev(void *ptr)
{
  DfList *buf;

  buf = ptr;
  return buf->prev;
}

int ListIsEmpty(DfList *l)
{
  return l == l->next;
}
