typedef struct _dfStr{
  char *str;
  int len;/* used length of strings */
  int alloced_len;/*  allocated length */
}DfStr;

enum match_result{
  MATCH,
  HALFMATCH,
  UNMATCH
};

struct _multibyte_str{
  const char *str;
  int len;
  int c_len;
};
typedef struct _multibyte_str MbStr;

int Str_Init(DfStr *s);
int Str_InitStr(DfStr *s, const char *str);
int Str_Move(DfStr *d, DfStr *s);
int Str_Free(DfStr *s, int fFree);
int Str_Add(DfStr *s, const char *str);
int Str_AddNUL(DfStr *s, const char *str);
int Str_AddLen(DfStr *s, const char *str, int len);
int Str_Insert(DfStr *s, int idx, const char *str);
int Str_InsertEscape(DfStr *s, int idx, const char *str);
int Str_Delete(DfStr *s, int idx, int len);
int Str_Trim(DfStr *s);
int Str_AddChar(DfStr *s, char ch);
int Str_Overwrite(DfStr *s, int idx, const char *str);
int Str_Shrink(DfStr *s);
int Str_IsNull(DfStr *s);
int Str_Extend(DfStr *s, int len);

DfStr *Str_Dup(const DfStr *s);
int Str_InitNull(DfStr *s);
int Str_InitPsz(DfStr *s, const char *str);
char *Str_Get(const DfStr *s);
int Str_Length(const DfStr *s);
void Str_SetLength(DfStr *s, int len);
void Str_Reserve(DfStr *s, int len);
int Str_RegPath(DfStr *s, int bSlash, int mode);
int Str_RelativePath(DfStr *result, DfStr *src, DfStr *target);
DfStr *Str_Copy(DfStr *d, const DfStr *s);

#if MEMDEBUG
#define Str_Init(S) dbgStr_Init(S, __FILE__, __FUNCTION__, __LINE__)
#define Str_InitStr(S,T) dbgStr_InitStr(S, T, __FILE__, __FUNCTION__, __LINE__)
#define Str_Add(S, T) dbgStr_Add(S, T, __FILE__, __FUNCTION__, __LINE__)
#define Str_AddNUL(S, T) dbgStr_AddNUL(S, T, __FILE__, __FUNCTION__, __LINE__)
#define Str_AddChar(S, C) dbgStr_AddChar(S, C, __FILE__, __FUNCTION__, __LINE__)
#define Str_Overwrite(S, N, T) dbgStr_Overwrite(S,N, T,  __FILE__, __FUNCTION__, __LINE__)
#define Str_Shrink(S) dbgStr_Shrink(S, __FILE__, __FUNCTION__, __LINE__)
#define Str_Dup(S) dbgStr_Dup(S, __FILE__, __FUNCTION__, __LINE__)
#define Str_Free(S, T) dbgStr_Free(S, T, __FILE__, __FUNCTION__, __LINE__)

int dbgStr_Init(DfStr *s, const char *file, const char *func, int line);
int dbgStr_InitStr(DfStr *s, const char *str, const char *file, const char *func, int line);
int dbgStr_Add(DfStr *s, const char *str, const char *file, const char *func, int line);
int dbgStr_AddNUL(DfStr *s, const char *str, const char *file, const char *func, int line);
int dbgStr_AddChar(DfStr *s, char ch, const char *file, const char *func, int line);
int dbgStr_Overwrite(DfStr *s, int idx, const char *str, const char *file, const char *func, int line);
int dbgStr_Shrink(DfStr *s, const char *file, const char *func, int line);
DfStr *dbgStr_Dup(DfStr *s, const char *file, const char *func, int line);
int dbgStr_Free(DfStr *s, int f, const char *file, const char *func, int line);
#endif

#ifndef STR_DECLARE
#define Str_Get(S)    ((S)->str)
#define Str_Length(S) ((S)->len)
#define Str_Size(S)   ((S)->alloced_len)
#endif

void InitMbStr(MbStr  *p, const char *str);
char *MbNextChar(MbStr *p);
char *MbSkipChar(MbStr *p, int skip);
int MbFind(MbStr *p, MbStr *s);
char *FindChar(const char *p, char c);
char *FindLastChar(const char *p, char c);

int IsAbsPath(const char *path);
int IsDots(const char *path);
int StrEqChar(MbStr *a, MbStr *b);
int IsEndSlash(DfStr *path);
int IsSkipChar(MbStr *mb);
void SetLastSlash(DfStr *path);

int Str_Escape(DfStr *s);
int Str_Descape(DfStr *s);

