<?php {
  /*
   * $Id: dino_sql.php,v 1.68 2003/03/11 02:23:58 hanawa Exp $
   * Copyright(c) 2001-2003 Dino Co.,Ltd. All rights reserved.
   */

  /**
   * DinoɸSQLʸ饹ݥ饹
   *
   * ѾơĤΥơ֥ˤĤưĤΥ饹ޤ
   * ʣΥơ֥ˤޤ褦ʾϡ
   * Ȥʤơ֥Υ饹Ƥ֤褦ˤޤ
   *
   * 桼٥롿˱SQL֤褦ʵѰդƤޤ
   * 
   * 㤨С̥桼 class SQL_tableA_user extends Dino_SQL ʥ饹
   * Ԥʤ  class SQL_tableA_admin extends SQL_tableA_user ʥ饹
   * Ƥ֤褦ˤ줾˵줿SQLΤߤ֤褦ˤޤ
   *
   * ǰʤ顢˽ɬSQLǤݾڤΤԲǽǤ
   * ξϡƤӽФ¦ΥɤɬפϤǤ
   * ߥ򸺤餹ˤʤΤǤϤʤǤ礦ʤäȼ嵤ġ
   *
   * todo:
   * debug Ĥ
   *
   *@access public
   *@package Dino_SQL
   */
  class Dino_SQL {
    var $main_table = "";
    var $table = array(); // ơ֥̾롣xxx as A ߤʤΤ

    var $tableobj = array(); // ơ֥륪֥Ȥ롣
    var $alias = "";
    var $is_usedalias = array();


    var $select = array(); // 󤬶ʤ*ʳʤ,ڤŸ
    var $where = array();  // 

    var $groupby = "";
    var $having = "";

    var $orderby = "";
    var $desc = false; // orderby ǥȤơ true ʤս祽ȡ

    var $limit  = "";
    var $offset = "";

    // natural_jointable̾/field̾
    // Ƿ礹硢̤field̾Ƥ˽񤫤ʤȥ顼Ф롣
    var $common_field = array();

    var $debug = false;

    /**
     * ե̾򥭡˷̾ǼϢ
     *
     * set_condition()Ѥfield̾=>̾Υꥹȡ̵text
     *@access private
     */
    var $field_type = array();

    var $select_fields = array();

    /**
     * insertĤե̾Ǽ
     *
     * insertĤե̾
     * serialkeyϴޤʤ
     * ˤäƤpermissionȤѤɬפϤ
     *
     *@access private
     */
    var $insert_fields = array();
    /**
     * updateĤե̾Ǽ
     *
     * updateĤե̾
     * serialkeyϴޤʤ
     * ˤäƤpermissionȤѤɬפϤ
     *
     *@access private
     */
    var $update_fields = array();

    // (field => ɽ٤)б
    var $field_labels = array();

    /**
     * 󥹥ȥ饯
     *
     *@access public
     *@param string  $alias     aliasʸ
     */
    function Dino_SQL($alias = "") {
      if ($alias) {
	$this->set_alias($alias);
      }
    }

    /**
     * 
     *
     *@access public
     */
    function initialize() {
      $this->table = array();
      $this->select = array();
      $this->where = array();
      $this->orderby = "";
      $this->desc = false;
      $this->limit = "";
      $this->offset = "";
    }

    /**
     * ơ֥Υꥢ̾ꤹ
     *
     *@access public
     *@param string $alias ꥢ̾
     */
    function set_alias($alias) {
      if ($alias) {
	$this->alias = $alias;
      }
    }
    /**
     * ꥢ̾õ
     *
     *@access public
     *@param string $alias ꥢ̾
     */
    function unset_alias() {
      unset($this->alias);
    }
    /**
     * ȤΥơ֥θƤ̾
     *
     * ⤷ꥢ̾ꤵƤФ
     * ǤʤХơ֥֤̾ޤ
     *
     *@access public
     *@return string ơ֥̾ޤϥꥢ̾
     */
    function get_alias() {
      if ($this->alias) {
	return $this->alias;
      } else {
	return $this->main_table;
      }
    }

    /**
     * 
     *@access private
     *@return string ơ֥̾ޤϥꥢ̾
     */
    function get_from_clause($alias = "") {
      if (empty($alias)) {
	$alias = $this->get_alias();
      }
      if ($alias == $this->main_table) {
	$table = $alias;
      } else {
	$table = $this->main_table. " as ". $alias;
      }
      return $table;
    }

    /**
     * 
     *@access private
     *@return string ơ֥̾ޤϥꥢ̾
     */
    function get_all_where_clause($alias = "") {
      $where_array = array();
      foreach($this->where as $where) {
	$where_array[] = $where;
      }
      return sprintf(" where %s", implode(" and ", $where_array));
    }


    function traverse_sql_tree(&$table_array, $is_used = array()) {
      $alias = $this->get_alias();
      if ($is_used[$alias]) {
	// error!
	$array = array();
	return false;
      }
      $is_used[$alias] = true;
      $table_array[$alias] = $this->get_from_clause($alias);

      // $this->tableobj traverse
      foreach($this->tableobj as $obj) {
	$ret = $obj->traverse_sql_tree(&$table_array, &$is_used);
	if ($ret == false) {
	  $table_array = array();
	  return false;
	}
      }

      return true;
    }

    // var_arrayͤΤŬڤʤΤfield_labels֤ͤ
    function values2labels(&$var_array) {
      $this->apply_labels($var_array);
    }

    function apply_labels(&$var_array) {
      foreach($var_array as $name => $value) {
	$array = $this->field_labels[$name];
        if (isset($array)) {
	  $label = $array[$value];
	  if (isset($label)) {
	    $var_array[$name."__label"] = $label;
	  } else {
	    $var_array[$name."__label"] = $value;
	  }
	}
      }
    }

    function apply_labels2(&$vars) {
      $cnt = count($vars);
      for($i = 0; $i < $cnt; ++$i) {
	foreach($vars[$i] as $name => $value) {
	  if($this->field_labels[$name]) {
	    $label = $this->field_labels[$name][$value];
	    if(isset($label)) {
	      $vars[$i][$name.'__label'] = $label;
	    } else {
	      $vars[$i][$name.'__label'] = $value;
	    }
	  }
	}
      }
    }

    function set_labels($fname, $value, $label) {
      $this->field_labels[$fname][$value]=$label;
    }

    function get_labels($fname) {
      $a = $this->field_labels[$fname];
      if (is_array($a)) {
	return $a;
      } else {
	return array();
      }
    }

    // Υ饹selectʤɤƤӽФݤɬפwhereʤɤå
    function condition_check() {
      return true; // OK. Go ahead.
    }
    function condition_check_update() {
      return $this->condition_check();
    }
    function condition_check_delete() {
      return $this->condition_check();
    }

    /**
     * ֡ĤϡĤ()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition($field, $value) {
      $this->set_condition_op($field, "=", $value);
    }
    /**
     * ֡ĤϡĤ()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_eq($field, $value) {
      $this->set_condition_op($field, "=", $value);
    }
    /**
     * ֡ĤϡĤʤ()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_ne($field, $value) {
      $this->set_condition_op($field, "<>", $value);
    }
    /**
     * ֡ĤϡĤ꾮()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_lt($field, $value) {
      $this->set_condition_op($field, "<", $value);
    }
    /**
     * ֡ĤϡĤޤϤ꾮()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_le($field, $value) {
      $this->set_condition_op($field, "<=", $value);
    }
    /**
     * ֡ĤϡĤޤϤ꾮()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_max($field, $value) {
      $this->set_condition_op($field, "<=", $value);
    }
    /**
     * ֡ĤϡĤ礭()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_gt($field, $value) {
      $this->set_condition_op($field, ">", $value);
    }
    /**
     * ֡ĤϡĤޤϤ礭()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_ge($field, $value) {
      $this->set_condition_op($field, ">=", $value);
    }
    /**
     * ֡ĤϡĤޤϤ礭()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function set_condition_min($field, $value) {
      $this->set_condition_op($field, ">=", $value);
    }
    /**
     * ֡Ĥnullפꤹ
     *
     *@access public
     *@param string $field ե̾
     */
    function set_condition_null($field) {
      $this->where[$field] = $field. " is null";
    }
    /**
     * ֡Ĥnullפꤹ
     *
     * set_condition_null()оΤᡣ
     *
     *@access public
     *@param string $field ե̾
     */
    function set_condition_is_null($field) {
      $this->set_condition_null($field);
    }
    /**
     * ֡Ĥnullʤפꤹ
     *
     *@access public
     *@param string $field ե̾
     */
    function set_condition_is_not_null($field) {
      $this->where[$field."_is_not_null"] = $field. " is not null";
    }

    /**
     * likeפꤹ
     *
     * ΥեɤˤĤƤθ(where)Ȥ like 黻ҤȤޤ
     * like黻ҤǤ %  _ üʸǤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@param string $esc ʸ
     */
    function set_condition_like($field, $value, $esc = "") {
      if (isset($value)) {
	if (isset($esc)) {
	  $this->where[$field."_like"] = sprintf("%s like '%s' escape '%s'",
						 $field, (string)$value, $esc);
	} else {
	  $this->where[$field."_like"] = sprintf("%s like '%s'",
						 $field, (string)$value, $esc);
	}
      }
    }

    /**
     * ֡İʲİʾפꤹ
     *
     * ΥեɤˤĤƤθ(where)Ȥ between Ȥޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $from 
     *@param string $to 
     */
    function set_condition_between($field, $from, $to) {
      if (isset($from) && isset($to)) {
	$this->where[$field] = sprintf("%s between %s and %s",
				       $field,
				       $this->normalize_value($field, $from),
				       $this->normalize_value($field, $to));
      }
    }


    /**
     * եɤؤͤ
     *
     * եɤη˱ơ
     * whereαͤˤǤ褦string֤
     * Ǥʤͤξ϶ʸ֤
     * ƤʤtextȤߤʤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return string 
     */
    function normalize_value($field, $value) {
      /* SQLʸ˽񤱤褦ˤ뤿ᡢȤ򥨥פ */
      $value = str_replace ("'", "''", $value);
      $value = str_replace ('\\', '\\\\', $value);

      $type = $this->field_type[$field];
      if (!$type) {
	$type = "text";
      }
      if ($type == "integer") {
	if (strlen($value) == 0 ||
	    (((string)$value != "0") && ((int)$value == 0))) {
	  // 㥹Ȥ0ˤʤ뤬äݤͤꤵ줿ϤϤ
	  return "";
	}
	return sprintf("%d", (int)$value);
      } elseif ($type == "serial") {
	if ((int)$value <= 0) {
	  // ͰʳϤϤ
	  return "";
	}
	return sprintf("%d", (int)$value);
      } elseif ($type == "text") {
	return sprintf("'%s'", $value);
      } elseif ($type == "boolean") {
	return sprintf("'%s'", $value);
      } elseif ($type == "timestamp") {
	if (strcasecmp($value, "CURRENT_TIMESTAMP") == 0) {
	  return "CURRENT_TIMESTAMP";
	} else if (strcasecmp($value, "CURRENT_DATE") == 0) {
	  return "CURRENT_DATE";
	} else {
	  return sprintf("'%s'", $value);
	}
      } else {
	return sprintf("'%s'", $value);
      }
    }

    /**
     * 黻Ҥȶꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $op 黻
     *@param string $value 
     */
    function set_condition_op($field, $op, $value) {
      $opid_array = array(
			  "="    => "",
			  "<>"   => "_ne",
			  "<"    => "_max",
			  "<="   => "_max",
			  ">"    => "_min",
			  ">="   => "_min",
			  "like" => "",
			  );
      $opid = $opid_array[$op];
      if (!isset($opid)) {
	// Τʤ$opξ"="
	$op = "=";
      }

      $this->where["${field}${opid}"] = 
	 $this->get_where_clause_op($field, $op, $value);
    }

    /**
     * ե̾ͤwhere˽񤱤ʸ֤
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * whereˤΤޤ޽񤱤褦ʸ֤ޤ
     *
     * ŬڤǤʤͿ줿硢ʸ֤ޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function get_where_clause($field, $value='') {
      return $this->get_where_clause_op($field, "=", $value);
    }

    /**
     * ե̾ȱ黻Ҥͤwhere˽񤱤ʸ֤
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * whereˤΤޤ޽񤱤褦ʸ֤ޤ
     *
     * ŬڤǤʤͿ줿硢ʸ֤ޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $op 黻
     *@param string $value 
     */
    function get_where_clause_op($field, $op, $value='') {
      $value = $this->normalize_value($field, $value);
      if ($value == "") {
	return "";
      } else {
	return sprintf("%s %s %s", $field, $op, $value);
      }
    }

    /**
     * ե̾ͤwhere˽񤱤ʸ֤(obsolete)
     *
     * get_where_clause()θŤ̾
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function get_condition_string($field, $value='') {
      return $this->get_where_clause_op($field, "=", $value);
    }

    /**
     * ե̾ȱ黻Ҥͤwhere˽񤱤ʸ֤(obsolete)
     *
     * get_where_clause_op()θŤ̾
     *
     *@access public
     *@param string $field ե̾
     *@param string $op 黻
     *@param string $value 
     */
    function get_condition_string_op($field, $op, $value='') {
      return $this->get_where_clause_op($field, $op, $value);
    }



    // ͤΥեɤ򥻥å
    // :
    //   set_condition_int("proj_id", 2); // proj_id=2
    //   set_condition_int("proj_id", "<>", 3); // proj_id<>3
    /*
    function set_condition_int($field, $cond, $value="") {
      if (strlen($value) == 0) {
	$value = $cond; // "<", ">", etc...
	$cond = "=";
      }
      if (((string)$value == "0") || $value > 0) {
	$this->where[$field] = sprintf("%s%s%d", $field, $cond, (int)$value);
      }
    }
    */

    /**
     * obsolete
     *
     */
    function set_condition_str($field, $cond, $value="") {
      if (strlen($value) == 0) {
	$value = $cond; // "<", ">", etc...
	$cond = "=";
      }
      if (isset($value)) {
	$this->where[$field] = sprintf("%s%s'%s'", $field, $cond, (string)$value);
      }
    }

    /**
     * obsolete
     *
     */
    function set_condition_timestamp($field, $cond, $value="") {
      $this->set_condition_str($field, $cond, $value="");
    }

    /**
     * obsolete
     *
     */
    function set_condition_str_between($field, $from, $to) {
      if (isset($from) && isset($to)) {
	$this->where[$field] = sprintf("%s between '%s' and '%s'",
				       $field, (string)$from, (string)$to);
      }
    }


    /**
     * õ
     *
     * whereõޤ
     *
     *@access public
     */
    function unset_condition($field) {
      unset($this->where[$field]);
    }
    /**
     * õ
     *
     * ʣwhereʤɡ
     * ¾δؿǤʤwhere1ʬľꤷޤ
     *
     *@access public
     */
    function set_condition_directly($where) {
      if (strlen($where) > 0) {
	$this->where[$where] = $where;
      }
    }

    /**
     * 롼ײ˻Ȥܤꤹ
     *
     * group by ꤷޤ
     *
     *@access public
     *@param string $groupby group by ե̾
     */
    function set_groupby($groupby) {
      if (empty($groupby)) {
	$this->groupby = "";
      } else {
	$this->groupby = $groupby;
      }
    }

    /**
     * (˥롼ײ̤)ʤ߾ꤹ
     *
     * having ꤷޤ
     * "count(member) > 3"ʤɤȽɬפꡢ줷ؿǤ
     *
     *@access public
     *@param string $having having ե̾
     */
    function set_having($having) {
      if (empty($having)) {
	$this->having = "";
      } else {
	$this->having = $having;
      }
    }

    /**
     * Ȥõ
     *
     * order by õޤ
     *
     *@access public
     */
    function unset_orderby() {
      $this->set_orderby("");
    }

    /**
     * ȹܤս祽ȤȤꤹ
     *
     * order by descĤꤷޤ
     *
     *@access public
     *@param string $orderby order by ե̾
     */
    function set_orderby_desc($orderby) {
      $this->set_orderby($orderby, true);
    }

    /**
     * ȹܤꤹ
     *
     * order by ꤷޤ
     *
     *@access public
     *@param string $orderby order by ե̾
     *@param boolean $desc ...
     */
    function set_orderby($orderby, $desc = false) {
      if (empty($orderby)) {
	$this->orderby = "";
      } else {
	$this->orderby = $orderby;
      }
      if ($desc) {
	$this->desc = true;
      }
    } 

    /**
     * ̤νϷξ¤ꤹ
     *
     * limit ꤷޤ
     *
     *@access public
     *@param string $limit limitե̾
     */
    function set_limit($limit) {
      if ($limit >= 0) {
	$this->limit = (int)$limit;
      }
    } 

    /**
     * ̤νϤˤĤƥեåͤꤹ
     *
     * offset ꤷޤ
     *
     *@access public
     *@param string $offset offset ե̾
     */
    function set_offset($offset) {
      if ($offset >= 0) {
	$this->offset = (int)$offset;
      }
    }

    // 졢ȤΤåäƤɤġ
    function lock() {
      if (is_array($this->table) && sizeof($this->table) >= 1) {
	$table = implode(",", $this->table);
      } else {
	$table = $this->main_table;
      }

      $sql = sprintf("lock %s", $table);
      return $sql;
    }

    function begin() {
      return "begin";
    }
    function commit() {
      return "commit";
    }
    function rollback() {
      return "rollback";
    }

    /**
     * ơ֥η
     *
     *@access public
     *@param object Dino_SQL $obj 礷Dino_SQL֥ 
     *@return boolean
     */
    function join(&$obj) {
      if (!is_object($obj)) {
	return false;
      } else {
	$this->tableobj[] =& $obj;
      }
    }
    /**
     * ơ֥η򤹤븡ꤹ
     *
     *@access public
     *@param object Dino_SQL $obj 礷Dino_SQL֥ 
     *@param string $fields joinǷ礹ե
     */
    function set_condition_join_using($obj, $fields){
      $field = $fields;
      $this->where["${field}="] = sprintf("%s.%s=%s.%s", 
					  $this->get_alias(), $field,
					  $obj->get_alias(), $field);
    }
    /**
     * ơ֥η(join on)
     *
     *@access public
     *@param object Dino_SQL $obj 礷Dino_SQL֥ 
     *@param string $fields joinǷ礹ե
     *@return boolean
     */
    function join_using(&$obj, $fields) {
      $this->join($obj);
      $this->set_condition_join_using($obj, $fields);
    }
    // ¸ߤʤä""֤
    function get_joined_obj($alias){
      return $this;
    }


    // "$field_self=$table.$field" Ȥʤ褦ˡ$tablejoin롣
    function join_on($field_self, $table, $field = "") {
      if (!is_array($this->table) || sizeof($this->table) == 0) {
	$this->table = array($this->main_table);
      }
      $this->table[] = $table;

      if (ereg("^([^ \t\r\n]*)[ \t\r\n]+(as[ \t\r\n]+)?([^ \t\r\n]+)\s*$", $table, $regs)) {
	$table = $regs[3];
      }
      
      if (!is_array($field_self)) {

	if (ereg("^([^.]*)\.([^.]*)$", $field_self, $regs)) {
	  $table_self = $regs[1];
	  $field_self = $regs[2];
	} else {
	  //.ޤǤʤ硢main_tableΥեɡ
	  $table_self = $this->main_table;
	}
	if ($field == "") {
	  $field = $field_self;
	}

	$this->where[] = sprintf("%s.%s=%s.%s",
				 $table_self, $field_self,
				 $table, $field);

      } else if ($field == "") {
	reset($field_self);
	  while (list($k, $v) = each($field_self)) {
	    $this->where[] = sprintf("%s.%s=%s.%s",
				     $this->main_table, $v,
				     $table, $v);
	  }
      } else if (is_array($field_self) && is_array($field) &&
		 (sizeof($field_self) == sizeof($field))) {
	reset($field_self);
	reset($field);
	while (list($k1, $v1) = each($field_self)) {
	  list($k2, $v2) = each($field);
	  $this->where[] = sprintf("%s.%s=%s.%s",
				   $this->main_table, $v1,
				   $table, $v2);
	}
      }
    }

//    function join_using($table, $field) {
//      join_on($field, $table);
//    }

    // ꤲnatural join
    // ̤Υơ֥$table
    // $table."_id" Ȥprimary key¸ߤ
    // refer뼫ʬȤΥեɤˤĤơ
    // joinwhere񤯡
    // ȤǤΥե̾ۤʤ $field_self ǻꤹ롣
    // ʤ狼ˤΤǻȤ٤Ǥʤ
    //
    // $table: joinоݥơ֥̾
    // $field_self: ʬȤjoinоݤΥե̾(ά$table."_id")

    function natural_join($table, $field_self = "") {
      if (!is_array($this->table) || sizeof($this->table) == 0) {
	$this->table = array($this->main_table);
      }
      $this->table[] = $table;

      $field = $table."_id";
      if ($field_self == "") {
	$field_self = $field;
      }

      $this->where[$field] = sprintf("%s.%s=%s.%s",
				     $this->main_table, $field_self,
				     $table, $field);
    }

    /**
     * ˹礦selectʸ֤
     *
     * set_condition()ʤɤƤ˱SQLʸ֤
     * 顼ʤɤͳŬڤSQLʸФʤ硢ʸ֤
     *
     *@access public
     *@param string $select selectե̾ά"*"
     */

    function select($select = "") {
      if ($select)           { /* do nothing */ }
      elseif ($this->select) { $select = implode(",", $this->select); }
      else                   { $select = "*"; }
      
      if (is_array($this->table) && sizeof($this->table) > 0) {
	// do nothing
      } else {
	$this->table = array($this->main_table);
      }
      if (sizeof($this->tableobj) <= 0) {
	// for backward-compatibility
	$tables = implode(",", $this->table);
      } else {
	$table_array = array();
	$ret = $this->traverse_sql_tree(&$table_array);
	if ($ret == true) {
	  $tables = implode(",", $table_array);
	} else {
	  // ???
	  $tables = $this->main_table;
	}
      }
      $sql = sprintf("select %s from %s", $select, $tables);

      if (sizeof($this->where)) {
	$sql .= sprintf(" where %s", implode(" and ", $this->where));
      }
      if (!empty($this->groupby)) {
	$sql .= sprintf(" group by %s", $this->groupby);
      }
      if (!empty($this->having)) {
	$sql .= sprintf(" having %s", $this->having);
      }
      if (!empty($this->orderby)) {
	$sql .= sprintf(" order by %s", $this->orderby);
	if ($this->desc) {
	  $sql .= sprintf(" desc");
	}
      }
      if ($this->limit > 0)  { $sql .= sprintf(" limit %d", $this->limit); }
      if ($this->offset > 0) { $sql .= sprintf(" offset %d", $this->offset); }

      if (!$this->condition_check()) { 
	$this->_debug('select(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }

    /**
     * ˹礦selectʸ֤
     *
     * whereƤcount(*)SQL֤
     * group byʣ֤select()Ȥ
     *
     *@access public
     *@param string $field_name count(*)ˤĤ륨ꥢ̾ά"count"
     */
    function select_count($field_name = "count") {

      if (is_array($this->table) && sizeof($this->table) > 0) {
	// do nothing
      } else {
	$this->table = array($this->main_table);
      }

      $sql = sprintf("select count(*) as %s from %s",
		     $field_name,
		     implode(",", $this->table));

      if (sizeof($this->where)) {
	$sql .= sprintf(" where %s", implode(" and ", $this->where));
      }

      if (!$this->condition_check()) { 
	$this->_debug('select_count(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }

    function select_ncol() {
      return $this->select_count("ncol");
    }

    // obsoleteˤʤͽ
    function select_currval($seq_name = "") {
      if ($seq_name == "" && $this->main_table) {
	$seq_name = $this->main_table. "_". $this->main_table . "_id_seq";
      }
      return "select currval('$seq_name') as $seq_name";
    }

    // (insert)ơ֥primary keycurrval
    function select_curr_id() {
      if ($this->main_table) {
	$seq_name = $this->main_table. "_". $this->main_table . "_id_seq";
	$field_name = $this->main_table. "_id";
      }
      return "select currval('$seq_name') as $field_name";
    }


    // ʲΡDBؤѹ˴ؤؿΥѡߥåϡ
    // insert/updateǻؼʽ񤭴ԲĤʥ桼ФƤ϶ˤ
    // update/deletecondition_check()
    // dupϤɡ衩

    function insert_extra(&$fv) {
      // $fv򸫤ơɲäɬפʤΤˤreturn롣
      // ͤˤŪ''Ĥ뤫(select ...) ʤɤ񤱤롣
      // insert_fieldsΥåʤΤǡա
      return "";
    }

    function var2sqlval($field, &$varstr) {
      if ((string)$varstr == "\0") {
	return "null";
      } else {
	return $this->normalize_value($field, $varstr);
      }
    }

    function insert(&$fv) {
      if (!is_array($fv))            { $this->_debug2('insert()'); return ""; }
      if (!$this->insert_fields)     { $this->_debug2('insert()'); return ""; }

      $insert_f = ""; $insert_v = "";
      reset($this->insert_fields);
      while (list($k, $v) = each($this->insert_fields)) {
	if (isset($fv[$v])) {
	  $insert_f[] = $v;
	  $insert_v[] = $this->var2sqlval($v, $fv[$v]);
	} elseif (isset($this->where[$v]) &&
		  ereg("^${v}[ \t\r\n]*=[ \t\r\n]*(.*)$", $this->where[$v], $regs)) {
	  $insert_f[] = $v;
	  $insert_v[] = $regs[1];
	}
      }

      $extra_fv = $this->insert_extra($fv);
      if (is_array($extra_fv)) {
	reset($extra_fv);
	while (list($k, $v) = each($extra_fv)) {
	  $insert_f[] = $k;
	  $insert_v[] = $v; // ֥饹select'ʸ'
	}
      }

      if (empty($insert_f) || empty($insert_v)) {
	if (sizeof($this->insert_fields) == 0) {
	  // ¾ˤɤȡ
	  $sql = sprintf("insert into %s default values", $this->main_table);
	} else {
	  // ƤˤĤƥǥեͤ줿ǽ⤢뤬
	  // errorȤߤʤ٤
	  $sql = "";
	}
      } else {
	$sql = sprintf("insert into %s(%s) values(%s)",
		       $this->main_table,
		       implode(",", $insert_f),
		       implode(",", $insert_v));
      }
      return $sql;
    }
    function update(&$fv) {
      $db = "";
      return $this->update_if_modified($fv, $db);
    }

    // ƤʬΤ߹롣
    // PostgreSQLѤjoinƤäƤŬڤSQLϤ롣
    function update_if_modified(&$fv, &$db) {
      if (!is_array($fv))            { $this->_debug2('update()'); return ""; }
      if (!$this->update_fields)     { $this->_debug2('update()'); return ""; }

      $update_array = array();
      reset($this->update_fields);
      while (list($k, $v) = each($this->update_fields)) {
	//echo $k, $v, " - ", $fv[$v], "<br>";
	if (isset($fv[$v])) {
	  // updateоݤΥե
	  if (is_object($db) && ((string)($fv[$v]) === $db->f($v))) {
	    // äɬפϤʤ
	  } else {
	    $update_array[] = $v. "=". $this->var2sqlval($v, $fv[$v]);
	  }
	}
      }

      if ($update_array) {
	if (sizeof($this->where)) {
	  //ͤȰäƤĤäƤɤȽǤ롩
	  //$update_array[] = sprintf("n_click=0");
	  //$update_array[] = sprintf("last_acc_id=0");

	  $from_tables = array();
	  if (is_array($this->table) && sizeof($this->table) > 0) {
	    // main_table 
	    foreach ($this->table as $table) {
	      if ($table != $this->main_table) {
		$from_tables[] = $table;
	      }
	    }
	  }
	  
	  $sql = sprintf("update %s set %s",
			 $this->main_table,
			 implode(",", $update_array));
	  if (sizeof($from_tables) > 0) {
	    $sql .= " from ";
	    $sql .= implode(",", $from_tables);
	  }

	  $sql .= sprintf(" where %s", implode(" and ", $this->where));

	} else {
	  // whereʤ񤭴Τϥ顼Ȥߤʤ٤
	  $sql = "";
	}
      } else {
	// 񤭴Τʤʤ̵
      }
      if (!$this->condition_check_update()) { 
	$this->_debug('update(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }
    function delete() {
      if (!$this->condition_check_delete()) { return ""; }

      if (sizeof($this->where)) {
	$sql = sprintf("delete from \"%s\" where %s",
		       $this->main_table,
		       implode(" and ", $this->where));
      } else {
	// äΤϥ顼ˡ
	$sql = "";
      }

      return $sql;
    }

    function _debug ($fnname,&$val) {
      if ($this->debug) {
	echo "<B>$fnname</B>:<BR><TT>".
	  nl2br(HTMLSpecialChars($val)) .
	  "</TT><BR>";
      }
    }
    function _debug2 ($fnname) {
      if ($this->debug) {
	echo "<B>$fname</B><BR>";
      }
    }
  }
  class SQL extends Dino_SQL{
    function SQL(){
      parent::Dino_SQL();
    }
  };

}?>
