<?php {
  /*
   * $Id: common-func.php,v 1.28 2003/10/03 01:53:21 hanawa Exp $
   * Copyright(c) 2001-2003 Dino Co.,Ltd. All rights reserved.
   *
   * dinolib ̥󥯥롼ɴؿ
   * 
   */

  /**
   * version_compare μؿ
   *
   * version_compare ƤʤСPHPˤϼ롣
   *
   * @author tumf
   * @access public
   * @package default
   */
  function imprement_version_compare(){
    if (!function_exists('version_compare')){
      function version_compare($ver1, $ver2, $op='noop'){
	$v1 = explode('.', $ver1);
	$v2 = explode('.', $ver2);

	$ret = 0;
	for ($i = 0; $i <= 2; $i++){
	  if ($v1[$i] < $v2[$i]){
	    $ret = -1;
	    break;
	  }
	  if ($v1[$i] > $v2[$i]){
	    $ret = 1;
	    break;
	  }
	}
	switch ($op){
	default:
	case 'noop':{
	  break;
	}
	case '<':
	case 'lt':{
	  if ($ret == -1)    {
	    $ret = 1;
	  }else{
	    $ret = 0;
	  }
	  break;
	}
	case '<=':
	case 'le':{
	  if ($ret == -1 || $ret == 0){
	    $ret = 1;
	  } else {
	    $ret = 0;
	  }
	  break;
	}
	case '>':
	case 'gt':{
	  if ($ret == 1){
	    $ret = 1;
	  }else{
	    $ret = 0;
	  }
	  break;
	}
	case '>=':
	case 'ge':{
	  if ($ret == 0 || $ret == 1){
	    $ret = 1;
	  } else{
	    $ret = 0;
	  }
	  break;
	}
	case '==':
	case '=':
	case 'eq':{
	  if ($ret == 0){
	    $ret = 1;
	  }else{
	    $ret = 0;
	  }
	  break;
	}
	case '!=':
	case '<>':
	case 'ne':{
	  if ($ret == -1 || $ret == 1){
	    $ret = 1;
	  }else{
	    $ret = 0;
	  }
	  break;
	}
	}
	return $ret;
      }
    }
  }
  imprement_version_compare();

  /**
   * Хѿ
   * 
   * 4.1 ̤ΥСPHP
   * global ѿȤưƤѿ򤽤ʸΥСǤ
   * Ȥ뤿δؿ
   *
   * @author tumf
   * @access public
   * @package default
   */
  function global_var($varname){
    if($varname == "HTTP_HOST"){
      if(isset($GLOBALS[$varname])){
	return $GLOBALS[$varname];
      }else{
	return $_SERVER["HTTP_HOST"];
      }
    }

    if($varname == "SERVER_NAME"){
      if(isset($GLOBALS[$varname])){
	return $GLOBALS[$varname];
      }else{
	return $_SERVER["SERVER_NAME"];
      }
    }

    if($varname == "PHP_SELF"){
      if(isset($GLOBALS[$varname])){
	return $GLOBALS[$varname];
      }else{
	return $_SERVER["PHP_SELF"];
      }
    }


    if($varname == "HTTPS"){
      if(isset($GLOBALS[$varname])){
	return $GLOBALS[$varname];
      }else{
	return $_SERVER["HTTPS"];
      }
    }


    return $GLOBALS[$varname];
  }

  /**
   * $_REQUESTѿ
   *
   * 4.1.0 ̤PHPˤ$_REQUESTƤʤΤ
   * $GLOBALS
   *
   * @access public
   * @package default
   */
  function request_var($varname){
    if(version_compare(PHP_VERSION,"4.1.0",">=")==1){
      if($GLOBALS[$varname]) {
	return $GLOBALS[$varname];
      }
      return $_REQUEST[$varname];
    }
    return $GLOBALS[$varname];
  }

  /**
   * $_REQUESTѿ񤭤
   *
   * 4.1.0 ̤PHPˤ$_REQUESTƤʤΤ
   * $GLOBALS񤭤롣
   *
   * @access public
   * @package default
   */
  function set_request_var($varname,$var){
    if(version_compare(PHP_VERSION,"4.1.0",">=")==1){
      $GLOBALS[$varname] =$var;
      $_REQUEST[$varname] = $var;
    }else{
      $GLOBALS[$varname] =$var;
    }
  }

  /**
   *
   * @access public
   * @package default
   */
  function abs_url_internal($mode) {
    // $mode: 1 - rootdir / 2 - currdir / 3 - currfile

    if (global_var("HTTPS") == "on") { $scheme = "https://"; }
    else { $scheme = "http://"; }
    $http_host = global_var("HTTP_HOST");

    if (empty($http_host)) {
      $http_host = global_var("SERVER_NAME");
      $server_port = global_var("SERVER_PORT");
      if ($server_port && ($server_port != 80)) {
	$http_host .= ":$server_port";
      }
    }

    if ($mode == 1) {
      $script_name = "";
    } else if (ereg("^(/.*/)?([^\?/]*)$", global_var("PHP_SELF"), $regs)) {
      if ($mode == 2) {
	$script_name = $regs[1];
      } else if ($mode == 3) {
	$script_name = $regs[1] . $regs[2];
      } else {
	// ?????
	$script_name = "/";
      }
    } else {
      // ?????
      $script_name = "/";
    }
    $ret = sprintf("%s%s%s",
		   $scheme, $http_host, $script_name);
    return $ret;
  }

  // returns http://www.dino.co.jp
  function abs_url_of_root_dir() {
    return abs_url_internal(1);
  }
  // returns http://www.dino.co.jp/path/to/
  function abs_url_of_current_dir() {
    return abs_url_internal(2);
  }
  // returns http://www.dino.co.jp/path/to/file
  function abs_url_of_current_file() {
    return abs_url_internal(3);
  }

  /**
   * Location:إåϤ
   *
   * URL(?)˼äơRFCŪURL
   * 쥹ݥ󥹥إåLocation:פϤ롣
   * (J-PHONEθŤʤɡURLǽϤȥפǤʤȤ)
   *
   * ./../Ϥʤ
   * ŪˤƱǥ쥯ȥΥեե̾˽񤤤ƻȤ
   */
  function header_abs_location($url) {
    $sid = "";
    if (defined("SID")) {
      // GETǥåѿϤƤΤSIDƤ
      $sid = SID;
      if ($sid) {
	if (ereg("\?", $url)) {
	  $url .= "&$sid";
	} else {
	  $url .= "?$sid";
	}
      }
    }

    if (ereg("^https?:\/\/", $url)) {
      header ("Location: " . $url);
    } elseif (ereg("^/", $url)) {
      header ("Location: " . abs_url_internal(1) . $url);
    } else {
      //header("Location: " . abs_url_of_current_dir() . $url);
      header("Location: " . abs_url_internal(2) . $url);
    }
  }

  /**
   * Το$total Τ$numϲ%ˤʤ뤫ʸ֤
   *
   * ʲ2ޤǽФȤˤ롣
   * $total0ä硢0.00֤
   * λͤˤʤϤδؿ˰Ϥ˥å٤
   *
   *
   */
  function my_percent_str($num, $total) {
    if ($total == 0) {
      return "0.00";
    }
    return sprintf("%.2f", ($num * 100.0 / $total));
  }

  /**
   *  $keyname  get/post 饰Хѿˤ
   * 
   * pkey λ:
   * 1ʾĹʸ  ͷ(int/serial/datatime/timespan)
   * 
   * $_GET[$keyname]ӡ$_GET[$keyname]  stringǤȲꤷƤޤ
   * $_GET[$keyname] = 0 λGLOBAL˥åȤޤ
   * POSTGETͥ褵ޤ
   *
   * @author tumf
   * @return boolean $keynamepkeyȤХѿ˥åȤtrue
   * @access public
   * @param string $keyname globalѿȤʤGET/POSTѿ̾
   */
  function import_pkey_from_query($keyname){
    global $$keyname;
    // POST
    if(strlen($_POST[$keyname])>0){
      $$keyname=$_POST[$keyname];
      return true;
    }

    //GET
    if(strlen($_GET[$keyname])>0){
      $$keyname=$_GET[$keyname];
      return true;
    }
    return false;
  }



  function globalize_get_post_vars($varname){
    if (empty($_GET[$varname])) {
      if (empty($_POST[$varname])) {
	return false;
      }else{
	$GLOBALS[$varname]=$_POST[$varname];
      }
    }else{
      $GLOBALS[$varname]=$_GET[$varname];
    }
    return true;
  }


  function strip_quotes_query_string() {
    if(ini_get(magic_quotes_gpc)) {
      foreach ($_REQUEST as $key => $val){
	$GLOBALS[$key] = stripslashes($val);
      }
    }
  }

  // PEAR::setErrorHandlingѤcallbackؿ
  function show_detailed_error(&$obj) {
    if(PEAR::isError($obj)) {
      $ttl = $obj->GetMessage();
      $userinfo = $obj->GetUserInfo();
      if($pos = strpos($userinfo, '[nativecode')) {
        $before = substr($userinfo, 0, $pos);
        $userinfo = substr($userinfo, $pos);
      }
?>
<style type="text/css">
<!--
.err { background-color: #FFFFFF; padding: 5px; }
.ttl { font-size: 18px; color: #EE0000; font-weight: bold }
.bfr { font-size: 15px; color: #005500; line-height: 30px; }
.txt { font-size: 15px; color: #0000EE; line-height: 20px; }
//-->
</style>
<p class="err">
<span class="ttl"><?php echo $ttl ?></span><br>
<?php if($before) { ?><span class="bfr"><?php echo $before ?></span><br><?php } ?>
<span class="txt"><?php echo $userinfo ?></span></p>
<?php
      exit;
    }
    return $obj;
  }

} ?>
