<?php {

  /*
   * Copyright(c) 2001-2003 Dino Co.,Ltd. All rights reserved.
   */

  /**
  * error handling function
  *
  *@package Dino_DB
  *@access private
  *@param object $obj å֥
  *@return object Ϥ줿֥
  */
  function &check_db_error(&$obj) {
    if(DB::isError($obj)) {
      $ttl = $obj->GetMessage();
      $userinfo = $obj->GetUserInfo();
      if($pos = strpos($userinfo, '[nativecode')) {
        $before = substr($userinfo, 0, $pos);
        $userinfo = substr($userinfo, $pos);
      }
      
      // backtrace for PHP4.3
      // 顼ˤʤäʤȤƤRCȤĤƤӤǤ󵤤
      if(PHP_VERSION >= 4.3){
	$bt =  debug_backtrace();

	$btshow  = "<h2>Debug backtrace result</h2>";
	$btshow .= "<table border=1 cellpadding=3>";
	$btshow .= "<tr><th>Original file</th><td>" . $bt[1][file] . "</td></tr>";
	$btshow .= "<tr><th>Line</th><td>" . $bt[1][line] . "</td></tr>";
	$btshow .= "<tr><th>Class</th><td>" . $bt[1]['class'] . "</td></tr>";
	$btshow .= "<tr><th>Class file</th><td>" . $bt[0]['file'] . "</td></tr>";
	$btshow .= "<tr><th>Function</th><td>" . $bt[1]['function'] . "</td></tr>";
	foreach($bt[1]['args'] as $k => $v){
	  $btshow .= "<tr><th>Args($k)</th><td>$v</td>";
	}
	$btshow .= "</table>";

      }

      //print "<pre>";
      //print_r($bt);

?>


<style type="text/css">
<!--
.err { background-color: #FFFFFF; padding: 5px; }
.ttl { font-size: 18px; color: #EE0000; font-weight: bold }
.bfr { font-size: 15px; color: #005500; line-height: 30px; }
.txt { font-size: 15px; color: #0000EE; line-height: 20px; }
//-->
</style>
<p class="err">
<span class="ttl"><?php echo $ttl ?></span><br>
<?php if($before) { ?><span class="bfr"><?php echo $before ?></span><br><?php } ?>
<span class="txt"><?php echo $userinfo ?></span></p>

<? echo  $btshow; ?>
<?php
      exit;
    }
    return $obj;
  }

} ?>
