<?php {
  /*
   * $Id: dino_sql.php,v 1.121 2003/11/27 13:39:07 noriko Exp $
   * Copyright(c) 2001-2003 Dino Co.,Ltd. All rights reserved.
   */

  /**
   * DinoɸSQLʸ饹SQLӥ/ݥ饹
   *
   * ϤSQLξܺ٤ꤷSQLʸ֤Υ饹Ǥ
   * Υ饹Ѿơǡ١ΰĤTABLEˤĤ
   * Ĥζݥ饹ޤ
   * ʣΥơ֥ˤޤ褦SQLꤿˤϡ
   * SQL֥ȤФ̤SQL֥Ȥjoin뤳ȤǤޤ
   *
   * 㤨Сtestơ֥ˤĤƤΥ饹Test_SQLˤĤơ
   * 
   * $test_sql = new Test_SQL;
   * $test_sql->initialize()
   * $test_sql->set_condition("name", "dino");
   * $test_sql->set_condition("value", 2003);
   * $test_sql->set_orderby("atime");
   * $sql = $test_sql->select();
   * 
   * Ȥȡ$sqlˤ
   * "select * from test where name='dino' and value=2003 order by atime"
   * ȤʸϤǤTest_SQLǤ
   * 
   * SQLʸ֤᥽åɤ select() / insert / update() delete() ʤɤǤ
   * 
   * Υ饹ȤåȤϰʲΤ褦ˤޤ
   * 
   * (1)SQLҤɸಽ
   * 
   * ץSQLʸ80ʸĶΤ¿ɤߤˤΤǤ
   * SQL˴ؤƥɸƤȤäʹȤޤ
   * ޤʬSQLʸʸ˳ǼˡϿͤ줾Ǥ
   * ˳Ǽ뤳Ȥ⤢СʸϢ뤹뤳Ȥ⤢Ǥ礦
   * Τ褦ˡSQLʸľܽ񤤤Ƥȡ
   * ʣͿǤγȯ˥ƥʥ򲼤ǽޤ
   * Υ饹ȤɸಽǽǤ
   * 
   * (2)SQLФϤSQLʸˡ顼ˤʤꥹ㸺
   *
   * ưSQLʸ뤿ᡢդ䥨顼å­ˤä
   * SQLǽưǺ꾮Ȥħޤ
   *
   * äˡ͡ȹ礻where­­ʤäꤹˤϡ
   * SQL顼ˤʤꥹ򸺤餻ϤǤ
   *
   * ޤƥơ֥бݥ饹ơ֥λĥեɤ
   * ̾䷿ξäƤꡢ
   * ƥ᥽åɤ礬ʤɤåԤᡢ
   * ե̾δְ㤤ʤɤΥ쥹ߥɤȤǤޤ
   * 
   * (3)桼٥롿˱SQL֤뤳
   * 
   * ݥ饹ǡեɤȤinsertupdateβ/ԲĤǤΤǡ
   * 桼Ȥ˰SQLȯԤݾڤǤ褦ˤʤޤ
   *
   * 㤨С̥桼 class SQL_tableA_user extends Dino_SQL 
   * Ǥ륯饹
   * Ԥʤ class SQL_tableA_admin extends SQL_tableA_user 
   * ǤƤ֤褦ˤ줾˵줿SQLΤߤ֤褦ˤ
   * ԤΤߤǤեɤSQL_tableA_adminˤΤ
   * Ҥ뤳ȤǡSQLʸϤ뤳ȤǤޤ
   *
   *
   * ǰʤ顢Υ饹SQLʸǤäƤ
   * Ф˥顼ФʤȤݾڤϤޤ
   * ʤȤƥơ֥бSQL饹ǤɬפϤޤ
   * ξϡƤӽФ¦ΥɤǤ⥨顼åɬפǤ礦
   * ȤϤߥ򸺤餹ˤϤʤȹͤƤޤ
   *
   * todo:
   * debug Ĥ
   *
   *@access public
   *@package Dino_SQL
   */
  
  // {{{ constants
  // {{{ error codes
  /*
   * see DB.php
   */
  
  define("SQL_OK",                         1);
  define("SQL_ERROR",                     -1);
  define("SQL_ERROR_SYNTAX",              -2);
  define("SQL_ERROR_CONSTRAINT",          -3);
  define("SQL_ERROR_NOT_FOUND",           -4);
  define("SQL_ERROR_ALREADY_EXISTS",      -5);
  define("SQL_ERROR_UNSUPPORTED",         -6);
  define("SQL_ERROR_MISMATCH",            -7);
  define("SQL_ERROR_INVALID",             -8);
  define("SQL_ERROR_NOT_CAPABLE",         -9);
  define("SQL_ERROR_TRUNCATED",          -10);
  define("SQL_ERROR_INVALID_NUMBER",     -11);
  define("SQL_ERROR_INVALID_DATE",       -12);
  define("SQL_ERROR_DIVZERO",            -13);
  define("SQL_ERROR_NODBSELECTED",       -14);
  define("SQL_ERROR_CANNOT_CREATE",      -15);
  define("SQL_ERROR_CANNOT_DELETE",      -16);
  define("SQL_ERROR_CANNOT_DROP",        -17);
  define("SQL_ERROR_NOSUCHTABLE",        -18);
  define("SQL_ERROR_NOSUCHFIELD",        -19);
  define("SQL_ERROR_NEED_MORE_DATA",     -20);
  define("SQL_ERROR_NOT_LOCKED",         -21);
  define("SQL_ERROR_VALUE_COUNT_ON_ROW", -22);
  define("SQL_ERROR_INVALID_DSN",        -23);
  define("SQL_ERROR_CONNECT_FAILED",     -24);
  define("SQL_ERROR_EXTENSION_NOT_FOUND",-25);
  define("SQL_ERROR_ACCESS_VIOLATION",   -26);
  define("SQL_ERROR_NOSUCHDB",           -27);
  define("SQL_ERROR_NOCONDITIONS",       -28);
  define("SQL_ERROR_NOSETVAR",           -29);
  define("SQL_ERROR_OTHERTABLE",         -30);
  define("SQL_ERROR_NO_WHERE_CLAUSE",    -31);
  define("SQL_ERROR_NO_PKEY_IN_WHERE",   -32);

  // }}}
  // {{{ warning codes
  /*
   * see DB.php
   */
  
  define('SQL_WARNING',           -1000);
  define('SQL_WARNING_READ_ONLY', -1001);

  require_once('PEAR.php');
  //require_once(DINOLIB_DIR . '/sql/dino_sql_error.php');
  
  class Dino_SQL extends PEAR {
    var $main_table = "";
    var $table = array(); // obsolete

    var $tableobj = array(); // joinDino_SQL classΥ󥹥󥹤Ǽ
    var $alias = "";
    var $is_usedalias = array();

    var $select = array(); // 󤬶ʤ*ʳʤ,ڤŸ
    var $where = array();  // 

    var $groupby = "";
    var $having = "";

    var $orderby = "";
    var $desc = false; // orderby ǥȤơ true ʤս祽ȡ

    var $limit  = "";
    var $offset = "";

    // natural_jointable̾/field̾
    // Ƿ礹硢̤field̾Ƥ˽񤫤ʤȥ顼Ф롣
    var $common_field = array();

    var $debug = false;

    /**
     * ե̾򥭡˷̾ǼϢ
     *
     * set_condition()Ѥfield̾=>̾Υꥹȡ̵text
     *@access private
     */
    var $field_type = array();

    var $select_fields = array();

    /**
     * insertĤե̾Ǽ
     *
     * insertĤե̾
     * serialkeyϴޤʤ
     * ˤäƤpermissionȤѤɬפϤ
     *
     *@access private
     */
    var $insert_fields = array();
    /**
     * updateĤե̾Ǽ
     *
     * updateĤե̾
     * serialkeyϴޤʤ
     * ˤäƤpermissionȤѤɬפϤ
     *
     *@access private
     */
    var $update_fields = array();

   /**
    * (field => ɽ٤)б
    *
    *@see set_labels(), get_labels()
    */
    var $field_labels = array();

   /**
    * primary keyȤƻꤵƤե̾
    *
    *@see get_pkey_name()
    */
    var $pkey_name = array();

   /**
    * ǧڥơ֥ΥȤʤäƤե̾
    *
    *@see get_akey_name()
    */
    var $akey_name = "";

   /**
    * foregin keyȤƻꤵƤե̾
    *
    *@see get_fkey_name()
    */
    var $fkey_name = array();

   /**
    * ǧڥơ֥뤬Ĥˤforegin key
    *
    */
    var $fkey_auth_ancestor = "";

    /**
     * 顼⡼
     *
     * @var     int
     * @access  private
     */
    var $error_mode = null;

    /**
     * PEAR_ERROR_TRIGGER ѤΥ顼ץ
     *
     * @var     int
     * @access  private
     */
    var $error_options = null;

    /**
     * SQL object
     * @access private
     */
    var $sql;

    /**
     * 󥹥ȥ饯
     *
     *@access public
     *@param string  $alias     aliasʸ
     */
    function Dino_SQL($alias = "") {
      $this->initialize();
      
      if ($alias) {
	$this->set_alias($alias);
      }

      $this->PEAR('SQL_Error');
    }

    /**
     * 
     *
     *@access public
     */
    function initialize() {
      $this->table = array();
      $this->tableobj = array();
      $this->select = array();
      $this->where = array();
      $this->orderby = "";
      $this->desc = false;
      $this->limit = "";
      $this->offset = "";
      $this->groupby = "";
    }

    function &raiseError($code = SQL_ERROR, $mode = null, $options = null,
                         $userinfo = null, $nativecode = null)
      {
	// The error is yet a SQL error object
	if (is_object($code)) {
	  // because we the static PEAR::raiseError, our global
	  // handler should be used if it is set
	  if ($mode === null && !empty($this->_default_error_mode)) {
	    $mode    = $this->_default_error_mode;
	    $options = $this->_default_error_options;
	  }
	  return parent::raiseError($code, null, $mode, $options, null, null, true);
        }
	
        return parent::raiseError(null, $code, $mode, $options, $userinfo,
                                  'SQL_Error', true);
    }

    /**
     * ơ֥Υꥢ̾ꤹ
     *
     *@access public
     *@param string $alias ꥢ̾
     */
    function set_alias($alias) {
      if ($alias) {
	$this->alias = $alias;
      }
    }
    /**
     * ꥢ̾õ
     *
     *@access public
     *@param string $alias ꥢ̾
     */
    function unset_alias() {
      unset($this->alias);
    }
    /**
     * ȤΥơ֥θƤ̾
     *
     * ⤷ꥢ̾ꤵƤФ
     * ǤʤХơ֥֤̾ޤ
     *
     *@access public
     *@return string ơ֥̾ޤϥꥢ̾
     */
    function get_alias() {
      if ($this->alias) {
	return $this->alias;
      } else {
	return $this->main_table;
      }
    }

    /**
     * 
     *@access private
     *@return string ơ֥̾ޤϥꥢ̾
     */
    function get_from_clause($alias = "") {
      if (empty($alias)) {
	$alias = $this->get_alias();
      }
      if ($alias == $this->main_table) {
	$table = $alias;
      } else {
	$table = $this->main_table. " as ". $alias;
      }
      return $table;
    }

    /**
     * 
     *@access private
     *@return string ơ֥̾ޤϥꥢ̾
     */
    function get_all_where_clause($alias = "") {
      $where_array = array();
      if ($alias) {
	// join˥ơ֥̾դ
	foreach($this->where as $where) {
	  $where_array[] = $alias.".".$where;
	}
	return implode(" and ", $where_array);
      }

      return implode(" and ", $this->where);
    }

    /**
     * primary keyΥե֤̾
     *
     *@return string primary keyΥե̾
     */
    function get_pkey_name(){
      return $this->pkey_name;
    }

    /**
     * ǧkeyΥե֤̾
     *
     *@return string ǧkeyΥե̾
     */
    function get_akey_name(){
      return $this->akey_name;
    }

    /**
     * foreign keyΥե֤̾
     *
     *@return string foreign fieldΥե̾
     */
    function get_fkey_name(){
      return $this->fkey_name;
    }

    /**
     * ƥơ֥SQL֥Ȥ֤
     *
     *@param $fkey foreign key
     *@return object ƥơ֥SQL֥/顼ξfalse
     */
    function get_ptbl_obj($fkey){
      return false;
    }

    //function get_akey_name(){
    //  return $this->akey_name;
    //}


    function traverse_sql_tree(&$select_array, &$from_array,
			       &$where_array, &$orderby_array,
			       $is_used = array()) {
      $alias = $this->get_alias();
      if ($is_used[$alias]) {
	// error!
	$array = array();
	return false;
      }

      $is_used[$alias] = true;
      $from_array[$alias] = $this->get_from_clause($alias);
      foreach($this->where as $where) {
	if (preg_match("/^[A-Za-z_]+[^A-Za-z_.]/", $where)) {
	  $where_array[] = $alias.".".$where;
	} else {
	  $where_array[] = $where;
	}
      }

      // ŪorderbyˤΤǡϤ⤦ץˤʤϤ
      if (!empty($this->orderby)) {
	$orderby = $this->orderby;
	if ($this->desc) {
	  $orderby .= sprintf(" desc");
	}
	$orderby_array[] = $alias.".".$orderby;
      }
      // $this->tableobj traverse
      foreach($this->tableobj as $obj) {
	$ret = $obj->traverse_sql_tree(&$select_array, &$from_array,
				       &$where_array, &$orderby_array,
				       &$is_used);
	if ($ret == false) {
	  $from_array = array();
	  return false;
	}
      }
      return true;
    }

    // var_arrayͤΤŬڤʤΤfield_labels֤ͤ
    function values2labels(&$var_array) {
      $this->apply_labels($var_array);
    }

    function apply_labels(&$var_array) {
      foreach($var_array as $name => $value) {
	$array = $this->field_labels[$name];
        if (isset($array)) {
	  $label = $array[$value];
	  if (isset($label)) {
	    $var_array[$name."__label"] = $label;
	  } else {
	    $var_array[$name."__label"] = $value;
	  }
	}
      }
    }

    function apply_labels2(&$vars) {
      $cnt = count($vars);
      for($i = 0; $i < $cnt; ++$i) {
	foreach($vars[$i] as $name => $value) {
	  if($this->field_labels[$name]) {
	    $label = $this->field_labels[$name][$value];
	    if(isset($label)) {
	      $vars[$i][$name.'__label'] = $label;
	    } else {
	      $vars[$i][$name.'__label'] = $value;
	    }
	  }
	}
      }
    }

   /**
    * Set labels.
    *
    * (field => ɽ٤)б
    *
    *@param string $fname field name
    *@param string $value field
    *@param string $label ٥(ɽ٤)
    */
    function set_labels($fname, $value, $label) {
      if($this->field_exists($fname)){
	$this->field_labels[$fname][$value]=$label;
      }
    }

   /**
    * Get labels
    *
    *@see set_labels()
    */
    function get_labels($fname) {
      if($this->field_exists($fname)){
	$a = $this->field_labels[$fname];
	if (is_array($a)) {
	  return $a;
	} else {
	  return array();
	}
      }
      return array();
    }

    // Υ饹selectʤɤƤӽФݤɬפwhereʤɤå
    function condition_check() {
      return true; // OK. Go ahead.
    }
    function condition_check_update() {
      return $this->condition_check();
    }
    function condition_check_delete() {
      return $this->condition_check();
    }

    /**
     * ֡ĤϡĤ()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition($field, $value) {
      return $this->set_condition_op($field, "=", $value);
    }
    /**
     *ѿץ饤ޥꥭ̾
     *֡ĤϡĤ()ꤹ
     *
     *ץ饤ޥꥭʣarray
     */
    function set_condition_pkey($value) {
      //ϥå
      if(is_array($value)){
	if(!is_array($this->pkey_name)){
	  echo "set_condition_pkey: ץ饤ޥꥭʣޤ";
	  exit;
	}else{
	$ok = false;
	foreach($this->pkey_name as $key => $pkey_name){
	  if($this->set_condition_op($pkey_name, "=", $value[$key]))
	    $ok = true;
	}	     
	return $ok;
	}
      }else{
	return $this->set_condition_op($this->pkey_name, "=", $value);
      }
    }
    /**
     * ֡ĤϡĤ()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_eq($field, $value) {
      return $this->set_condition_op($field, "=", $value);
    }
    /**
     * ֡ĤϡĤʤ()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_ne($field, $value) {
      return $this->set_condition_op($field, "<>", $value);
    }
    /**
     * ֡ĤϡĤ꾮()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_lt($field, $value) {
      return $this->set_condition_op($field, "<", $value);
    }
    /**
     * ֡ĤϡĤޤϤ꾮()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_le($field, $value) {
      return $this->set_condition_op($field, "<=", $value);
    }
    /**
     * ֡ĤϡĤޤϤ꾮()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_max($field, $value) {
      return $this->set_condition_op($field, "<=", $value);
    }
    /**
     * ֡ĤϡĤ礭()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_gt($field, $value) {
      return $this->set_condition_op($field, ">", $value);
    }
    /**
     * ֡ĤϡĤޤϤ礭()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_ge($field, $value) {
      return $this->set_condition_op($field, ">=", $value);
    }
    /**
     * ֡ĤϡĤޤϤ礭()ꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_min($field, $value) {
      return $this->set_condition_op($field, ">=", $value);
    }
    /**
     * ֡Ĥnullפꤹ
     *
     *@access public
     *@param string $field ե̾
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_null($field) {
      if ($this->field_exists($field)) {
	$this->where[$field] = $field. " is null";
	return 0;
      }
      return -1;
    }
    /**
     * ֡Ĥnullפꤹ
     *
     * set_condition_null()оΤᡣ
     *
     *@access public
     *@param string $field ե̾
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_is_null($field) {
      $this->set_condition_null($field);
      return 0;
    }
    /**
     * ֡Ĥnullʤפꤹ
     *
     *@access public
     *@param string $field ե̾
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_is_not_null($field) {
      if($this->field_exists($field)){
	$this->where[$field."_is_not_null"] = $field. " is not null";
	return 0;
      }
      return -1;
    }

    /**
     * likeפꤹ
     *
     * ΥեɤˤĤƤθ(where)Ȥlike黻Ҥꤷޤ
     * 3̾άѤޤ
     * 3ά硢%  _ üʸǤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@param string $esc ʸʾάǽ
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_like($field, $value, $esc = "") {
      if($this->field_exists($field)){
	if (isset($value)) {
	  if (isset($esc)) {
	    $this->where[$field."_like"] = sprintf("%s like '%s' escape '%s'",
						   $field, (string)$value, $esc);
	  } else {
	    $this->where[$field."_like"] = sprintf("%s like '%s'",
						   $field, (string)$value, $esc);
	  }
	  return 0;
	}
	$this->raiseError(SQL_ERROR_NOSETVAR,null,null,"No set variable for the condition about '$field'",null);
	return -1;
      }
      return -1;
    }

    /**
     * ֡İʲİʾפꤹ
     *
     * ΥեɤˤĤƤθ(where)Ȥ between Ȥޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $from 
     *@param string $to 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_between($field, $from, $to) {
      if($this->field_exists($field)){
	if (isset($from) && isset($to)) {
	  $this->where[$field] = sprintf("%s between %s and %s",
					 $field,
					 $this->normalize_value($field, $from),
					 $this->normalize_value($field, $to));
	  return 0;
	}
	$this->raiseError(SQL_ERROR_NOSETVAR,null,null,"No set variable for the condition about '$field'",null);
	return -1;
      }
      return -1;
    }


    /**
     * եɤؤͤ
     *
     * եɤη˱ơ
     * whereαͤˤǤ褦string֤
     * Ǥʤͤξ϶ʸ֤
     * ƤʤtextȤߤʤ
     *
     *@access private
     *@param string $field ե̾
     *@param string $value 
     *@return string 
     */
    function normalize_value($field, $value) {
      if($this->field_exists($field)){
	/* SQLʸ˽񤱤褦ˤ뤿ᡢȤ򥨥פ */
	$value = str_replace ("'", "''", $value);
	$value = str_replace ('\\', '\\\\', $value);
	
	$type = $this->field_type[$field];
	if (!$type) {
	  $type = "text";
	}

	if(strlen($value) == 0){
	  //valueͿʤΤϥ顼Ф̤
	  if ($type == "integer" || $type == "serial" || $type == "boolean") {
	    return "";
	  } else {
	    return "''";
	  }
	} elseif ($type == "integer") {
	  // 㥹Ȥ0ˤʤ뤬äݤͤꤵ줿ϤϤ
	  if( ((string)$value != "0") && ((int)$value == 0) ){
	    $result = $this->raiseError(SQL_ERROR_MISMATCH,null,null,"the type of '$field' does not match '$value'",null);
	    return "";
	  }
	  return sprintf("%d", (int)$value);
	} elseif ($type == "serial") {
	  if ((int)$value <= 0) {
	    // ͰʳϤϤ
	    $result = $this->raiseError(SQL_ERROR_MISMATCH,null,null,"'$value' must be positive number for serial field '$field'",null);
	    return "";
	  }
	  return sprintf("%d", (int)$value);
	} elseif ($type == "text") {
	  return sprintf("'%s'", $value);
	} elseif ($type == "boolean") {
	  return sprintf("'%s'", $value);
	} elseif ($type == "timestamp") {
	  if (strcasecmp($value, "CURRENT_TIMESTAMP") == 0) {
	    return "CURRENT_TIMESTAMP";
	  } else if (strcasecmp($value, "CURRENT_DATE") == 0) {
	    return "CURRENT_DATE";
	  } else {
	    return sprintf("'%s'", $value);
	  }
	} else {
	  return sprintf("'%s'", $value);
	}
      }
    }
    
    /**
     * 黻Ҥȶꤹ
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * ΥեɤˤĤƤθ(where)Ȥꤷޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $op 黻
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_condition_op($field, $op, $value) {
      if($this->field_exists($field)){
	$opid_array = array(
			    "="    => "",
			    "<>"   => "_ne",
			    "<"    => "_max",
			    "<="   => "_max",
			    ">"    => "_min",
			    ">="   => "_min",
			    "like" => "",
			    );
	$opid = $opid_array[$op];
	if (!isset($opid)) {
	  // Τʤ$opξ"="
	  $op = "=";
	}
	
	$where = $this->get_where_clause_op($field, $op, $value);
	if ($where) {
	  $this->where["${field}${opid}"] = $where;
	  return 0;
	} else {
	  return -1;
	}
      }
      return -1;
    }

    /**
     * ե̾ͤwhere˽񤱤ʸ֤
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * whereˤΤޤ޽񤱤褦ʸ֤ޤ
     *
     * ŬڤǤʤͿ줿硢ʸ֤ޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function get_where_clause($field, $value='') {
      return $this->get_where_clause_op($field, "=", $value);
    }

    /**
     * ե̾ȱ黻Ҥͤwhere˽񤱤ʸ֤
     *
     * ե̾鷿Ĵ١
     * ˱Ŭڤ˥㥹Ȥ
     * whereˤΤޤ޽񤱤褦ʸ֤ޤ
     *
     * ŬڤǤʤͿ줿硢ʸ֤ޤ
     *
     *@access public
     *@param string $field ե̾
     *@param string $op 黻
     *@param string $value 
     *@return string Ŭڤwhere1ġ顼ξ϶ʸ
     */
    function get_where_clause_op($field, $op, $value='') {
      if ($this->field_exists($field)) {
	$value = $this->normalize_value($field, $value);
	if ($value == "") {
	  return "";
	} else {
	  return sprintf("%s%s%s", $field, $op, $value);
	}
      } 
      return "";
      
    }

    /**
     * ե̾ͤwhere˽񤱤ʸ֤(obsolete)
     *
     * get_where_clause()θŤ̾
     *
     *@access public
     *@param string $field ե̾
     *@param string $value 
     */
    function get_condition_string($field, $value='') {
      return $this->get_where_clause_op($field, "=", $value);
    }

    /**
     * ե̾ȱ黻Ҥͤwhere˽񤱤ʸ֤(obsolete)
     *
     * get_where_clause_op()θŤ̾
     *
     *@access public
     *@param string $field ե̾
     *@param string $op 黻
     *@param string $value 
     */
    function get_condition_string_op($field, $op, $value='') {
      return $this->get_where_clause_op($field, $op, $value);
    }



    // ͤΥեɤ򥻥å
    // :
    //   set_condition_int("proj_id", 2); // proj_id=2
    //   set_condition_int("proj_id", "<>", 3); // proj_id<>3
    /*
    function set_condition_int($field, $cond, $value="") {
      if (strlen($value) == 0) {
	$value = $cond; // "<", ">", etc...
	$cond = "=";
      }
      if (((string)$value == "0") || $value > 0) {
	$this->where[$field] = sprintf("%s%s%d", $field, $cond, (int)$value);
      }
    }
    */

    /**
     * obsolete
     *
     */
    function set_condition_str($field, $cond, $value="") {
      if($this->field_exists($field)){
	if (strlen($value) == 0) {
	  $value = $cond; // "<", ">", etc...
	  $cond = "=";
	}
	if (isset($value)) {
	  $this->where[$field] = sprintf("%s%s'%s'", $field, $cond, (string)$value);
	}
      }
    }

    /**
     * obsolete
     *
     */
    function set_condition_timestamp($field, $cond, $value="") {
      $this->set_condition_str($field, $cond, $value="");
    }

    /**
     * obsolete
     *
     */
    function set_condition_str_between($field, $from, $to) {
      if($this->field_exists($field)){
	if (isset($from) && isset($to)) {
	  $this->where[$field] = sprintf("%s between '%s' and '%s'",
					 $field, (string)$from, (string)$to);
	}
      }
    }


    /**
     * õ
     *
     * whereõޤ
     *
     *@access public
     */
    function unset_condition($field) {
      if($this->field_exists($field)){
	unset($this->where[$field]);
      }
    }
    /**
     * ľꤹ
     *
     * ʣwhereʤɡ
     * ¾δؿǤʤwhere1ʬľꤷޤ
     *
     *@access public
     */
    function set_condition_directly($where) {
      if (strlen($where) > 0) {
	$this->where[$where] = $where;
      }
    }

    /**
     * 롼ײ˻Ȥܤꤹ
     *
     * group by ꤷޤ
     *
     *@access public
     *@param string $groupby group by ե̾
     */
    function set_groupby($groupby) {
      if (empty($groupby)) {
	$this->groupby = "";
      } else {
	$this->groupby = $groupby;
      }
    }

    /**
     * (˥롼ײ̤)ʤ߾ꤹ
     *
     * having ꤷޤ
     * "count(member) > 3"ʤɤȽɬפꡢ줷ؿǤ
     *
     *@access public
     *@param string $having having ե̾
     */
    function set_having($having) {
      if (empty($having)) {
	$this->having = "";
      } else {
	$this->having = $having;
      }
    }

    /**
     * Ȥ
     *
     * order by ޤ
     *
     *@access public
     */
    function unset_orderby() {
      $this->set_orderby("");
    }

    /**
     * ȹܤս祽ȤȤꤹ
     *
     * order by descĤꤷޤ
     *
     *@access public
     *@param string $orderby order by ե̾
     */
    function set_orderby_desc($orderby) {
      $this->set_orderby($orderby, true);
    }

    /**
     * ȹܤꤹ
     *
     * order by ꤷޤ
     *
     *@access public
     *@param string $orderby order by ե̾
     *@param boolean $desc ...
     */
    function set_orderby($orderby, $desc = false) {
      if (empty($orderby)) {
	$this->orderby = "";
      } else {
	$this->orderby = $orderby;
      }
      if ($desc) {
	$this->desc = true;
      }
    } 

    /**
     * ̤νϷξ¤ꤹ
     *
     * limit ꤷޤ
     *
     *@access public
     *@param string $limit Ϸξ
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_limit($limit) {
      if ($limit > 0) {
	$this->limit = (int)$limit;
	return 0;
      } else {
	$this->raiseError(SQL_ERROR_INVALID_NUMBER,null,null,"$limit is invalid for the LIMIT-clause", null);
	return -1;
      }
    } 

    /**
     * ̤νϷξ
     *
     * limit ޤ
     *
     *@access public
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function unset_limit() {
      $this->limit = 0;
      return 0;
    } 


    /**
     * ̤νϤˤĤƥեåͤꤹ
     *
     * offset ꤷޤ
     *
     *@access public
     *@param string $offset offset ե̾
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function set_offset($offset) {
    if ($offset >= 0) {
	$this->offset = (int)$offset;
	return 0;
    } else {
	$this->raiseError(SQL_ERROR_INVALID_NUMBER,null,null,"$offset is invalid for the OFFSET-clause",null);
	return -1;
      }

    }

    /**
     * եåͤ
     *
     * offset ޤ
     *
     *@access public
     *@param string $offset offset ե̾
     *@return int ｪλʤ0۾ｪλʤ-1
     */
    function unset_offset() {
      return $this->set_offset(0);
    }


    // 졢ȤΤåäƤɤġ
    function lock() {
      if (is_array($this->table) && sizeof($this->table) >= 1) {
	$table = implode(",", $this->table);
      } else if ($this->field_exists($field)) {
	$table = $this->main_table;
      }

      $sql = sprintf("lock %s", $table);
      return $sql;
    }

    function begin() {
      return "begin";
    }
    function commit() {
      return "commit";
    }
    function rollback() {
      return "rollback";
    }

    /**
     * ơ֥η
     *
     *@access public
     *@param object Dino_SQL $obj 礷Dino_SQL֥ 
     *@return boolean
     */
    function join(&$obj) {
      if (!is_object($obj)) {
	return false;
      } else {
	$this->tableobj[] =& $obj;
      }
    }
    /**
     * ơ֥η򤹤븡ꤹ
     *
     *@access public
     *@param object Dino_SQL $obj 礷Dino_SQL֥ 
     *@param string $fields joinǷ礹ե
     */
    function set_condition_join_using($obj, $fields, $cfields=""){
      if(!$cfields) {
	$cfields = $fields;
      }
      $field = $fields;
      $cfield = $cfields;
      if ($this->field_exists($field) && $obj->field_exists($cfield)) {
	$this->where["${field}="] = sprintf("%s.%s=%s.%s", 
					    $this->get_alias(), $field,
					    $obj->get_alias(), $cfield);
      } else {
	// 顼д˾夬äƤϤ
      }
    }
    /**
     * ơ֥η(join on)
     *
     *@access public
     *@param object Dino_SQL $obj 礷Dino_SQL֥ 
     *@param string $fields joinǷ礹ե
     *@return boolean
     */
    function join_using(&$obj, $fields, $fields2="") {
      $this->join($obj);
      $this->set_condition_join_using($obj, $fields, $fields2);
    }

    // ¸ߤʤä""֤
    function get_joined_obj($alias){
      return $this;
    }


    // "$field_self=$table.$field" Ȥʤ褦ˡ$tablejoin롣
    function join_on($field_self, $table, $field = "") {
      if (!is_array($this->table) || sizeof($this->table) == 0) {
	$this->table = array($this->main_table);
      }
      $this->table[] = $table;

      if (ereg("^([^ \t\r\n]*)[ \t\r\n]+(as[ \t\r\n]+)?([^ \t\r\n]+)\s*$", $table, $regs)) {
	$table = $regs[3];
      }
      
      if (!is_array($field_self)) {

	if (ereg("^([^.]*)\.([^.]*)$", $field_self, $regs)) {
	  $table_self = $regs[1];
	  $field_self = $regs[2];
	} else {
	  //.ޤǤʤ硢main_tableΥեɡ
	  $table_self = $this->main_table;
	}
	if ($field == "") {
	  $field = $field_self;
	}

	$this->where[] = sprintf("%s.%s=%s.%s",
				 $table_self, $field_self,
				 $table, $field);

      } else if ($field == "") {
	reset($field_self);
	  while (list($k, $v) = each($field_self)) {
	    //main_tableФƤΤfield¸ߥåǤФ⤦ФƤå򤫤
	    if($this->field_exists($field)){
	      $this->where[] = sprintf("%s.%s=%s.%s",
				       $this->main_table, $v,
				       $table, $v);
	    }
	  }
      } else if (is_array($field_self) && is_array($field) &&
		 (sizeof($field_self) == sizeof($field))) {
	reset($field_self);
	reset($field);
	while (list($k1, $v1) = each($field_self)) {
	  list($k2, $v2) = each($field);
	  //main_tableФƤΤfield¸ߥåǤФ⤦ФƤå򤫤
	  if($this->field_exists($field)){
	    $this->where[] = sprintf("%s.%s=%s.%s",
				     $this->main_table, $v1,
				     $table, $v2);
	  }
	}
      }
    }

//    function join_using($table, $field) {
//      join_on($field, $table);
//    }

    // ꤲnatural join
    // ̤Υơ֥$table
    // $table."_id" Ȥprimary key¸ߤ
    // refer뼫ʬȤΥեɤˤĤơ
    // joinwhere񤯡
    // ȤǤΥե̾ۤʤ $field_self ǻꤹ롣
    // ʤ狼ˤΤǻȤ٤Ǥʤ
    //
    // $table: joinоݥơ֥̾
    // $field_self: ʬȤjoinоݤΥե̾(ά$table."_id")

    function natural_join($table, $field_self = "") {
      if (!is_array($this->table) || sizeof($this->table) == 0) {
	$this->table = array($this->main_table);
      }
      $this->table[] = $table;

      $field = $table."_id";
      if ($field_self == "") {
	$field_self = $field;
      }

      $this->where[$field] = sprintf("%s.%s=%s.%s",
				     $this->main_table, $field_self,
				     $table, $field);
    }

    /**
     * ˹礦褦selectʸ֤
     *
     * set_condition()ʤɤƤ˱SQLʸ֤
     * 顼ʤɤͳŬڤSQLʸФʤ硢ʸ֤
     *
     *@access public
     *@param string $select selectե̾ά"*"
     *@return string selectʸʸ󡣥顼ξʸ
     */

    function select($select = "") {
      if ($select)           { /* do nothing */ }
      elseif ($this->select) { $select = implode(",", $this->select); }
      else                   { $select = "*"; }
      
      if (is_array($this->table) && sizeof($this->table) > 0) {
	// do nothing
      } else {
	$this->table = array($this->main_table);
      }

      if (sizeof($this->tableobj) <= 0) {
	// for backward-compatibility
	$select_array = array($select);
	if (sizeof($this->table) >= 1) {
	  $from_array = $this->table;
	} else {
	  $from_array = array($this->main_table);
	}
	$where_array = $this->where;

	// ŪorderbyˤΤǡϤ⤦ץˤʤϤ
	if (!empty($this->orderby)) {
	  $orderby = $this->orderby;
	  if ($this->desc) {
	    $orderby .= sprintf(" desc");
	  }
	  $orderby_array = array($orderby);
	}

      } else {
	$select_array = array();
	$from_array = array();
	$where_array = array();
	$orderby_array = array();

	$ret = $this->traverse_sql_tree(&$select_array, &$from_array,
					&$where_array, &$orderby_array);

	$select_array = array($select);

	if ($ret == false) {
	  // error occured
	  return "-- traverse_sql_tree() failed.";
	}
      }

      $sql = sprintf("select %s from %s", 
		     implode(",", $select_array),
		     implode(",", $from_array));

      if (sizeof($where_array)) {
	$sql .= sprintf(" where %s", implode(" and ", $where_array));
      }
      if (!empty($this->groupby)) {
	$sql .= sprintf(" group by %s", $this->groupby);
      }
      if (!empty($this->having)) {
	$sql .= sprintf(" having %s", $this->having);
      }
      if (sizeof($orderby_array)) {
	$sql .= sprintf(" order by %s", implode(",", $orderby_array));
      }
      if ($this->limit > 0)  { $sql .= sprintf(" limit %d", $this->limit); }
      if ($this->offset > 0) { $sql .= sprintf(" offset %d", $this->offset); }

      if (!$this->condition_check()) { 
	$this->_debug('select(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }

    /**
     * ˹礦褦select count(*)ʸ֤
     *
     * whereƤcount(*)SQL֤
     *
     *@access public
     *@param string $field_name count(*)פΥꥢ̾ͤ"count"
     *@return string selectʸʸ󡣥顼ξʸ
     */
    function select_count($field_name = "count") {

      if (is_array($this->table) && sizeof($this->table) > 0) {
	// do nothing
      } else {
	$this->table = array($this->main_table);
      }

      if (sizeof($this->tableobj) <= 0) {
	// for backward-compatibility
	$select_array = array($select);
	if (sizeof($this->table) >= 1) {
	  $from_array = $this->table;
	} else {
	  $from_array = array($this->main_table);
	}
	$where_array = $this->where;

	// ŪorderbyˤΤǡϤ⤦ץˤʤϤ
	if (!empty($this->orderby)) {
	  $orderby = $this->orderby;
	  if ($this->desc) {
	    $orderby .= sprintf(" desc");
	  }
	  $orderby_array = array($orderby);
	}

      } else {
	$select_array = array();
	$from_array = array();
	$where_array = array();
	$orderby_array = array();

	$ret = $this->traverse_sql_tree(&$select_array, &$from_array,
					&$where_array, &$orderby_array);

	$select_array = array($select);

	if ($ret == false) {
	  // error occured
	  return "-- traverse_sql_tree() failed.";
	}
      }

      $sql = sprintf("select count(*) as %s from %s", 
		     $field_name,
		     implode(",", $from_array));

      if (sizeof($where_array)) {
	$sql .= sprintf(" where %s", implode(" and ", $where_array));
      }
      if (!$this->condition_check()) { 
	$this->_debug('select(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }

    /**
     * ˹礦褦select sum(...)ʸ֤
     *
     * whereƤsum(...)SQL֤
     *
     *@access public
     *@param string $target_field פ׻ե̾
     *@param string $field_alias sum(*)פΥꥢ̾ͤ"sum"
     *@return string selectʸʸ󡣥顼ξʸ
     */
    function select_sum($target_field, $field_alias = "sum") {
      /* ʲϾĹʤΤǡselect_count() ȤޤȤ᤿*/
      if (is_array($this->table) && sizeof($this->table) > 0) {
	// do nothing
      } else {
	$this->table = array($this->main_table);
      }

      if (sizeof($this->tableobj) <= 0) {
	// for backward-compatibility
	$select_array = array($select);
	if (sizeof($this->table) >= 1) {
	  $from_array = $this->table;
	} else {
	  $from_array = array($this->main_table);
	}
	$where_array = $this->where;

	// ŪorderbyˤΤǡϤ⤦ץˤʤϤ
	if (!empty($this->orderby)) {
	  $orderby = $this->orderby;
	  if ($this->desc) {
	    $orderby .= sprintf(" desc");
	  }
	  $orderby_array = array($orderby);
	}

      } else {
	$select_array = array();
	$from_array = array();
	$where_array = array();
	$orderby_array = array();

	$ret = $this->traverse_sql_tree(&$select_array, &$from_array,
					&$where_array, &$orderby_array);

	$select_array = array($select);

	if ($ret == false) {
	  // error occured
	  return "-- traverse_sql_tree() failed.";
	}
      }

      $sql = sprintf("select sum(%s) as %s from %s", 
		     $target_field,
		     $field_alias,
		     implode(",", $from_array));

      if (sizeof($where_array)) {
	$sql .= sprintf(" where %s", implode(" and ", $where_array));
      }
      if (!$this->condition_check()) { 
	$this->_debug('select(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }


    function select_count_old($field_name = "count") {

      if (is_array($this->table) && sizeof($this->table) > 0) {
	// do nothing
      } else {
	$this->table = array($this->main_table);
      }

      $sql = sprintf("select count(*) as %s from %s",
		     $field_name,
		     implode(",", $this->table));

      if (sizeof($this->where)) {
	$sql .= sprintf(" where %s", implode(" and ", $this->where));
      }

      if (!$this->condition_check()) { 
	$this->_debug('select_count(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }

    function select_ncol() {
      return $this->select_count("ncol");
    }

    // obsoleteˤʤͽ
    function select_currval($seq_name = "") {
      if ($seq_name == "" && $this->main_table) {
	$seq_name = $this->main_table. "_". $this->main_table . "_id_seq";
      }
      return "select currval('$seq_name') as $seq_name";
    }

    // (insert)ơ֥primary keycurrval
    function select_curr_id() {
      if ($this->main_table) {
	$seq_name = $this->main_table. "_". $this->main_table . "_id_seq";
	$field_name = $this->main_table. "_id";
      }
      return "select currval('$seq_name') as $field_name";
    }


    // ʲΡDBؤѹ˴ؤؿΥѡߥåϡ
    // insert/updateǻؼʽ񤭴ԲĤʥ桼ФƤ϶ˤ
    // update/deletecondition_check()
    // dupϤɡ衩

    function insert_extra(&$fv) {
      // $fv򸫤ơɲäɬפʤΤˤreturn롣
      // ͤˤŪ''Ĥ뤫(select ...) ʤɤ񤱤롣
      // insert_fieldsΥåʤΤǡա
      return "";
    }

    function var2sqlval($field, &$varstr) {
      if ($varstr === false) {
	return "null";
      } elseif ((string)$varstr === "\0") {
	// ΥСȤθߴΤᡣ̤ʸȤư
	return "null";
      } else {
	return $this->normalize_value($field, $varstr);
      }
    }

    /**
     * ˹礦insertʸ֤
     *
     * ȤΥơ֥Ф$fvбŬڤinsertʸ֤
     * 
     * $fvϢǡSQLΥե̾ => SQL͡פȤġ
     * 
     * ޤset_condition()ƤȿǤinsertեɤ롣
     * 
     * 顼ʤɤͳŬڤSQLʸФʤ硢ʸ֤
     *
     *@access public
     *@param string $fv ե̾򥭡ˤϢ
     *@return string insertʸʸ󡣥顼ξʸ
     */

    function insert($fv) {
      if (!is_array(&$fv))       { $this->_debug2('insert()'); return ""; }
      if (!$this->insert_fields) { $this->_debug2('insert()'); return ""; }

      //insertfieldĤǤ¸ߤƤ뤫ɤΥå
      $result = $this->field_exists_for_query(array_keys($fv), "insert");

      $insert_f = ""; $insert_v = "";
      reset($this->insert_fields);
      while (list($k, $v) = each($this->insert_fields)) {
	if (isset($fv[$v])) {
	  $insert_f[] = $v;
	  $insert_v[] = $this->var2sqlval($v, $fv[$v]);
	} elseif (isset($this->where[$v]) &&
		  ereg("^${v}[ \t\r\n]*=[ \t\r\n]*(.*)$", $this->where[$v], $regs)) {
	  $insert_f[] = $v;
	  $insert_v[] = $regs[1];
	}
      }

      $extra_fv = $this->insert_extra($fv);
      if (is_array($extra_fv)) {
	reset($extra_fv);
	while (list($k, $v) = each($extra_fv)) {
	  $insert_f[] = $k;
	  $insert_v[] = $v; // ֥饹select'ʸ'
	}
      }

      if (empty($insert_f) || empty($insert_v)) {
	// ƤˤĤƥǥեͤ줿Ȥߤʤ
	// SQLoracleǤ̤ʤ
	$sql = sprintf("insert into %s default values", $this->main_table);
      } else {
	$sql = sprintf("insert into %s(%s) values(%s)",
		       $this->main_table,
		       implode(",", $insert_f),
		       implode(",", $insert_v));
      }
      return $sql;
    }

    /**
     * ˹礦褦updateʸ֤
     *
     * primary keywhereǻꤵƤʤϥ顼
     *
     * $fvϢͤĤ褦ʥ쥳ɤˤʤ褦
     * updateʸ֤
     * set_condition()ʤɤƤȿǤ롣
     * 顼ʤɤͳŬڤSQLʸФʤ硢ʸ֤
     *
     *@access public
     *@param string $fv ե̾򥭡ˤϢ
     *@return string updateʸʸ󡣥顼ξʸ
     */

    function update(&$fv) {
      $db = "";
      return $this->update_if_modified($fv, $db);
    }

    /**
     * ˹礦褦updateʸ֤
     *
     * ʣԤѹԤ롣
     * primary keyꤵƤʤƤ褤
     *
     * $fvϢͤĤ褦ʥ쥳ɤˤʤ褦
     * updateʸ֤
     * set_condition()ʤɤƤȿǤ롣
     * 顼ʤɤͳŬڤSQLʸФʤ硢ʸ֤
     *
     *@see update()
     *
     *@access public
     *@param string $fv ե̾򥭡ˤϢ
     *@return string updateʸʸ󡣥顼ξʸ
     */
    
    function update_all(&$fv) {
      $db = "";
      $modify_all = true;
      return $this->update_if_modified($fv, $db, $modify_all);
    }
    
    /**
     * ˹礦褦ʡʬset褦updateʸ֤
     *
     * primary keywhereǻꤵƤʤϥ顼
     *
     * $fvϢͤĤ褦ʥ쥳ɤˤʤ褦ˡ
     * ƤʬΤ߹褦updateʸ֤
     * set_condition()ʤɤƤȿǤ롣
     * 顼ʤɤͳŬڤSQLʸФʤ硢ʸ֤
     *
     *@access public
     *@param string $fv ե̾򥭡ˤϢ
     *@param string $row
     *@param string $modify_all
     *@return string updateʸʸ󡣥顼ξʸ
     */


    function update_if_modified(&$fv, &$row, $modify_all=false) {
      if (!is_array($fv))            { $this->_debug2('update()'); return ""; }
      if (!$this->update_fields)     { $this->_debug2('update()'); return ""; }

      // update_all()ǤʤȤˡ
      // primary key¸ߤơ֥ǡ
      // primary key whereǻꤵƤʤϥ顼
      if(!$modify_all &&
	 $this->pkey_name && 
	 !$this->pkey_specified_in_where()) {

	  $this->raiseError(SQL_ERROR_NO_PKEY_IN_WHERE, null, null,
			    "all primary key of '$this->main_table' must be specified for this update",null);

	  return "";
      }
      //updatefield¸ߤƤ뤫ɤΥå
      $result = $this->field_exists_for_query(array_keys($fv), "update");
      $update_array = array(); // updateɬפե
      reset($this->update_fields);
      while (list($k, $v) = each($this->update_fields)) {
	//echo $k, $v, " - ", $fv[$v], "<br>";
	if (isset($fv[$v])) {
	  // updateоݤΥե
	  if (is_array($row) && ((string)($fv[$v]) === $row[$v])) {
	    // äɬפϤʤ
	  } else {
	    $update_array[] = $v. "=". $this->var2sqlval($v, $fv[$v]);
	  }
	}
      }

      if ($update_array) {
	if (!$modify_all && sizeof($this->where) == 0) {
	  // updateˤϡSQL֥ȤФ
	  //expectError(SQL_ERROR_NO_WHERE_CLAUSE);
	  //update();
	  //popExpect();
	  //Ȥơ顼Фʤ褦ˤ
	  $this->raiseError(SQL_ERROR_NO_WHERE_CLAUSE,null,null,"No conditions given for update()",null);
	}

	$from_tables = array(); // ʣtableǤupdate(PostgreSQL?)
	if (is_array($this->table) && sizeof($this->table) > 0) {
	  // main_table 
	  foreach ($this->table as $table) {
	    if ($table != $this->main_table) {
	      $from_tables[] = $table;
	    }
	  }
	}	  
	  
	$sql = sprintf("update %s set %s",
		       $this->main_table,
		       implode(",", $update_array));
	if (sizeof($from_tables) > 0) {
	  $sql .= " from ";
	  $sql .= implode(",", $from_tables);
	}

	if ($this->where) {
	  $sql .= sprintf(" where %s", implode(" and ", $this->where));
	}
      } else {
	// 񤭴Τʤʤ̵
      }
      if (!$this->condition_check_update()) { 
	$this->_debug('update(): condition_check failed', $sql);
	return "";
      } else {
	return $sql;
      }
    }

    /**
     * primary key whereǻꤵƤ뤫å
     *
     * Ƥprimary keywhereǻꤵƤ뤫ɤ֤
     * 1쥳ɤˤĤƤǤ뤳ȤꤹʤɤѤ롣
     *
     * primary key̵ơ֥ξˤϡ
     * ˡꤵƤפȤϤߤʤ
     * ꤵƤʤȤfalse֤
     *
     * @see update_if_modified
     * @access private
     * $return boolean pkeyꤵƤtrue
     */
    function pkey_specified_in_where(){
      if(!$this->pkey_name) {
	// primary key̵ơ֥ξ
	return false;
      } elseif (!is_array($this->pkey_name)) {
	$this->pkey_name = array($this->pkey_name);
      }

      foreach ($this->pkey_name as $v) {
	if (!isset($this->where[$v])) {
	  return false;
	}
      }
      return true;
    }
    /**
     * delete records.
     *
     * SQLʸdelete
     * ߤwhere쥳ɤ
     * whereꤵʤä顢⤷ʤ
     *
     *@return string $sql
     */
    function delete() {
      if (!$this->condition_check_delete()) { return ""; }

      if (sizeof($this->where)) {
	$sql = sprintf("delete from %s where %s",
		       $this->main_table,
		       implode(" and ", $this->where));
      } else {
	// deleteˤϡSQL֥ȤФ
	//expectError(SQL_ERROR_NO_WHERE_CLAUSE);
	//delete();
	//popExpect();
	//Ȥơ顼Фʤ褦ˤ
	$this->raiseError(SQL_ERROR_NO_WHERE_CLAUSE,null,null,"No conditions given for delete()",null);
	$sql = sprintf("delete from %s",$this->main_table);
      }

      return $sql;
    }

    /**
     * field ¸ߤĴ٤
     *
     * @param $field string set_conditionϤ줿field̾
     * @return ¸ߤfield̾ξtrue¸ߤʤfalse֤
     * @access public
     */
    function field_exists($field){
      if (preg_match('/\./',$field)) {
	//join¾Υơ֥set_condition硣ǥ顼ˤͽ
	//$this->raiseError(SQL_ERROR_OTHERTABLE);
	return true;
      } elseif (!$this->field_type[$field]) {
	$this->raiseError(SQL_ERROR_NOSUCHFIELD, null, null,
			  "'$field' does not exist in '$this->main_table'",null);
	return false;
      } else {
	return true;
      }
    }
    /**
     * insert/update򤹤Ȥˡfield ¸ߤĴ٤
     *
     * @param $field string set_conditionϤ줿field̾
     * @param $query string insertupdate
     * @return ¸ߤfield̾ξtrue¸ߤʤfalse֤
     * @access private
     */
    function field_exists_for_query($field,$query){
      if ($query == "insert") {
	$array =& $this->insert_fields;
	$operation = "inserting";
      } elseif ($query == "update") {
	$array =& $this->update_fields;
	$operation = "updating";
      } else {
	return false;
      }

      if (!is_array($field)) {
	$field = array($field);
      }

      $error_keys = array();
      if (sizeof($field) == 0) {
	$error_occured = false;
      } else {
	$error_occured = true;
	foreach ($field as $key=>$value) {
	  if (in_array($value, $array)) {
	    $error_occured = false;
	  } else {
	    $error_keys[] = $value;
	  }
	}
      }
      
      if ($error_occured) {
	$this->raiseError(SQL_ERROR_NOSUCHFIELD, null, null,
			  "Illegal field name for $operation '$this->main_table' : '".
			  implode("','", $error_keys)."'",null);
	return false;
      } else {
	return true;
      }
    }

    /**
     * Ϳ줿SQLɤɤ֤
     *
     * Ϳ줿SQLɤɤ֤ޤ
     * ơ֥̾ե̾SQLɤȽŤʤäƤʤ
     * åΤ˻Ȥޤ
     *
     * PostgreSQL,MySQL,Oracle,SQL99,SQL92,
     * 줫ΥɤǤХɤȤƤޤ
     *
     * ɬ׽ʬǤʤ̵̣ʤΤǡõƤޤ
     *
     * http://www.postgresql.jp/document/pg721doc/user/sql-keywords-appendix.htmlʷ̾ơ֥̾ˤϤǤʤޤޤƤʤ
     * http://www.simosimo.info/know/oracle/keyword.htm
     * http://www.mysql.com/doc/en/Reserved_words.htmlʷ̾ơ֥̾ˤϤǤʤޤޤƤʤ
     * http://www.postgresql.org/docs/view.php?version=7.3&idoc=0&file=sql-keywords-appendix.htmlʷ̾ơ֥̾ˤϤǤʤޤޤƤʤ
     * 
     * http://www.mysql.gr.jp/jpdoc/3.23.x/manual.ja_Reference.html
     * ʰŪñ줬¿̤褦˸ñ줬¿äŬѤ
     *
     *@access public
     *@param string $identifier ̻ҤȤƻȤĤñ
     */

    function is_sql_keyword ($identifier) {
      $is_keyword = array(
			  "ABSOLUTE"            => 1,
			  "ACCESS"              => 1,
			  "ACTION"              => 1,
			  "ADD"                 => 1,
			  "ADMIN"               => 1,
			  "AFTER"               => 1,
			  "AGGREGATE"           => 1,
			  "ALIAS"               => 1,
			  "ALL"                 => 1,
			  "ALLOCATE"            => 1,
			  "ALTER"               => 1,
			  "ANALYSE"             => 1,
			  "ANALYZE"             => 1,
			  "AND"                 => 1,
			  "ANY"                 => 1,
			  "ARE"                 => 1,
			  "ARRAY"               => 1,
			  "AS"                  => 1,
			  "ASC"                 => 1,
			  "ASSERTION"           => 1,
			  "AT"                  => 1,
			  "AUDIT"               => 1,
			  "AUTHORIZATION"       => 1,
			  "AUTO_INCREMENT"      => 1,
			  "AVG"                 => 1,
			  "BDB"                 => 1,
			  "BEFORE"              => 1,
			  "BEGIN"               => 1,
			  "BERKELEYDB"          => 1,
			  "BETWEEN"             => 1,
			  "BIGINT"              => 1,
			  "BINARY"              => 1,
			  "BIT"                 => 1,
			  "BIT_LENGTH"          => 1,
			  "BLOB"                => 1,
			  "BOOLEAN"             => 1,
			  "BOTH"                => 1,
			  "BREADTH"             => 1,
			  "BTREE"               => 1,
			  "BY"                  => 1,
			  "CALL"                => 1,
			  "CASCADE"             => 1,
			  "CASCADED"            => 1,
			  "CASE"                => 1,
			  "CAST"                => 1,
			  "CATALOG"             => 1,
			  "CHANGE"              => 1,
			  "CHAR"                => 1,
			  "CHARACTER"           => 1,
			  "CHARACTER_LENGTH"    => 1,
			  "CHAR_LENGTH"         => 1,
			  "CHECK"               => 1,
			  "CID"                 => 1,
			  "CLASS"               => 1,
			  "CLOB"                => 1,
			  "CLOSE"               => 1,
			  "CLUSTER"             => 1,
			  "COALESCE"            => 1,
			  "COLLATE"             => 1,
			  "COLLATION"           => 1,
			  "COLUMN"              => 1,
			  "COLUMNS"             => 1,
			  "COMMENT"             => 1,
			  "COMMIT"              => 1,
			  "COMPLETION"          => 1,
			  "COMPRESS"            => 1,
			  "CONNECT"             => 1,
			  "CONNECTION"          => 1,
			  "CONSTRAINT"          => 1,
			  "CONSTRAINTS"         => 1,
			  "CONSTRUCTOR"         => 1,
			  "CONTINUE"            => 1,
			  "CONVERT"             => 1,
			  "CORRESPONDING"       => 1,
			  "COUNT"               => 1,
			  "CREATE"              => 1,
			  "CROSS"               => 1,
			  "CUBE"                => 1,
			  "CURRENT"             => 1,
			  "CURRENT_DATE"        => 1,
			  "CURRENT_PATH"        => 1,
			  "CURRENT_ROLE"        => 1,
			  "CURRENT_TIME"        => 1,
			  "CURRENT_TIMESTAMP"   => 1,
			  "CURRENT_USER"        => 1,
			  "CURSOR"              => 1,
			  "CYCLE"               => 1,
			  "DATA"                => 1,
			  "DATABASE"            => 1,
			  "DATABASES"           => 1,
			  "DATE"                => 1,
			  "DAY"                 => 1,
			  "DAY_HOUR"            => 1,
			  "DAY_MINUTE"          => 1,
			  "DAY_SECOND"          => 1,
			  "DEALLOCATE"          => 1,
			  "DEC"                 => 1,
			  "DECIMAL"             => 1,
			  "DECLARE"             => 1,
			  "DEFAULT"             => 1,
			  "DEFERRABLE"          => 1,
			  "DEFERRED"            => 1,
			  "DELAYED"             => 1,
			  "DELETE"              => 1,
			  "DEPTH"               => 1,
			  "DEREF"               => 1,
			  "DESC"                => 1,
			  "DESCRIBE"            => 1,
			  "DESCRIPTOR"          => 1,
			  "DESTROY"             => 1,
			  "DESTRUCTOR"          => 1,
			  "DETERMINISTIC"       => 1,
			  "DIAGNOSTICS"         => 1,
			  "DICTIONARY"          => 1,
			  "DISCONNECT"          => 1,
			  "DISTINCT"            => 1,
			  "DISTINCTROW"         => 1,
			  "DIV"                 => 1,
			  "DO"                  => 1,
			  "DOMAIN"              => 1,
			  "DOUBLE"              => 1,
			  "DROP"                => 1,
			  "DUAL"                => 1,
			  "DYNAMIC"             => 1,
			  "EACH"                => 1,
			  "ELSE"                => 1,
			  "ENCLOSED"            => 1,
			  "END"                 => 1,
			  "END-EXEC"            => 1,
			  "EQUALS"              => 1,
			  "ERRORS"              => 1,
			  "ESCAPE"              => 1,
			  "ESCAPED"             => 1,
			  "EVERY"               => 1,
			  "EXCEPT"              => 1,
			  "EXCEPTION"           => 1,
			  "EXCLUSIVE"           => 1,
			  "EXEC"                => 1,
			  "EXECUTE"             => 1,
			  "EXISTS"              => 1,
			  "EXPLAIN"             => 1,
			  "EXTERNAL"            => 1,
			  "EXTRACT"             => 1,
			  "FALSE"               => 1,
			  "FETCH"               => 1,
			  "FIELDS"              => 1,
			  "FILE"                => 1,
			  "FIRST"               => 1,
			  "FLOAT"               => 1,
			  "FLOAT4"              => 1,
			  "FLOAT8"              => 1,
			  "FOR"                 => 1,
			  "FORCE"               => 1,
			  "FOREIGN"             => 1,
			  "FOUND"               => 1,
			  "FREE"                => 1,
			  "FROM"                => 1,
			  "FULL"                => 1,
			  "FULLTEXT"            => 1,
			  "FUNCTION"            => 1,
			  "GENERAL"             => 1,
			  "GET"                 => 1,
			  "GLOBAL"              => 1,
			  "GO"                  => 1,
			  "GOTO"                => 1,
			  "GRANT"               => 1,
			  "GROUP"               => 1,
			  "GROUPING"            => 1,
			  "HASH"                => 1,
			  "HAVING"              => 1,
			  "HIGH_PRIORITY"       => 1,
			  "HOST"                => 1,
			  "HOUR"                => 1,
			  "HOUR_MINUTE"         => 1,
			  "HOUR_SECOND"         => 1,
			  "IDENTIFIED"          => 1,
			  "IDENTITY"            => 1,
			  "IF"                  => 1,
			  "IGNORE"              => 1,
			  "IMMEDIATE"           => 1,
			  "IN"                  => 1,
			  "INCREMENT"           => 1,
			  "INDEX"               => 1,
			  "INDICATOR"           => 1,
			  "INFILE"              => 1,
			  "INITIAL"             => 1,
			  "INITIALIZE"          => 1,
			  "INITIALLY"           => 1,
			  "INNER"               => 1,
			  "INNODB"              => 1,
			  "INOUT"               => 1,
			  "INPUT"               => 1,
			  "INSENSITIVE"         => 1,
			  "INSERT"              => 1,
			  "INT"                 => 1,
			  "INT1"                => 1,
			  "INT2"                => 1,
			  "INT3"                => 1,
			  "INT4"                => 1,
			  "INT8"                => 1,
			  "INTEGER"             => 1,
			  "INTERSECT"           => 1,
			  "INTERVAL"            => 1,
			  "INTO"                => 1,
			  "IS"                  => 1,
			  "ISOLATION"           => 1,
			  "ITERATE"             => 1,
			  "JOIN"                => 1,
			  "KEY"                 => 1,
			  "KEYS"                => 1,
			  "KEY_NO"              => 1,
			  "KILL"                => 1,
			  "LANGUAGE"            => 1,
			  "LARGE"               => 1,
			  "LAST"                => 1,
			  "LATERAL"             => 1,
			  "LEADING"             => 1,
			  "LEFT"                => 1,
			  "LESS"                => 1,
			  "LEVEL"               => 1,
			  "LIKE"                => 1,
			  "LIMIT"               => 1,
			  "LINES"               => 1,
			  "LOAD"                => 1,
			  "LOCAL"               => 1,
			  "LOCALTIME"           => 1,
			  "LOCALTIMESTAMP"      => 1,
			  "LOCATOR"             => 1,
			  "LOCK"                => 1,
			  "LONG"                => 1,
			  "LONGBLOB"            => 1,
			  "LONGTEXT"            => 1,
			  "LOWER"               => 1,
			  "LOW_PRIORITY"        => 1,
			  "MAP"                 => 1,
			  "MASTER_SERVER_ID"    => 1,
			  "MATCH"               => 1,
			  "MAX"                 => 1,
			  "MAXEXTENTS"          => 1,
			  "MEDIUMBLOB"          => 1,
			  "MEDIUMINT"           => 1,
			  "MEDIUMTEXT"          => 1,
			  "MIDDLEINT"           => 1,
			  "MIN"                 => 1,
			  "MINUS"               => 1,
			  "MINUTE"              => 1,
			  "MINUTE_SECOND"       => 1,
			  "MOD"                 => 1,
			  "MODE"                => 1,
			  "MODIFIES"            => 1,
			  "MODIFY"              => 1,
			  "MODULE"              => 1,
			  "MONTH"               => 1,
			  "MRG_MYISAM"          => 1,
			  "NAMES"               => 1,
			  "NATIONAL"            => 1,
			  "NATURAL"             => 1,
			  "NCHAR"               => 1,
			  "NCLOB"               => 1,
			  "NEW"                 => 1,
			  "NEXT"                => 1,
			  "NO"                  => 1,
			  "NOAUDIT"             => 1,
			  "NOCOMPRESS"          => 1,
			  "NONE"                => 1,
			  "NOT"                 => 1,
			  "NOWAIT"              => 1,
			  "NULL"                => 1,
			  "NULLIF"              => 1,
			  "NUMBER"              => 1,
			  "NUMERIC"             => 1,
			  "OBJECT"              => 1,
			  "OCTET_LENGTH"        => 1,
			  "OF"                  => 1,
			  "OFF"                 => 1,
			  "OFFLINE"             => 1,
			  "OFFSET"              => 1,
			  "OID"                 => 1,
			  "OLD"                 => 1,
			  "ON"                  => 1,
			  "ONLINE"              => 1,
			  "ONLY"                => 1,
			  "OPEN"                => 1,
			  "OPERATION"           => 1,
			  "OPTIMIZE"            => 1,
			  "OPTION"              => 1,
			  "OPTIONALLY"          => 1,
			  "OR"                  => 1,
			  "ORDER"               => 1,
			  "ORDINALITY"          => 1,
			  "OUT"                 => 1,
			  "OUTER"               => 1,
			  "OUTFILE"             => 1,
			  "OUTPUT"              => 1,
			  "OVERLAPS"            => 1,
			  "PAD"                 => 1,
			  "PARAMETER"           => 1,
			  "PARAMETERS"          => 1,
			  "PARTIAL"             => 1,
			  "PATH"                => 1,
			  "PCTFREE"             => 1,
			  "PLACING"             => 1,
			  "POSITION"            => 1,
			  "POSTFIX"             => 1,
			  "PRECISION"           => 1,
			  "PREFIX"              => 1,
			  "PREORDER"            => 1,
			  "PREPARE"             => 1,
			  "PRESERVE"            => 1,
			  "PRIMARY"             => 1,
			  "PRIOR"               => 1,
			  "PRIVILEGES"          => 1,
			  "PROCEDURE"           => 1,
			  "PUBLIC"              => 1,
			  "PURGE"               => 1,
			  "RAW"                 => 1,
			  "READ"                => 1,
			  "READS"               => 1,
			  "REAL"                => 1,
			  "RECURSIVE"           => 1,
			  "REF"                 => 1,
			  "REFERENCES"          => 1,
			  "REFERENCING"         => 1,
			  "REGEXP"              => 1,
			  "RELATIVE"            => 1,
			  "RENAME"              => 1,
			  "REPLACE"             => 1,
			  "REQUIRE"             => 1,
			  "RESOURCE"            => 1,
			  "RESTRICT"            => 1,
			  "RESULT"              => 1,
			  "RETURN"              => 1,
			  "RETURNS"             => 1,
			  "REVOKE"              => 1,
			  "RIGHT"               => 1,
			  "RLIKE"               => 1,
			  "ROLE"                => 1,
			  "ROLLBACK"            => 1,
			  "ROLLUP"              => 1,
			  "ROUTINE"             => 1,
			  "ROW"                 => 1,
			  "ROWID"               => 1,
			  "ROWLABEL"            => 1,
			  "ROWNUM"              => 1,
			  "ROWS"                => 1,
			  "RTREE"               => 1,
			  "SAVEPOINT"           => 1,
			  "SCHEMA"              => 1,
			  "SCOPE"               => 1,
			  "SCROLL"              => 1,
			  "SEARCH"              => 1,
			  "SECOND"              => 1,
			  "SECTION"             => 1,
			  "SELECT"              => 1,
			  "SEQUENCE"            => 1,
			  "SESSION"             => 1,
			  "SESSION_USER"        => 1,
			  "SET"                 => 1,
			  "SETS"                => 1,
			  "SHARE"               => 1,
			  "SHOW"                => 1,
			  "SIZE"                => 1,
			  "SMALLINT"            => 1,
			  "SOME"                => 1,
			  "SONAME"              => 1,
			  "SPACE"               => 1,
			  "SPATIAL"             => 1,
			  "SPECIFIC"            => 1,
			  "SPECIFICTYPE"        => 1,
			  "SQL"                 => 1,
			  "SQLCODE"             => 1,
			  "SQLERROR"            => 1,
			  "SQLEXCEPTION"        => 1,
			  "SQLSTATE"            => 1,
			  "SQLWARNING"          => 1,
			  "SQL_BIG_RESULT"      => 1,
			  "SQL_CALC_FOUND_ROWS" => 1,
			  "SQL_SMALL_RESULT"    => 1,
			  "SSL"                 => 1,
			  "START"               => 1,
			  "STARTING"            => 1,
			  "STATE"               => 1,
			  "STATEMENT"           => 1,
			  "STATIC"              => 1,
			  "STRAIGHT_JOIN"       => 1,
			  "STRIPED"             => 1,
			  "STRUCTURE"           => 1,
			  "SUBSTRING"           => 1,
			  "SUCCESSFUL"          => 1,
			  "SUM"                 => 1,
			  "SYNONYM"             => 1,
			  "SYSDATE"             => 1,
			  "SYSTEM_USER"         => 1,
			  "TABLE"               => 1,
			  "TABLES"              => 1,
			  "TEMPORARY"           => 1,
			  "TERMINATE"           => 1,
			  "TERMINATED"          => 1,
			  "TEXT"                => 1,
			  "THAN"                => 1,
			  "THEN"                => 1,
			  "TID"                 => 1,
			  "TIME"                => 1,
			  "TIMESTAMP"           => 1,
			  "TIMEZONE_HOUR"       => 1,
			  "TIMEZONE_MINUTE"     => 1,
			  "TINYBLOB"            => 1,
			  "TINYINT"             => 1,
			  "TINYTEXT"            => 1,
			  "TO"                  => 1,
			  "TRAILING"            => 1,
			  "TRANSACTION"         => 1,
			  "TRANSLATE"           => 1,
			  "TRANSLATION"         => 1,
			  "TREAT"               => 1,
			  "TRIGGER"             => 1,
			  "TRIM"                => 1,
			  "TRUE"                => 1,
			  "TYPES"               => 1,
			  "UID"                 => 1,
			  "UNDER"               => 1,
			  "UNION"               => 1,
			  "UNIQUE"              => 1,
			  "UNKNOWN"             => 1,
			  "UNLOCK"              => 1,
			  "UNNEST"              => 1,
			  "UNSIGNED"            => 1,
			  "UPDATE"              => 1,
			  "UPPER"               => 1,
			  "USAGE"               => 1,
			  "USE"                 => 1,
			  "USER"                => 1,
			  "USER_RESOURCES"      => 1,
			  "USING"               => 1,
			  "VALIDATE"            => 1,
			  "VALUE"               => 1,
			  "VALUES"              => 1,
			  "VARBINARY"           => 1,
			  "VARCHAR"             => 1,
			  "VARCHAR2"            => 1,
			  "VARCHARACTER"        => 1,
			  "VARIABLE"            => 1,
			  "VARYING"             => 1,
			  "VIEW"                => 1,
			  "WARNINGS"            => 1,
			  "WHEN"                => 1,
			  "WHENEVER"            => 1,
			  "WHERE"               => 1,
			  "WITH"                => 1,
			  "WITHOUT"             => 1,
			  "WORK"                => 1,
			  "WRITE"               => 1,
			  "XID"                 => 1,
			  "XOR"                 => 1,
			  "YEAR"                => 1,
			  "YEAR_MONTH"          => 1,
			  "ZEROFILL"            => 1,
			  "ZONE"                => 1,
			  );
      if ($is_keyword[strtoupper($identifier)]) {
	return true;
      }
      return false;
    }

/**/

    /**
     * ܥ̾Ĵ٤
     *
     *@access public
     *@param string $identifier Ĵ٤̾
     */
    function valid_sql_identifier($identifier) {
      if($this->is_sql_keyword($identifier)) {
	return 1;
      }
      if(strlen($identifier) > 31) {
	return 2;
      }
      return 0;
    }


    function _debug ($fnname,&$val) {
      if ($this->debug) {
	echo "<B>$fnname</B>:<BR><TT>".
	  nl2br(HTMLSpecialChars($val)) .
	  "</TT><BR>";
      }
    }
    function _debug2 ($fnname) {
      if ($this->debug) {
	echo "<B>$fnname</B><BR>";
      }
    }
  }

  /* obsolete: this class is for backward-compatiblity */
  class SQL extends Dino_SQL{
    function SQL(){
      parent::Dino_SQL();
    }
  };

  // {{{ class SQL_Error
  /**
   * SQL˴ؤ륨顼åϤ륯饹
   *
   */
  class SQL_Error extends PEAR_Error
    {
      // {{{ constructor
      /**
       * SQL_Error constructor.
       *
       * @param mixed   $code   SQL error code, or string with error message.
       * @param integer $mode   what "error mode" to operate in
       * @param integer $level  what error level to use for $mode & PEAR_ERROR_TRIGGER
       * @param mixed   $debuginfo  additional debug info, such as the last query
       *
       * @access public
       *
       * @see PEAR_Error
       */
      
      function SQL_Error($code = SQL_ERROR, $mode = PEAR_ERROR_RETURN,
			$level = E_USER_NOTICE, $debuginfo = null)
	{
	  if (is_int($code)) {
            $this->PEAR_Error('SQL Error: ' . $this->errorMessage($code), $code, $mode, $level, $debuginfo);
	  } else {
            $this->PEAR_Error("SQL Error: $code", SQL_ERROR, $mode, $level, $debuginfo);
	  }	  
	}
      // }}}

      // }}}
      // {{{ errorMessage()
      /**
       * Return a textual error message for a SQL error code
       *
       * @param integer $value error code
       *
       * @return string error message, or false if the error code was
       * not recognized
       */
      function errorMessage($value)
	{
	  static $errorMessages;
	  if (!isset($errorMessages)) {
            $errorMessages = array(
				   SQL_ERROR                    => 'unknown error',
				   SQL_ERROR_ALREADY_EXISTS     => 'already exists',
				   SQL_ERROR_CANNOT_CREATE      => 'can not create',
				   SQL_ERROR_CANNOT_DELETE      => 'can not delete',
				   SQL_ERROR_CANNOT_DROP        => 'can not drop',
				   SQL_ERROR_CONSTRAINT         => 'constraint violation',
				   SQL_ERROR_DIVZERO            => 'division by zero',
				   SQL_ERROR_INVALID            => 'invalid',
				   SQL_ERROR_INVALID_DATE       => 'invalid date or time',
				   SQL_ERROR_INVALID_NUMBER     => 'invalid number',
				   SQL_ERROR_MISMATCH           => 'mismatch',
				   SQL_ERROR_NODBSELECTED       => 'no database selected',
				   SQL_ERROR_NOSUCHFIELD        => 'no such field',
				   SQL_ERROR_NOSUCHTABLE        => 'no such table',
				   SQL_ERROR_NOT_CAPABLE        => 'SQL backend not capable',
				   SQL_ERROR_NOT_FOUND          => 'not found',
				   SQL_ERROR_NOT_LOCKED         => 'not locked',
				   SQL_ERROR_SYNTAX             => 'syntax error',
				   SQL_ERROR_UNSUPPORTED        => 'not supported',
				   SQL_ERROR_VALUE_COUNT_ON_ROW => 'value count on row',
				   SQL_ERROR_INVALID_DSN        => 'invalid DSN',
				   SQL_ERROR_CONNECT_FAILED     => 'connect failed',
				   SQL_OK                       => 'no error',
				   SQL_WARNING                  => 'unknown warning',
				   SQL_WARNING_READ_ONLY        => 'read only',
				   SQL_ERROR_NEED_MORE_DATA     => 'insufficient data supplied',
				   SQL_ERROR_EXTENSION_NOT_FOUND=> 'extension not found',
				   SQL_ERROR_NOSUCHDB           => 'no such database',
				   SQL_ERROR_ACCESS_VIOLATION   => 'insufficient permissions',
				   SQL_ERROR_TRUNCATED          => 'truncated',
				   SQL_ERROR_NOCONDITIONS       => 'no conditions given',
				   SQL_ERROR_NOSETVAR           => 'no set variables',
				   SQL_ERROR_OTHERTABLE         => 'access to other table',
				   SQL_ERROR_NO_WHERE_CLAUSE    => 'no where clause given',
				   SQL_ERROR_NO_PKEY_IN_WHERE	=> 'the primary key is not in where clause',
				   );
	  }
	  
	  if (PEAR::isError($value)) {
            $value = $value->getCode();
	  }
	  
	  return isset($errorMessages[$value]) ? $errorMessages[$value] : $errorMessages[SQL_ERROR];
	}
      
    }
  // }}}
}?>
