/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE FILEWRITERDX SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE FILEWRITERDX SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef _FileWriterDX_h_
#define _FileWriterDX_h_

#include <windows.h>
#include <shlwapi.h>
#include <streams.h>

#define FILTER_NAME L"File Writer DX"

// {4B1ABFC2-E95F-4CB3-BEC8-657E6D896A70}
static const GUID CLSID_FileWriterDX = 
{ 0x4b1abfc2, 0xe95f, 0x4cb3, { 0xbe, 0xc8, 0x65, 0x7e, 0x6d, 0x89, 0x6a, 0x70 } };

// ------------------------------------------------------------------------------------------------------------------------
class CInputPin : public CRenderedInputPin
{
   friend class CFileWriterDX;

public:

   // RXgN^ƃfXgN^
   CInputPin(CFileWriterDX *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // [U֐
   HRESULT SetFileName(LPCOLESTR);
   HRESULT Stop();

   // [Uϐ
   WAVEFORMATEX m_InputWaveFormatEx;

private:

   // [U֐
   HRESULT WriteWavHeader(void);

   // [Uϐ
   HANDLE m_hFile;
   CFileWriterDX * const m_pFilter;
   CCritSec *m_pReceiveLock;
   LONGLONG m_llInputSize;
   WCHAR m_awFileName[MAX_PATH];
   bool m_bUseWavDest;
   WAVEFORMATEX m_InputFormat;
};
// ------------------------------------------------------------------------------------------------------------------------
class CFileWriterDX : public CBaseFilter, public IFileSinkFilter
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CFileWriterDX(LPUNKNOWN,HRESULT *);
   ~CFileWriterDX();

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Stop();

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _FileWriterDX_h_
