/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE aoTuvWriter SOURCE CODE.                *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2007             *
 * by the Xiph.Org Foundation http://www.xiph.org/                  *
 *                                                                  *
 * THE aoTuv SOURCE CODE IS (C) COPYRIGHT 2003-2008 Aoyumi          *
 * http://www.geocities.jp/aoyoume/aotuv/                           *
 *                                                                  *
 * THE aoTuvWriter SOURCE CODE IS (C) COPYRIGHT 2008 Cocha          *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef _aoTuvWriter_h_
#define _aoTuvWriter_h_

typedef struct tagVORBISFORMAT
{
	WORD  nChannels;
	long  nSamplesPerSec;
	long  nMinBitsPerSec;
	long  nAvgBitsPerSec;
	long  nMaxBitsPerSec;
	float fQuality;
} VORBISFORMAT;

typedef struct tagVORBISTAG
{
   char acTitle[256];
   char acArtist[256];
   char acAlbum[256];
   char acTrackNumber[256];
   char acDate[256];
   char acGenre[256];
   char acComment[256];
} VORBISTAG;

// ------------------------------------------------------------------------------------------------------------------------
class CaoTuvWriter : public CBaseFilter, public IFileSinkFilter
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CaoTuvWriter(LPUNKNOWN,HRESULT *);
   ~CaoTuvWriter();

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

   // [U֐
   HRESULT SetVorbisFormat(void *);
   HRESULT SetVorbisTag(void *);

private:

   // gpϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _aoTuvWriter_h_
