'''
Created on 2010/10/09

@author: inagaki_katsuhiro
'''
import logging, sys, smtplib, traceback
from email.MIMEText import MIMEText
from email.Header import Header
from email.Utils import formatdate

from django.conf import settings
from django.core.urlresolvers import reverse
from django.template import loader

def send(to_addr, msg):
    try:
        if hasattr(settings, 'MAIL_HOST'):
            s = smtplib.SMTP(settings.MAIL_HOST, settings.MAIL_PORT)
        else:
            s = smtplib.SMTP()
        s.sendmail(settings.MAIL_SENDER, [to_addr], msg.as_string())
    except:
        extype, exval, tbk = sys.exc_info()
        stackframe_list=traceback.format_tb(tbk)
        logging.error(extype, exval, stackframe_list)
    finally:
        if s is not None:
            s.close()

def create_msg(to_addr, subject, body):
    msg = MIMEText(body, 'plain', settings.MAIL_ENCODING)
    msg['Subject'] = Header(subject, settings.MAIL_ENCODING)
    msg['From'] = settings.MAIL_SENDER
    msg['To'] = to_addr
    msg['Date'] = formatdate()
    return msg

def send_template_msg(to_addr, subject, template, args):
    body = loader.render_to_string(template, args)
    body = body.encode(settings.MAIL_ENCODING)
    if to_addr is not None:
        send(to_addr, create_msg(to_addr, subject, body))
