from django.db import models
from django.utils.translation import ugettext_lazy as _

class FeedbackLog(models.Model):
    RATING_TYPE_CHOICES = (
        (3, _('excellent')),
        (2, _('good')),
        (1, _('a little good')),
        (0, _('not for better or worse')),
        (-1, _('a little bad')),
        (-2, _('bad')),
        (-3, _('too bad')),
    )
    item = models.ForeignKey('item.Item')
    item_name = models.CharField(max_length=255)
    user = models.ForeignKey('appauth.User')
    regist_date = models.DateTimeField(_('regist date'), auto_now=True)
    comment = models.CharField(_('feedback comment'), max_length=512, null=True)
    rating = models.IntegerField(_('rating'), max_length=1, choices=RATING_TYPE_CHOICES, default=0)
