# -*- coding: utf-8 -*-

# Django settings for djanction project.
import os
from django.conf import global_settings


# application settings
SITE_ROOT = os.path.dirname(os.path.realpath(__file__))

# Djanction base url
# this value is not ends width '/'. if it deploy on root (like http://yourdomain/), set value ''.
BASE_URL = ''

# Django execute mode
DEBUG = False
TEMPLATE_DEBUG = DEBUG


# admin settings
ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS


# database settings
DATABASE_ENGINE = 'sqlite3'           # 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'oracle'.
DATABASE_NAME = os.path.dirname(__file__) + os.sep + 'sqlite.db'             # Or path to database file if using sqlite3.
DATABASE_USER = ''             # Not used with sqlite3.
DATABASE_PASSWORD = ''         # Not used with sqlite3.
DATABASE_HOST = ''             # Set to empty string for localhost. Not used with sqlite3.
DATABASE_PORT = ''             # Set to empty string for default. Not used with sqlite3.

SITE_ID = 1


# language/locale settings
# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Asia/Tokyo'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'ja-JP'

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

LOCALE_PATHS = (
    os.path.join(SITE_ROOT, 'locale'),
) + global_settings.LOCALE_PATHS

# static file settings

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"

MEDIA_ROOT = os.path.join(SITE_ROOT, 'templates', 'static')

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'


# Make this unique, and don't share it with anybody.
SECRET_KEY = 'k4^$(r!_1n6n1z5zgbjtqqwfo-7ypijduzng2wliqys2sz^opf'



# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.load_template_source',
    'django.template.loaders.app_directories.load_template_source',
#     'django.template.loaders.eggs.load_template_source',
)

from django.conf import global_settings
TEMPLATE_CONTEXT_PROCESSORS = global_settings.TEMPLATE_CONTEXT_PROCESSORS + (
    'django.core.context_processors.request',
    'djanction.context_processors.sitename',
)

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
#    'django.contrib.csrf.middleware.CsrfMiddleware',
    'django.middleware.transaction.TransactionMiddleware',
    'djanction.middleware.LogInitializeMiddleware',
)

AUTHENTICATION_BACKENDS = (
    'djanction.appauth.backends.ModelBackend',
) + global_settings.AUTHENTICATION_BACKENDS

ROOT_URLCONF = 'djanction.urls'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    os.path.join(SITE_ROOT, 'templates'),
)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.admin',
    'djanction.appauth',
    'djanction.item',
    'djanction.bid',
    'djanction.rating',
    'djanction.watchlist',
    'djanction.socialapi',
    'djanction.wish',
)

LOGGING_CONF = os.path.join(SITE_ROOT, 'log.conf')

LOGIN_REDIRECT_URL = BASE_URL + '/'
LOGIN_URL = BASE_URL + '/auth/login/'

SESSION_EXPIRE_TIME = 1800


USER_ICON_TYPE = "jpeg"
USER_ICON_SIZE = {'width':100}

#ITEM_IMAGE_SIZE = {}
#ITEM_THUMBNAIL_SIZE = {}

ITEM_PRICE_STEP = 10


MAIL_SENDER='auction_master@example.com'
MAIL_ENCODING='utf-8'

MAIL_HOST='localhost'
MAIL_PORT=25

# This is used for mail title.
AUCTION_NAME=u'オークション'

FACEBOOK_APP_ID='xxxxxxxxxxxxxxx'
FACEBOOK_APP_SECRET='xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'
FACEBOOK_GROUP_ID='xxxxxxxxxxxxxxx'

TWITTER_ENABLED           =True
TWITTER_CONSUMER_KEY      ='xxxxxxxxxxxxxxxxxxxx'
TWITTER_CONSUMER_SECRET   ='xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'
TWITTER_OAUTH_TOKEN       ='xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'
TWITTER_OAUTH_TOKEN_SECRET='m0OjtAcGKEqQPhuu6T7wyV7NlSKSdJrB5jQVmoYhY'
TWITTER_OAUTH_TOKEN_SECRET='xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'
TWITTER_API_UPDATE        ='http://api.twitter.com/1/statuses/update.json'
TWITTER_HASH_TAG          ='#auction'

MIXI_APP_ID='xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'
