unit ecma_misc;

interface

//̑낢
//2001/04/25~
//by Wolfy
//

{..$DEFINE MB_NO_OWNER}  //I[i[ȂMessageBoxɂ

uses
  windows,sysutils,classes,regexpr,gsocketmisc,forms;

type
  TECMATime = Double;

//t֌W  ECMATime
function SystemTimeToECMATime(SystemTime: TSystemTime): TECMATime;
function ECMATimeToSystemTime(ECMATime: TECMATime): TSystemTime;
function GetLocalTime: TECMATime;
function GetUTCTime: TECMATime;
function DateTimeToECMATime(DateTime: TDateTime): TECMATime;
function ECMATimeToDateTime(T: TECMATime): TDateTime;
function GetLocalTZA: TECMATime;

//DateTime
function LocalDateTimeToGMT(DateTime: TDateTime): TDateTime;
function GMTToLocalDateTime(DateTime: TDateTime): TDateTime;
function GetTimezone: TDateTime;
function GMTNow: TDateTime;


//t
function DateParse(S: String): TDateTime;

function HexToBitStr(hex : string) : string;
function IntToBitStr(Num: Integer): String;

//bZ[W{bNX
function MsgBox(Text,Caption: String; uType: UINT): Integer; overload;
function MsgBox(Text,Caption: PChar; uType: UINT): Integer; overload;

//AvP[V
function GetApplicationTitle: String;

//_b𕶎
function MSecToStr(MSec: Cardinal): String;
function MSecToStr2(MSec: Cardinal): String;

//bit
const
  BYTE_FLAGS: array[0..7] of Byte =
  (
    1,2,4,8,16,32,64,128
  );

function SetByteFlag(Flags: array of Boolean): Byte;
function GetByteFlag(Flags: Byte; Num: Byte): Boolean;






implementation


const
  UnixDateDelta = 25569;
  MsPerSec = 1000;

function DateTimeToUnix(const AValue: TDateTime): Int64;
//datetime -> time_t
begin
  Result := Round((AValue - UnixDateDelta) * SecsPerDay);
end;

function UnixToDateTime(const AValue: Int64): TDateTime;
//time_t -> datetime
begin
  Result := AValue / SecsPerDay + UnixDateDelta;
end;

function SystemTimeToECMATime(SystemTime: TSystemTime): TECMATime;
//SystemTime -> ECMATime
begin
  Result :=
    DateTimeToUnix(SystemTimeToDateTime(SystemTime)) * MsPerSec;
end;

function ECMATimeToSystemTime(ECMATime: TECMATime): TSystemTime;
//ECMATime -> SystemTime
begin
  DateTimeToSystemTime(UnixToDateTime(Trunc(ECMATime / MsPerSec)),Result);
end;

function GetLocalTime: TECMATime;
var
  time: TSystemTime;
begin
  windows.GetLocalTime(time);
  Result := SystemTimeToECMATime(time);
end;

function GetUTCTime: TECMATime;
var
  time: TSystemTime;
begin
  windows.GetSystemTime(time);
  Result := SystemTimeToECMATime(time);
end;

function GetLocalTZA: TECMATime;
//
begin
  Result := GetLocalTime - GetUTCTime;
end;

function DateTimeToECMATime(DateTime: TDateTime): TECMATime;
//DateTime -> ECMATime
var
  time: TSystemTime;
begin
  DateTimeToSystemTime(DateTime,time);
  Result := SystemTimeToECMATime(time);
end;

function ECMATimeToDateTime(T: TECMATime): TDateTime;
//ECMATime -> DateTime
var
  time: TSystemTime;
begin
  time := ECMATimeToSystemTime(T);
  Result := SystemTimeToDateTime(time);
end;

function GetTimezone: TDateTime;
//擾
var
  snow: TSystemTime;
begin
  GetSystemTime(snow);
  //
  Result := SystemTimeTodateTime(snow) - Now;
end;

function LocalDateTimeToGMT(DateTime: TDateTime): TDateTime;
//Local to GMT
begin
  Result := DateTime + GetTimezone;
end;

function GMTToLocalDateTime(DateTime: TDateTime): TDateTime;
//GMT -> LocalTime
begin
  Result := DateTime - GetTimezone;
end;

function GMTNow: TDateTime;
//EW
begin
  Result := LocalDateTimeToGMT(Now);
end;

function DateParse(S: String): TDateTime;
//tɕϊ
var
  sl: TStringList;
  y,m,d,ho,mi,se,ms: Word;
begin
  S := Trim(S);
  Result := Now;
  DecodeDate(Result,y,m,d);
  DecodeTime(Result,ho,mi,se,ms);

  try
    Result := StrToDateTime(S);
  except
    //ϊs Dec 31, 1999 23:59:59
    on EConvertError do
    begin
      sl := TStringList.Create;
      try
        SplitRegExpr('[,:\s]+',S,sl);
        try
          y := StrToIntDef(sl[2],y);
          //1Ђ
          m := GetMonth(sl[0]) - 1;
          d := StrToIntDef(sl[1],d);
          ho := StrToIntDef(sl[3],ho);
          mi := StrToIntDef(sl[4],mi);
          se := StrToIntDef(sl[5],se);
          ms := StrToIntDef(sl[6],ms);
        except
          on EStringListError do
        end;

        try
          Result := EncodeDate(y,m,d);
          Result := Result + EncodeTime(ho,mi,se,ms);
        except
          on EConvertError do
        end;

      finally
        sl.Free;
      end;
    end;
  end; //except

end;


function IntToBitStr(Num: Integer): String;
begin
  Result := HexToBitStr(IntToHex(Num,8));
end;

function HexToBitStr(hex : string) : string;
var
  i,d : integer;
  s: String;
const
  bitstr : array[0..21] of string = (
  '0000','0001','0010','0011','0100','0101','0110','0111',
  '1000','1001','1010','1011','1100','1101','1110','1111',
  '1010','1011','1100','1101','1110','1111' );
  hexstr : string = '0123456789abcdefABCDEF';
begin
  Result := '';
  for i:=1 to Length(hex) do begin
    d := Pos(copy(hex,i,1), hexstr);
    if d = 0 then
    begin
      // sFSPACE()
      result := result + '    ';
    end
    else begin
      result := result + bitstr[d-1];
    end;
  end;
  //ŏ0폜
  if Result <> '' then
  begin
    s := '0';  // ׂ'0'Ƃ'0'Ԃ
    for i := 1 to Length(Result) do
      if Result[i] <> '0' then
      begin
        s := Copy(Result,i,MaxInt);
        Break;
      end;

    Result := s;
  end;
end;

function MsgBox(Text,Caption: String; uType: UINT): Integer;
//bZ[W{bNX
begin
  Result := MsgBox(PChar(Text), PChar(Caption), uType);
end;

function MsgBox(Text,Caption: PChar; uType: UINT): Integer;
{$IFNDEF MB_NO_OWNER}
var
  h: HWND;
{$ENDIF}
begin
{$IFNDEF MB_NO_OWNER}
  h := GetActiveWindow;
  SetForegroundWindow(Application.Handle);
  Result := Application.MessageBox(Text,Caption,uType);

  if h <> 0 then
    SetForegroundWindow(h);
{$ELSE}
  Result := MessageBox(0, Text, Caption, uType);
{$ENDIF}
end;


//AvP[V
function GetApplicationTitle: String;
begin
  if IsConsole then
  begin
    Result := ChangeFileExt(ExtractFileName(ParamStr(0)),'');
    Result := AnsiUpperCase(Copy(Result,1,1)) + AnsiLowerCase(Copy(Result,2,MaxInt));
  end
  else
    Result := Application.Title;
end;

function MSecToStr(MSec: Cardinal): String;
//~bԂɕϊstring
var
 h,n,s,tmp: Cardinal;
begin
  if MSec > 0 then
  begin
    tmp := Msec div 1000;

    h := tmp div 3600;
    tmp := tmp mod 3600;
    n := tmp div 60;
    s := tmp mod 60;
  end
  else begin
    h := 0;
    n := 0;
    s := 0;
  end;

  Result := Format('%u:%.2u:%.2u',[h,n,s]);
end;

function MSecToStr2(MSec: Cardinal): String;
//~bԂɕϊstring
var
 h,n,s,tmp: Cardinal;
begin
  if MSec > 0 then
  begin
    tmp := MSec div 1000;
    MSec := MSec mod 1000;

    h := tmp div 3600;
    tmp := tmp mod 3600;
    n := tmp div 60;
    s := tmp mod 60;
  end
  else begin
    h := 0;
    n := 0;
    s := 0;
    MSec := 0;
  end;

  Result := Format('%u:%.2u:%.2u:%.3u',[h,n,s,MSec]);
end;

function SetByteFlag(Flags: array of Boolean): Byte;
//bit flagZbg
var
  i: Integer;
begin
  Result := 0;
  for i := 0 to High(Flags) do
    if Flags[i] then
      Result := Result or BYTE_FLAGS[i];
end;

function GetByteFlag(Flags: Byte; Num: Byte): Boolean;
//bit flag𓾂 0`7
begin
 Result := ((Flags shr Num) and 1) = 1;
end;




end.
