class FileController < ApplicationController
  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ht_file_pages, @ht_files = paginate :ht_files, :per_page => 10
  end

  def show
    @ht_file = HtFile.find(params[:id])
  end

  def new
    @ht_file = HtFile.new
  end

  def create
    @ht_file = HtFile.new(params[:ht_file])
    if @ht_file.save
      flash[:notice] = 'HtFile was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @ht_file = HtFile.find(params[:id])
  end

  def update
    @ht_file = HtFile.find(params[:id])
    if @ht_file.update_attributes(params[:ht_file])
      flash[:notice] = 'HtFile was successfully updated.'
      redirect_to :action => 'show', :id => @ht_file
    else
      render :action => 'edit'
    end
  end

  def destroy
    HtFile.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
