class MscodeController < ApplicationController
  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ms_code_pages, @ms_codes = paginate :ms_codes, :per_page => 10
  end

  def show
    @ms_code = MsCode.find(params[:id])
  end

  def new
    @ms_code = MsCode.new
  end

  def create
    @ms_code = MsCode.new(params[:ms_code])
    if @ms_code.save
      flash[:notice] = 'MsCode was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

  def edit
    @ms_code = MsCode.find(params[:id])
  end

  def update
    @ms_code = MsCode.find(params[:id])
    if @ms_code.update_attributes(params[:ms_code])
      flash[:notice] = 'MsCode was successfully updated.'
      redirect_to :action => 'show', :id => @ms_code
    else
      render :action => 'edit'
    end
  end

  def destroy
    MsCode.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
