class MskbnmainController < ApplicationController
  layout "doc_main"
  
  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ms_kbn_main_pages, @ms_kbn_mains = paginate :ms_kbn_mains, :per_page => 100
  end

  def show
    @ms_kbn_main = MsKbnMain.find(params[:id])
  end

  def new
    @ms_kbn_main = MsKbnMain.new
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def create

    ## 登録数制限  
    count_d = MsKbnMain.find(:first , :select=>"count(*) as ct_num")
#    logger.debug '#:ct_num='+count_d[:ct_num].inspect
    if count_d[:ct_num].to_i >= $ENV_PARAM_max_num_mst_project.to_i
        render :text=>"最大登録件数を超えました[大区分マスタ]、"+ $ENV_PARAM_max_num_mst_project.to_s + "件まで登録可能です。<br><a href='#' onClick='history.back();'>[戻る]</a>"
        return
    end
        
  
    kParam={}
    kParam[:kbn_name]  = params[:ms_kbn_main][:kbn_name]
    kParam[:order_no]   = params[:ms_kbn_main][:order_no]
    kParam['userid']       = session['user'][:id].to_s
    kParam['createat']     = Time.now
    kParam['updateat']     = Time.now

#    @ms_kbn_main = MsKbnMain.new(params[:ms_kbn_main])
    @ms_kbn_main = MsKbnMain.new(kParam)
    if @ms_kbn_main.save
      flash[:notice] = 'MsKbnMain was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def edit
    @ms_kbn_main = MsKbnMain.find(params[:id])
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def update
  
    kParam={}
    kParam[:kbn_name]  = params[:ms_kbn_main][:kbn_name]
    kParam[:order_no]   = params[:ms_kbn_main][:order_no]
    kParam['userid']       = session['user'][:id].to_s
    kParam['updateat']     = Time.now
  
    @ms_kbn_main = MsKbnMain.find(params[:id])
    if @ms_kbn_main.update_attributes(kParam)
      flash[:notice] = 'MsKbnMain was successfully updated.'
#      redirect_to :action => 'show', :id => @ms_kbn_main
      redirect_to :action => 'list'
    else
      render :action => 'edit'
    end
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def destroy
    MsKbnMain.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
