class MsprojectController < ApplicationController
  layout "doc_main"

  def index
    list
    render :action => 'list'
  end

  # GETs should be safe (see http://www.w3.org/2001/tag/doc/whenToUseGet.html)
  verify :method => :post, :only => [ :destroy, :create, :update ],
         :redirect_to => { :action => :list }

  def list
    @ms_project_pages, @ms_projects = paginate :ms_projects, :per_page => 100
  end

  def show
    @ms_project = MsProject.find(params[:id])
  end

  def new
    @ms_project = MsProject.new
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def create
  
    ## 登録数制限  
    count_d = MsProject.find(:first , :select=>"count(*) as ct_num")
#    logger.debug '#:ct_num='+count_d[:ct_num].inspect
    if count_d[:ct_num].to_i >= $ENV_PARAM_max_num_mst_project.to_i
        render :text=>"最大登録件数を超えました[プロジェクトマスタ]、"+ $ENV_PARAM_max_num_mst_project.to_s + "件まで登録可能です。<br><a href='#' onClick='history.back();'>[戻る]</a>"
        return
    end
        
    pParam={}
    pParam[:doc_kbn]         = params[:ms_project][:doc_kbn]
    pParam[:project_name]   = params[:ms_project][:project_name]
    pParam[:order_no]        = params[:ms_project][:order_no]
  
    pParam['userid']       = session['user'][:id].to_s
    pParam['createat']     = Time.now
    pParam['updateat']     = Time.now
#    @ms_project = MsProject.new(params[:ms_project])
    @ms_project = MsProject.new(pParam)
    if @ms_project.save
      flash[:notice] = 'MsProject was successfully created.'
      redirect_to :action => 'list'
    else
      render :action => 'new'
    end
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def edit
    @ms_project = MsProject.find(params[:id])
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def update

    pParam={}
    pParam[:doc_kbn]         = params[:ms_project][:doc_kbn]
    pParam[:project_name]   = params[:ms_project][:project_name]
    pParam[:order_no]        = params[:ms_project][:order_no]
    pParam['userid']       = session['user'][:id].to_s
    pParam['updateat']     = Time.now

    @ms_project = MsProject.find(params[:id])
    if @ms_project.update_attributes(pParam)
      flash[:notice] = 'MsProject was successfully updated.'
#      redirect_to :action => 'show', :id => @ms_project
      redirect_to :action => 'list'
    else
      render :action => 'edit'
    end
  end

#------------------------------------
# @calling
# @purpose
# @date
# @argment
# @return
#------------------------------------
  def destroy
    MsProject.find(params[:id]).destroy
    redirect_to :action => 'list'
  end
end
