require File.dirname(__FILE__) + '/../test_helper'
require 'doc_controller'

# Re-raise errors caught by the controller.
class DocController; def rescue_action(e) raise e end; end

class DocControllerTest < Test::Unit::TestCase
  fixtures :ht_docs

  def setup
    @controller = DocController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @first_id = ht_docs(:first).id
  end

  def test_index
    get :index
    assert_response :success
    assert_template 'list'
  end

  def test_list
    get :list

    assert_response :success
    assert_template 'list'

    assert_not_nil assigns(:ht_docs)
  end

  def test_show
    get :show, :id => @first_id

    assert_response :success
    assert_template 'show'

    assert_not_nil assigns(:ht_doc)
    assert assigns(:ht_doc).valid?
  end

  def test_new
    get :new

    assert_response :success
    assert_template 'new'

    assert_not_nil assigns(:ht_doc)
  end

  def test_create
    num_ht_docs = HtDoc.count

    post :create, :ht_doc => {}

    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_equal num_ht_docs + 1, HtDoc.count
  end

  def test_edit
    get :edit, :id => @first_id

    assert_response :success
    assert_template 'edit'

    assert_not_nil assigns(:ht_doc)
    assert assigns(:ht_doc).valid?
  end

  def test_update
    post :update, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'show', :id => @first_id
  end

  def test_destroy
    assert_nothing_raised {
      HtDoc.find(@first_id)
    }

    post :destroy, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_raise(ActiveRecord::RecordNotFound) {
      HtDoc.find(@first_id)
    }
  end
end
