require File.dirname(__FILE__) + '/../test_helper'
require 'msdefno_controller'

# Re-raise errors caught by the controller.
class MsdefnoController; def rescue_action(e) raise e end; end

class MsdefnoControllerTest < Test::Unit::TestCase
  fixtures :ms_def_nos

  def setup
    @controller = MsdefnoController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @first_id = ms_def_nos(:first).id
  end

  def test_index
    get :index
    assert_response :success
    assert_template 'list'
  end

  def test_list
    get :list

    assert_response :success
    assert_template 'list'

    assert_not_nil assigns(:ms_def_nos)
  end

  def test_show
    get :show, :id => @first_id

    assert_response :success
    assert_template 'show'

    assert_not_nil assigns(:ms_def_no)
    assert assigns(:ms_def_no).valid?
  end

  def test_new
    get :new

    assert_response :success
    assert_template 'new'

    assert_not_nil assigns(:ms_def_no)
  end

  def test_create
    num_ms_def_nos = MsDefNo.count

    post :create, :ms_def_no => {}

    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_equal num_ms_def_nos + 1, MsDefNo.count
  end

  def test_edit
    get :edit, :id => @first_id

    assert_response :success
    assert_template 'edit'

    assert_not_nil assigns(:ms_def_no)
    assert assigns(:ms_def_no).valid?
  end

  def test_update
    post :update, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'show', :id => @first_id
  end

  def test_destroy
    assert_nothing_raised {
      MsDefNo.find(@first_id)
    }

    post :destroy, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_raise(ActiveRecord::RecordNotFound) {
      MsDefNo.find(@first_id)
    }
  end
end
