require File.dirname(__FILE__) + '/../test_helper'
require 'mskbnmain_controller'

# Re-raise errors caught by the controller.
class MskbnmainController; def rescue_action(e) raise e end; end

class MskbnmainControllerTest < Test::Unit::TestCase
  fixtures :ms_kbn_mains

  def setup
    @controller = MskbnmainController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @first_id = ms_kbn_mains(:first).id
  end

  def test_index
    get :index
    assert_response :success
    assert_template 'list'
  end

  def test_list
    get :list

    assert_response :success
    assert_template 'list'

    assert_not_nil assigns(:ms_kbn_mains)
  end

  def test_show
    get :show, :id => @first_id

    assert_response :success
    assert_template 'show'

    assert_not_nil assigns(:ms_kbn_main)
    assert assigns(:ms_kbn_main).valid?
  end

  def test_new
    get :new

    assert_response :success
    assert_template 'new'

    assert_not_nil assigns(:ms_kbn_main)
  end

  def test_create
    num_ms_kbn_mains = MsKbnMain.count

    post :create, :ms_kbn_main => {}

    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_equal num_ms_kbn_mains + 1, MsKbnMain.count
  end

  def test_edit
    get :edit, :id => @first_id

    assert_response :success
    assert_template 'edit'

    assert_not_nil assigns(:ms_kbn_main)
    assert assigns(:ms_kbn_main).valid?
  end

  def test_update
    post :update, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'show', :id => @first_id
  end

  def test_destroy
    assert_nothing_raised {
      MsKbnMain.find(@first_id)
    }

    post :destroy, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_raise(ActiveRecord::RecordNotFound) {
      MsKbnMain.find(@first_id)
    }
  end
end
