#!/usr/bin/python
#
# usage: ls /boot/vmlinuz-* | python latest-version.py
# prints out the kernel of the latest version
#
# Copyright (C) 2007 zunda <zunda at freeshell.org>
#
# Permission is granted for copying, modification, distribution,
# and distribution of modified versions of this work under the
# terms of GPL version 2. Read the GPL file for more details.
#

import sys
import re

def version_array(string):
	s = re.split('[^\d]+', re.sub('[^\d\.-]', '', re.sub('.*?-', '', string, 1)))
	r = map(int, s)
	r.append(string)
	return r

candidates = []
for line in sys.stdin:
	candidates.append(version_array(line.strip()))

candidates.sort()
print candidates[-1][-1]
