#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/.root

## project input
echo "please input project name"
read PROJECTNAME

if [ ! -d ${ROOT}/project/${PROJECTNAME} ];then
 echo "project is not exist"
 exit 1
fi

## jobnet input
echo "please input jobnet name"
read JOBNETNAME

if [ "$JOBNETNAME" = "" ];then
 echo "jobnet name is null"
 exit 1
fi

if [ -d ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME} ];then
echo "jobnet is already exist"
exit 1
fi

## create log dir
mkdir -p ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}
if [ $? != 0 ];then
 echo "ERROR you can't create ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}"
 exit 1
fi

chmod 755 ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}
if [ $? != 0 ];then
 echo "ERROR you can't change permission ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}"
 exit 1
fi

## create log dir
mkdir -p ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}/log
if [ $? != 0 ];then
 echo "ERROR you can't create ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}/log"
 exit 1
fi

chmod 755 ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}/log
if [ $? != 0 ];then
 echo "ERROR you can't change permission ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}/log"
 exit 1
fi

cp ${ROOT}/template/* ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}
echo "ROOT=${ROOT}" > ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}/.root
echo "ROOT=${ROOT}" > ${ROOT}/utilities/.root


echo "-------------------------------------------------------------"
echo "Jobnet create succesfully. "
echo "Please edit profile ${ROOT}/project/${PROJECTNAME}/${JOBNETNAME}/jobnet.prof "
echo "-------------------------------------------------------------"
exit 0
