#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/.root

PROJECT=$1
JOBNET=$2
JOBNET_HOME=${ROOT}/project/${PROJECT}/${JOBNET}
UTL_SCHEDULE=${ROOT}/utilities/.schedule
DAEMON_ENT=${ROOT}/utilities/daemon_check.sh
ENABLE_FLAG=${JOBNET_HOME}/.enabled


if [ "${PROJECT}" = "" -o "${JOBNET}" = "" ];then
 echo "usage: mkcluster.sh <PROJECT> <JOBNET>"
 exit 1
fi

if [ ! -f ${ROOT}/project/${PROJECT}/${JOBNET}/cluster.conf ];then
 echo "cluster is not defined !! ${ROOT}/project/${PROJECT}/${JOBNET}/cluster.conf"
 exit 1
fi

## conf load
.  ${ROOT}/project/${PROJECT}/${JOBNET}/cluster.conf
.  ${ROOT}/cluster/global.conf


## global.conf check

if [ "${CONTROLLER}" = "" ];then
  echo "controller server is not defined !! ${ROOT}/cluster/global.conf"
  exit 1
fi

CLUSTER_CHECK=`echo "${CONTROLLER}" | awk '{print \$3}'`
if [ "${CLUSTER_CHECK}" ];then
 echo "controller server is under two server!! ${ROOT}/cluster/global.conf"
 exit 1
fi

if [ "${EXECUTE_SERVER}" = ""  -a "${DISPATCH}" = yes ];then
  echo "execute server is not defined !! ${ROOT}/cluster/global.conf"
  exit 1
fi

echo "this procedure take several minutes, please wait and see!"

## cluster check
IFCONFIG=/usr/sbin/ifconfig
LINUX=`uname -a | grep Linux`

if [ "${LINUX}" ];then
  IFCONFIG=/sbin/ifconfig
fi

if [ "${EXECUTE_SERVER}" ];then
 for RHOST in ${EXECUTE_SERVER}
 do
    IP_ADDR_CHECK=`${IFCONFIG} -a | grep ${RHOST}`
    if [ "${IP_ADDR_CHECK}" = "" ];then
      ssh -p ${SSH_PORT} ${RHOST} echo "connection test" > /dev/null 2>&1

      if [ $? != 0 ];then
       echo "ERROR ${RHOST} connection failed"
       echo "please confirm EXECUTE_SERVER ${ROOT}/cluster/global.conf"
       echo "you must set ssh key authentication"
       echo "see detail -> http://www.e-cron.org/manual"
       exit 1
      fi

    fi
 done
fi


## controller check

if [ "${CONTROLLER}" ];then
 for RHOST in ${CONTROLLER}
 do
    IP_ADDR_CHECK=`${IFCONFIG} -a | grep ${RHOST}`
    if [ "${IP_ADDR_CHECK}" = "" ];then
      
      ssh -p ${SSH_PORT} ${RHOST} ls ${ROOT} > /dev/null 2>&1

      if [ $? != 0 ];then
       echo "ERROR ${RHOST} connection failed"
       echo "please confirm CONTROLLER_SERVER ${ROOT}/cluster/global.conf"
       echo "you must install e-cron to remoteserver and set ssh key authentication"
       echo "see detail -> http://www.e-cron.org/manual"
       exit 1
      fi

      rsync -e "ssh -p ${SSH_PORT}" -alv ${ROOT}/project/${PROJECT}/${JOBNET} --exclude .enabled ${RHOST}:${ROOT}/project/${PROJECT}  > /dev/null 2>&1

      if [ $? != 0 ];then
       echo "ERROR ${RHOST} connection failed"
       echo "please confirm CONTROLLER_SERVER ${ROOT}/cluster/global.conf"
       exit 1
      fi

      scp -p -P ${SSH_PORT} ${ROOT}/cluster/global.conf @${RHOST}:${ROOT}/cluster/global.conf  > /dev/null 2>&1
      if [ $? != 0 ];then
       echo "ERROR ${RHOST} connection failed"
       echo "please confirm CONTROLLER_SERVER ${ROOT}/cluster/global.conf"
       exit 1
      fi
    fi
 done
fi

## daemon check

if [ "${CONTROLLER}" ];then
 for RHOST in ${CONTROLLER}
 do
    IP_ADDR_CHECK=`${IFCONFIG} -a | grep ${RHOST}`
    if [ "${IP_ADDR_CHECK}" = "" ];then
    
      DAEMON_CHECK=`ssh -p ${SSH_PORT} ${RHOST} ps -ef | grep ${ROOT}/sbin/ecron_clusterd | grep -v grep`
      if [ "${DAEMON_CHECK}" = "" ];then
         DAEMON_CHECK_WARN="WARN:cluster daemon not started on ${RHOST}, please execute enable_cluster.sh remote server"
      fi
      
      
    else
    
      DAEMON_CHECK=`ps -ef | grep ${ROOT}/sbin/ecron_clusterd | grep -v grep`
      if [ "${DAEMON_CHECK}" = "" ];then
         ${ROOT}/sbin/ecron_clusterd &
      fi
      sleep 2
      
      DAEMON_CHECK=`ps -ef | grep ${ROOT}/sbin/ecron_clusterd | grep -v grep`
      if [ "${DAEMON_CHECK}" = "" ];then
         echo "cluster daemon can't start localhost"
         exit 1
      fi
      
    fi
 done
fi

## jobnet check
if [ "${CONTROLLER}" ];then
 for RHOST in ${CONTROLLER}
 do
    IP_ADDR_CHECK=`${IFCONFIG} -a | grep ${RHOST}`
    if [ "${IP_ADDR_CHECK}" = "" ];then

      ssh -p ${SSH_PORT} ${RHOST} ls ${ENABLE_FLAG}  > /dev/null 2>&1
      if [ $?  != 0  ];then
        JOBNET_CHECK_WARN_REMOTE="WARN:jobnet is not enabled on ${RHOST}, please execute enable_jobnet.sh remote server too"
      fi

    else

      ls  ${ENABLE_FLAG}  > /dev/null 2>&1
      if [ $?  != 0  ];then
        JOBNET_CHECK_WARN_LOCAL="WARN:jobnet is not enabled on this server, please execute \"enable_jobnet.sh ${PROJECT} ${JOBNET}\""
      fi

    fi
 done
fi

## create cron entry
crontab -l > ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
  echo "maybe permission is wrong ${JOBNET_HOME}/.crontab_tmp"
  exit 1
fi

DAEMON_UTILITY_CHECK=`grep "${DAEMON_ENT}" ${JOBNET_HOME}/.crontab_tmp`
if [ "${DAEMON_UTILITY_CHECK}" = "" ];then
 echo "`grep DAEMON_CHECK ${UTL_SCHEDULE}| awk -F [:] '{print $2}'` ${DAEMON_ENT} > /dev/null 2>&1" >> ${JOBNET_HOME}/.crontab_tmp
 echo "ROOT=${ROOT}" > ${ROOT}/sbin/.root
fi


# crontab crontab_new
crontab ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
 echo "your schedule entry is not accurate."
 echo "please check schedule and retry"
 echo "${UTL_SCHEDULE}"
 exit 1
fi

echo "-------------------------------------------------------------"
echo "JOBNET:${JOBNET} clustered succesfully"
if [ "${DAEMON_CHECK_WARN}" -o "${JOBNET_CHECK_WARN_LOCAL}" -o "${JOBNET_CHECK_WARN_REMOTE}" ];then

 echo "+some warnings occured"

 if [ "${DAEMON_CHECK_WARN}" ];then
  echo "${DAEMON_CHECK_WARN}"
 fi
 
 if [ "${JOBNET_CHECK_WARN_LOCAL}" ];then
  echo "${JOBNET_CHECK_WARN_LOCAL}"
 fi

 if [ "${JOBNET_CHECK_WARN_REMOTE}" ];then
  echo "${JOBNET_CHECK_WARN_REMOTE}"
 fi

fi
echo "-------------------------------------------------------------"

rm  ${JOBNET_HOME}/.crontab_tmp
exit 0
