#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


## param setting
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
LOG_DIR=${SCRIPT_DIR}/../log
UNAME=`uname -n`
. ${SCRIPT_DIR}/../../../../.root
MONITOR_ERROR_QUE=${ROOT}/que/monitor/${UNAME}_error_`date +%Y%m%d`

JOB=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $NF } END {print field }'`
JOBNET=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $(NF-1) } END {print field }'`
PROJECT=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $(NF-2) } END {print field}'`

## jobnet prof load
grep -v SCHEDULE ${SCRIPT_DIR}/../jobnet.prof > ${SCRIPT_DIR}/.jobnet_tmp
chmod 766 ${SCRIPT_DIR}/.jobnet_tmp
. ${SCRIPT_DIR}/.jobnet_tmp


## conf load
. ${SCRIPT_DIR}/monitor.conf


## session number resource get
for PROTOCOL in ${PROTOCOLS}
do
  MONITOR_STATUS_QUE=${ROOT}/que/monitor/${PROJECT}_${JOBNET}_${PROTOCOL}_status
  SESSION_LOG=${LOG_DIR}/${PROTOCOL}_session.log_`date +%Y%m%d`

  if [ ! -f ${SESSION_LOG} -a "${PROTOCOL_CHECK}" ];then
    echo "time session_count" >  ${SESSION_LOG}
  fi

  TIME=`date +%T`
  SESSION=`netstat -a | grep -v grep | grep -v LISTEN | grep "${PROTOCOL} " | wc -l`

  if [ "${SESSION}" = "" ];then
    SESSION=0
  fi

  echo "${TIME} ${SESSION}" >> ${SESSION_LOG}
  echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${PROTOCOL} session count is ${SESSION}" > ${MONITOR_STATUS_QUE}


  if [ "${SESSION}" -gt "${WARN}" -a "${SESSION}" -lt "${CRIT}" ];then

    echo "`date +%Y/%m/%d` `date +%H:%M:%S` WARN ${PROTOCOL} session count is ${SESSION}" > ${MONITOR_STATUS_QUE}
    echo "`date +%Y/%m/%d` `date +%H:%M:%S` WARN ${PROTOCOL} count is ${SESSION}" >> ${MONITOR_ERROR_QUE}

    if [ ! -f ${SCRIPT_DIR}/.${PROTOCOL}_warn.tmp ];then

      if [ "${MAIL_ADDR}" ];then
        TIME=`date +%s`
        MAIL_QUE=${ROOT}/que/mail/${PROJECT}_${JOBNET}_${JOB}_${TIME}
        echo "MAIL_ADDR:${MAIL_ADDR}" > ${MAIL_QUE}
        echo "SUBJECT:SESSION WARN" >> ${MAIL_QUE}
        echo "CONTENTS:`date +%Y/%m/%d` `date +%H:%M:%S` WARN ${PROTOCOL} session count is ${SESSION}" >> ${MAIL_QUE}

      fi

      touch ${SCRIPT_DIR}/.${PROTOCOL}_warn.tmp

    fi

  else

   if [ -f ${SCRIPT_DIR}/.${PROTOCOL}_warn.tmp ];then
     rm ${SCRIPT_DIR}/.${PROTOCOL}_warn.tmp
   fi

  fi

  if [ "${SESSION}" -gt "${CRIT}" ];then

    echo "`date +%Y/%m/%d` `date +%H:%M:%S` CRIT ${PROTOCOL} count is ${SESSION}" > ${MONITOR_STATUS_QUE}
    echo "`date +%Y/%m/%d` `date +%H:%M:%S` CRIT ${PROTOCOL} count is ${SESSION}" >> ${MONITOR_ERROR_QUE}

    if [ ! -f ${SCRIPT_DIR}/.${PROTOCOL}_crit.tmp ];then

      if [ "${MAIL_ADDR}" ];then
        TIME=`date +%s`
        MAIL_QUE=${ROOT}/que/mail/${PROJECT}_${JOBNET}_${JOB}_${TIME}
        echo "MAIL_ADDR:${MAIL_ADDR}" > ${MAIL_QUE}
        echo "SUBJECT:SESSION CRIT">> ${MAIL_QUE}
        echo "CONTENTS:`date +%Y/%m/%d` `date +%H:%M:%S` CRIT ${PROTOCOL} session count is ${SESSION}" >> ${MAIL_QUE}

      fi

      touch ${SCRIPT_DIR}/.${PROTOCOL}_crit.tmp

    fi

  else

   if [ -f ${SCRIPT_DIR}/.${PROTOCOL}_crit.tmp ];then
     rm ${SCRIPT_DIR}/.${PROTOCOL}_crit.tmp
   fi

  fi

done

find ${SCRIPT_DIR} -type f -name *.tmp -mtime +0 |  xargs rm -f
exit 0
