/*
 * Sun_RAR.java
 *
 * Created on 2007/12/19, 23:21
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package earupdater.transformer;

import java.io.*;

/**
 *
 * @author Administrator
 */
public class Sun_RAR implements DDTransformer {

    private File sun_rar;
    private byte[] innerbuffer;
    private boolean showdetaillog;


    /** Creates a new instance of Sun_RAR */
    //public Sun_RAR() {
    //}

    public Sun_RAR(File file) {
        this.sun_rar = file;
    }

    public String showChangingPoint() {

        StringBuffer sb = new StringBuffer();
        sb.append("変更箇所：").append("\n");
        sb.append("Idle_timeout_in_seconds = 300").append("\n");
        sb.append("Max_pool_size = 320").append("\n");
        sb.append("Max_wait_time_in_millis = 30000").append("\n");
        sb.append("Steady_pool_size = 40").append("\n");

        return sb.toString();

    }

    private void convertPure_Sun_RAR() {
        try {
        StringBuffer sb = new StringBuffer(4096);
        BufferedReader br = new BufferedReader(new FileReader(this.sun_rar));
        String line = null;
        while ((line = br.readLine()) != null) {
            int index = line.indexOf("xmlns=\"http://java.sun.com/xml/ns/j2ee\"");
            if (index != -1) {
                String newline = line.replaceAll("xmlns=\"http://java.sun.com/xml/ns/j2ee\"", "");
                sb.append(newline);
                sb.append("\n");
            } else {
                sb.append(line);
                sb.append("\n");
            }
        }

        //baos = new ByteArrayOutputStream();
        //baos.write(sb.toString().getBytes(), 0, sb.toString().getBytes().length);
        this.innerbuffer = sb.toString().getBytes();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getBytes() {
        //return baos.toByteArray();
        return this.innerbuffer;
    }

    public byte[] transform() {
        try {
        convertPure_Sun_RAR();

        if (this.showdetaillog)
        System.out.println("変更前：" + new String(this.innerbuffer));

        dtd.sun_connector_1_0_01586737019.Sun_connector sunconnectorotd = new dtd.sun_connector_1_0_01586737019.Sun_connector();
        sunconnectorotd.unmarshalFromBytes(getBytes());
        sunconnectorotd.getResource_adapter().setIdle_timeout_in_seconds("300");
        sunconnectorotd.getResource_adapter().setMax_pool_size("320");
        sunconnectorotd.getResource_adapter().setMax_wait_time_in_millis("30000");
        sunconnectorotd.getResource_adapter().setSteady_pool_size("40");

        this.innerbuffer = sunconnectorotd.marshalToBytes();

        if (this.showdetaillog)
        System.out.println("変更後：" + new String(this.innerbuffer));



        } catch (Exception e) {
            System.err.println("Sun_RAR.transform処理中に例外が発生しました。");
            e.printStackTrace();
            try {
            throw e;
            } catch (Exception ie) {
                //nothing...
            }
        }

        return this.innerbuffer;
    }

    public void transformAndSave(File outputfile) throws Exception {
        java.io.FileOutputStream fo = null;
        fo = new FileOutputStream(outputfile);
        //fo.write(sunconnectorotd.marshalToBytes());
        fo.write(transform());
        fo.close();
    }

    public void setShowTransformationDetailLog(boolean value) {
        this.showdetaillog = value;
    }

}
