/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j;

import fuku.eb4j.EBException;
import fuku.eb4j.IndexStyle;
import fuku.eb4j.Result;
import fuku.eb4j.Searcher;
import fuku.eb4j.SingleWordSearcher;
import fuku.eb4j.SubBook;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;

public class MultiWordSearcher
implements Searcher {
    private SubBook _sub = null;
    private IndexStyle _style = null;
    private IndexStyle[] _entry = null;
    private SingleWordSearcher[] _searcher = null;
    private int _type = -1;

    protected MultiWordSearcher(SubBook sub, IndexStyle style, int type) {
        this._sub = sub;
        this._style = style;
        this._type = type;
    }

    protected MultiWordSearcher(SubBook sub, IndexStyle multi, IndexStyle[] entry) {
        this._sub = sub;
        this._style = multi;
        this._entry = entry;
        this._type = 5;
    }

    protected void search(byte[][] word) throws EBException {
        int len = word.length;
        ArrayList<SingleWordSearcher> list = new ArrayList<SingleWordSearcher>(len);
        for (int i = 0; i < len; ++i) {
            if (ArrayUtils.isEmpty((byte[])word[i])) continue;
            SingleWordSearcher search = this._entry == null ? new SingleWordSearcher(this._sub, this._style, this._type) : new SingleWordSearcher(this._sub, this._entry[i], this._type);
            search.search(word[i]);
            list.add(search);
        }
        this._searcher = list.toArray(new SingleWordSearcher[list.size()]);
    }

    @Override
    public Result getNextResult() throws EBException {
        long pos2;
        int i;
        if (ArrayUtils.isEmpty((Object[])this._searcher)) {
            return null;
        }
        int len = this._searcher.length;
        Result[] result = new Result[len];
        long pos1 = -1L;
        int count = 0;
        for (i = 0; i < len; ++i) {
            result[i] = this._searcher[i].getNextResult();
            if (result[i] == null) {
                return null;
            }
            pos2 = result[i].getTextPosition();
            if (pos1 < 0L) {
                pos1 = pos2;
                ++count;
                continue;
            }
            if (pos1 < pos2) {
                pos1 = pos2;
                count = 0;
                continue;
            }
            if (pos1 != pos2) continue;
            ++count;
        }
        while (count != len) {
            count = 0;
            for (i = 0; i < len; ++i) {
                if (pos1 != result[i].getTextPosition()) {
                    result[i] = this._searcher[i].getNextResult();
                    if (result[i] == null) {
                        return null;
                    }
                    pos2 = result[i].getTextPosition();
                    if (pos1 < pos2) {
                        pos1 = pos2;
                        count = 0;
                        continue;
                    }
                    if (pos1 != pos2) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
        }
        return result[0];
    }
}

