/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.util;

import java.io.UnsupportedEncodingException;

public class ByteUtil {
    private static final int[] ASCII_TO_JISX0208_TABLE = new int[]{8481, 8490, 8521, 8564, 8560, 8563, 8565, 8519, 8522, 8523, 8566, 8540, 8484, 8541, 8485, 8511, 9008, 9009, 9010, 9011, 9012, 9013, 9014, 9015, 9016, 9017, 8487, 8488, 8547, 8545, 8548, 8489, 8567, 9025, 9026, 9027, 9028, 9029, 9030, 9031, 9032, 9033, 9034, 9035, 9036, 9037, 9038, 9039, 9040, 9041, 9042, 9043, 9044, 9045, 9046, 9047, 9048, 9049, 9050, 8526, 8512, 8527, 8496, 8498, 8518, 9057, 9058, 9059, 9060, 9061, 9062, 9063, 9064, 9065, 9066, 9067, 9068, 9069, 9070, 9071, 9072, 9073, 9074, 9075, 9076, 9077, 9078, 9079, 9080, 9081, 9082, 8528, 8515, 8529, 8513};
    private static final int[] JISX0201_TO_JISX0208_TABLE = new int[]{0, 8483, 8534, 8535, 8482, 8486, 9586, 9505, 9507, 9509, 9511, 9513, 9571, 9573, 9575, 9539, 8508, 9506, 9508, 9510, 9512, 9514, 9515, 9517, 9519, 9521, 9523, 9525, 9527, 9529, 9531, 9533, 9535, 9537, 9540, 9542, 9544, 9546, 9547, 9548, 9549, 9550, 9551, 9554, 9557, 9560, 9563, 9566, 9567, 9568, 9569, 9570, 9572, 9574, 9576, 9577, 9578, 9579, 9580, 9581, 9583, 9587, 8491, 8492};
    private static final byte[] LONG_VOWEL_TABLE = new byte[]{34, 34, 36, 36, 38, 38, 40, 40, 42, 42, 34, 34, 36, 36, 38, 38, 40, 40, 42, 42, 34, 34, 36, 36, 38, 38, 40, 40, 42, 42, 34, 34, 36, 36, 38, 38, 38, 40, 40, 42, 42, 34, 36, 38, 40, 42, 34, 34, 34, 36, 36, 36, 38, 38, 38, 40, 40, 40, 42, 42, 42, 34, 36, 38, 40, 42, 34, 34, 38, 38, 42, 42, 34, 36, 38, 40, 42, 34, 34, 36, 40, 42, 115, 38, 34, 40};
    private static final byte[] VOICED_CONSONANT_TABLE = new byte[]{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 43, 45, 45, 47, 47, 49, 49, 51, 51, 53, 53, 55, 55, 57, 57, 59, 59, 61, 61, 63, 63, 65, 65, 67, 68, 68, 70, 70, 72, 72, 74, 75, 76, 77, 78, 79, 79, 81, 82, 82, 84, 85, 85, 87, 88, 88, 90, 91, 91, 93, 94, 95, 96, 97, 98, 100, 100, 102, 102, 104, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 38, 117, 118};

    private ByteUtil() {
    }

    public static int getInt2(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF;
    }

    public static int getInt3(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 16 | (b[offset + 1] & 0xFF) << 8 | b[offset + 2] & 0xFF;
    }

    public static int getIntLE2(byte[] b, int offset) {
        return (b[offset + 1] & 0xFF) << 8 | b[offset] & 0xFF;
    }

    public static int getBCD2(byte[] b, int offset) {
        int ret = b[offset + 1] & 0xF;
        ret += (b[offset + 1] >>> 4 & 0xF) * 10;
        ret += (b[offset] & 0xF) * 100;
        return ret += (b[offset] >>> 4 & 0xF) * 1000;
    }

    public static int getBCD4(byte[] b, int offset) {
        int ret = b[offset + 3] & 0xF;
        ret += (b[offset + 3] >>> 4 & 0xF) * 10;
        ret += (b[offset + 2] & 0xF) * 100;
        ret += (b[offset + 2] >>> 4 & 0xF) * 1000;
        ret += (b[offset + 1] & 0xF) * 10000;
        ret += (b[offset + 1] >>> 4 & 0xF) * 100000;
        ret += (b[offset] & 0xF) * 1000000;
        return ret += (b[offset] >>> 4 & 0xF) * 10000000;
    }

    public static long getLong4(byte[] b, int offset) {
        long ret = ((long)b[offset] & 0xFFL) << 24;
        ret += ((long)b[offset + 1] & 0xFFL) << 16;
        ret += ((long)b[offset + 2] & 0xFFL) << 8;
        return ret += (long)b[offset + 3] & 0xFFL;
    }

    public static long getLong5(byte[] b, int offset) {
        long ret = ((long)b[offset] & 0xFFL) << 32;
        ret += ((long)b[offset + 1] & 0xFFL) << 24;
        ret += ((long)b[offset + 2] & 0xFFL) << 16;
        ret += ((long)b[offset + 3] & 0xFFL) << 8;
        return ret += (long)b[offset + 4] & 0xFFL;
    }

    public static long getLongLE4(byte[] b, int offset) {
        long ret = ((long)b[offset + 3] & 0xFFL) << 24;
        ret += ((long)b[offset + 2] & 0xFFL) << 16;
        ret += ((long)b[offset + 1] & 0xFFL) << 8;
        return ret += (long)b[offset] & 0xFFL;
    }

    public static String narrowToWide(String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            int codePoint = str.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                buf.appendCodePoint(codePoint);
                i = i + Character.charCount(codePoint) - 1;
                continue;
            }
            switch (codePoint) {
                case 32: {
                    buf.append('\u3000');
                    continue block5;
                }
                case 39: {
                    buf.append('\u2019');
                    continue block5;
                }
                case 34: {
                    buf.append('\u201d');
                    continue block5;
                }
                default: {
                    if (codePoint >= 33 && codePoint <= 126) {
                        codePoint += 65248;
                    }
                    buf.appendCodePoint(codePoint);
                }
            }
        }
        return buf.toString();
    }

    public static String wideToNarrow(String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            int codePoint = str.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                buf.appendCodePoint(codePoint);
                i = i + Character.charCount(codePoint) - 1;
                continue;
            }
            switch (codePoint) {
                case 12288: {
                    buf.append(' ');
                    continue block7;
                }
                case 8217: {
                    buf.append('\'');
                    continue block7;
                }
                case 8722: {
                    buf.append('-');
                    continue block7;
                }
                case 8221: {
                    buf.append('\"');
                    continue block7;
                }
                case 12316: 
                case 65507: {
                    buf.append('~');
                    continue block7;
                }
                default: {
                    if (codePoint >= 65281 && codePoint <= 65374) {
                        codePoint -= 65248;
                    }
                    buf.appendCodePoint(codePoint);
                }
            }
        }
        return buf.toString();
    }

    public static int asciiToJISX0208(int code) {
        return ASCII_TO_JISX0208_TABLE[code - 32];
    }

    public static int jisx0201ToJISX0208(int code) {
        return JISX0201_TO_JISX0208_TABLE[code - 160];
    }

    public static String gb2312ToString(byte[] b) {
        return ByteUtil.gb2312ToString(b, 0, b.length);
    }

    public static String gb2312ToString(byte[] b, int offset, int len) {
        byte[] buf = new byte[len];
        for (int i = 0; i < len / 2; ++i) {
            if (b[offset + i * 2] != 0) {
                buf[i * 2] = (byte)(b[offset + i * 2] | 0x80);
                buf[i * 2 + 1] = b[offset + i * 2 + 1];
                continue;
            }
            buf[i * 2] = 0;
            buf[i * 2 + 1] = 0;
        }
        String str = null;
        try {
            str = new String(buf, "EUC-CN");
        }
        catch (UnsupportedEncodingException e) {
            str = new String(buf);
        }
        return str.trim();
    }

    public static String jisx0208ToString(byte[] b) {
        return ByteUtil.jisx0208ToString(b, 0, b.length);
    }

    public static String jisx0208ToString(byte[] b, int offset, int len) {
        byte[] buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = b[offset + i] != 0 ? (byte)(b[offset + i] | 0x80) : (byte)0;
        }
        String str = null;
        try {
            str = new String(buf, "EUC-JP");
        }
        catch (UnsupportedEncodingException e) {
            str = new String(buf);
        }
        return str.trim();
    }

    public static byte[] stringToJISX0208(String str) {
        byte[] b;
        if (str == null || str.length() <= 0) {
            return new byte[0];
        }
        String s = str.replace('\t', ' ').trim();
        StringBuilder buf = new StringBuilder(s);
        while (buf.charAt(0) == '\u3000') {
            buf.deleteCharAt(0);
        }
        int len = buf.length();
        while (buf.charAt(len - 1) == '\u3000') {
            buf.deleteCharAt(len - 1);
            len = buf.length();
        }
        try {
            b = buf.toString().getBytes("EUC-JP");
        }
        catch (UnsupportedEncodingException e) {
            b = buf.toString().getBytes();
        }
        int size = b.length;
        if (size <= 0) {
            return new byte[0];
        }
        byte[] tmp = new byte[size * 2];
        len = 0;
        for (int i = 0; i < size; ++i) {
            int low;
            int c;
            int high = b[i] & 0xFF;
            if (high >= 32 && high <= 126) {
                c = ASCII_TO_JISX0208_TABLE[high - 32];
                high = c >>> 8;
                low = c & 0xFF;
            } else if (high >= 161 && high <= 254) {
                low = b[i + 1] & 0xFF;
                if (low >= 161 && low <= 254) {
                    high &= 0x7F;
                    low &= 0x7F;
                } else {
                    return new byte[0];
                }
                ++i;
            } else if (high == 142) {
                low = b[i + 1] & 0xFF;
                if (low < 161 || low > 223) {
                    return new byte[0];
                }
                c = JISX0201_TO_JISX0208_TABLE[low - 160];
                high = c >>> 8;
                low = c & 0xFF;
                ++i;
            } else {
                return new byte[0];
            }
            tmp[len] = (byte)high;
            tmp[len + 1] = (byte)low;
            len += 2;
        }
        byte[] ret = new byte[len];
        System.arraycopy(tmp, 0, ret, 0, len);
        return ret;
    }

    public static void katakanaToHiragana(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 37 || low < 33 || low > 118) continue;
            b[i] = 36;
        }
    }

    public static void hiraganaToKatakana(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 36 || low < 33 || low > 118) continue;
            b[i] = 37;
        }
    }

    public static void upperToLowerLatin(byte[] b) {
        int ch;
        int len = b.length;
        for (int i = 0; i < len && (ch = b[i] & 0xFF) != 0; ++i) {
            if (!(ch >= 65 && ch <= 90 || ch >= 192 && ch <= 214) && (ch < 216 || ch > 222)) continue;
            b[i] = (byte)(ch + 32);
        }
    }

    public static void lowerToUpperLatin(byte[] b) {
        int ch;
        int len = b.length;
        for (int i = 0; i < len && (ch = b[i] & 0xFF) != 0; ++i) {
            if (!(ch >= 97 && ch <= 122 || ch >= 224 && ch <= 246) && (ch < 248 || ch > 254)) continue;
            b[i] = (byte)(ch - 32);
        }
    }

    public static void upperToLower(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 35 || low < 65 || low > 90) continue;
            b[i + 1] = (byte)(low + 32);
        }
    }

    public static void lowerToUpper(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 35 || low < 97 || low > 122) continue;
            b[i + 1] = (byte)(low - 32);
        }
    }

    public static void convertLongVowel(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        int prevHigh = 0;
        int prevLow = 0;
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high == 33 && low == 60 && (prevHigh == 36 || prevHigh == 37) && prevLow >= 33 && prevLow <= 118) {
                b[i] = (byte)prevHigh;
                b[i + 1] = LONG_VOWEL_TABLE[prevLow - 33];
            }
            prevHigh = high;
            prevLow = low;
        }
    }

    public static void deleteLongVowel(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        int count = 0;
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) {
                count = count + len - i;
                break;
            }
            if (high == 33 && low == 60) {
                count += 2;
                continue;
            }
            b[i - count] = (byte)high;
            b[i - count + 1] = (byte)low;
        }
        if (count > 0) {
            int size = b.length;
            for (int i = len - count; i < size; ++i) {
                b[i] = 0;
            }
        }
    }

    public static void convertDoubleConsonant(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 36 && high != 37 || low != 67) continue;
            b[i + 1] = 68;
        }
    }

    public static void convertContractedSound(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 36 && high != 37) continue;
            if (low == 99 || low == 101 || low == 103 || low == 110) {
                b[i + 1] = (byte)(low + 1);
                continue;
            }
            if (low == 117) {
                b[i + 1] = 43;
                continue;
            }
            if (low != 118) continue;
            b[i + 1] = 49;
        }
    }

    public static void convertVoicedConsonant(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 36 && high != 37 || low < 33 || low > 118) continue;
            b[i + 1] = VOICED_CONSONANT_TABLE[low - 33];
        }
    }

    public static void convertSmallVowel(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 36 && high != 37 || low != 33 && low != 35 && low != 37 && low != 39 && low != 41) continue;
            b[i + 1] = (byte)(low + 1);
        }
    }

    public static void convertPSound(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) break;
            if (high != 36 && high != 37 || low != 81 && low != 84 && low != 87 && low != 90 && low != 93) continue;
            b[i + 1] = (byte)(low - 2);
        }
    }

    public static void deleteMark(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        int count = 0;
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) {
                count = count + len - i;
                break;
            }
            if (high == 33 && (low == 38 || low == 62 || low == 71 || low == 93)) {
                count += 2;
                continue;
            }
            b[i - count] = (byte)high;
            b[i - count + 1] = (byte)low;
        }
        if (count > 0) {
            int size = b.length;
            for (int i = len - count; i < size; ++i) {
                b[i] = 0;
            }
        }
    }

    public static void deleteSpaceLatin(byte[] b) {
        int i;
        int count = 0;
        int len = b.length;
        for (i = 0; i < len; ++i) {
            int ch = b[i] & 0xFF;
            if (ch == 0) {
                count = count + len - i;
                break;
            }
            if (ch == 32) {
                ++count;
                continue;
            }
            b[i - count] = (byte)ch;
        }
        if (count > 0) {
            for (i = len - count; i < len; ++i) {
                b[i] = 0;
            }
        }
    }

    public static void deleteSpace(byte[] b) {
        int len = b.length;
        if ((len & 1) == 1) {
            b[len - 1] = 0;
            --len;
        }
        int count = 0;
        for (int i = 0; i < len; i += 2) {
            int high = b[i] & 0xFF;
            int low = b[i + 1] & 0xFF;
            if (high == 0 || low == 0) {
                count = count + len - i;
                break;
            }
            if (high == 33 && low == 33) {
                count += 2;
                continue;
            }
            b[i - count] = (byte)high;
            b[i - count + 1] = (byte)low;
        }
        if (count > 0) {
            int size = b.length;
            for (int i = len - count; i < size; ++i) {
                b[i] = 0;
            }
        }
    }

    public static void reverseWordLatin(byte[] b) {
        int i;
        int len = 0;
        int size = b.length;
        for (i = size - 1; i >= 0; --i) {
            if ((b[i] & 0xFF) == 0) continue;
            len = i + 1;
            break;
        }
        for (i = 0; i < len / 2; ++i) {
            byte tmp = b[i];
            b[i] = b[size - 1 - i];
            b[size - 1 - i] = tmp;
        }
    }

    public static void reverseWord(byte[] b) {
        int i;
        int len = 0;
        for (i = b.length - 1; i >= 0; --i) {
            if ((b[i] & 0xFF) == 0) continue;
            len = i + 1;
            break;
        }
        if (len & true) {
            b[len - 1] = 0;
            --len;
        }
        for (i = 0; i < len / 2; i += 2) {
            byte tmp = b[i];
            b[i] = b[len - 2 - i];
            b[len - 2 - i] = tmp;
            tmp = b[i + 1];
            b[i + 1] = b[len - 1 - i];
            b[len - 1 - i] = tmp;
        }
    }
}

