/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.EBZipInputStream;
import fuku.eb4j.io.EPWINGInputStream;
import fuku.eb4j.io.FileInfo;
import fuku.eb4j.io.PlainInputStream;
import fuku.eb4j.io.SEBXAInputStream;
import java.io.File;
import org.apache.commons.lang.ArrayUtils;

public class EBFile {
    public static final int FORMAT_PLAIN = 0;
    public static final int FORMAT_EBZIP = 1;
    public static final int FORMAT_EPWING = 2;
    public static final int FORMAT_EPWING6 = 3;
    public static final int FORMAT_SEBXA = 4;
    private FileInfo _info = new FileInfo();
    private String _name = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBFile(File dir, String name, int defaultFormat) throws EBException {
        String ebzName = name + ".ebz";
        String orgName = name + ".org";
        Object[] list = dir.list();
        if (!ArrayUtils.isEmpty((Object[])list)) {
            int len = list.length;
            for (int i = 0; i < len; ++i) {
                File f = new File(dir, (String)list[i]);
                if (f.isDirectory()) continue;
                if (((String)list[i]).equalsIgnoreCase(name)) {
                    this._info.setFile(f);
                    this._info.setFormat(defaultFormat);
                    this._name = list[i];
                    break;
                }
                if (((String)list[i]).equalsIgnoreCase(orgName)) {
                    this._info.setFile(f);
                    this._info.setFormat(0);
                    this._name = ((String)list[i]).substring(0, ((String)list[i]).length() - 4);
                    break;
                }
                if (!((String)list[i]).equalsIgnoreCase(ebzName)) continue;
                this._info.setFile(f);
                this._info.setFormat(1);
                this._name = ((String)list[i]).substring(0, ((String)list[i]).length() - 4);
                break;
            }
        }
        if (this._info.getFile() == null) {
            throw new EBException(2, dir.getPath(), name);
        }
        if (!this._info.getFile().canRead()) {
            throw new EBException(3, this._info.getPath());
        }
        BookInputStream bis = this.getInputStream();
        try {
            bis.initFileInfo();
        }
        finally {
            bis.close();
        }
    }

    public static File searchDirectory(String path, String name) throws EBException {
        return EBFile.searchDirectory(new File(path), name);
    }

    public static File searchDirectory(File dir, String name) throws EBException {
        Object[] list = dir.list();
        File d = null;
        if (!ArrayUtils.isEmpty((Object[])list)) {
            int len = list.length;
            for (int i = 0; i < len; ++i) {
                File f = new File(dir, (String)list[i]);
                if (!f.isDirectory() || !((String)list[i]).equalsIgnoreCase(name)) continue;
                d = f;
                break;
            }
        }
        if (d == null) {
            throw new EBException(0, dir.getPath(), name);
        }
        if (!d.canRead()) {
            throw new EBException(1, dir.getPath());
        }
        return d;
    }

    public File getFile() {
        return this._info.getFile();
    }

    public String getPath() {
        return this._info.getPath();
    }

    public String getName() {
        return this._name;
    }

    public int getFormat() {
        return this._info.getFormat();
    }

    public void setSEBXAInfo(long index, long base, long start, long end) {
        this._info.setSebxaIndexPosition(index);
        this._info.setSebxaBasePosition(base);
        this._info.setSebxaStartPosition(start);
        this._info.setSebxaEndPosition(end);
        this._info.setFileSize(end);
        this._info.setFormat(4);
    }

    public BookInputStream getInputStream() throws EBException {
        BookInputStream bis = null;
        switch (this._info.getFormat()) {
            case 1: {
                bis = new EBZipInputStream(this._info);
                break;
            }
            case 2: 
            case 3: {
                bis = new EPWINGInputStream(this._info);
                break;
            }
            case 4: {
                bis = new SEBXAInputStream(this._info);
                break;
            }
            default: {
                bis = new PlainInputStream(this._info);
            }
        }
        return bis;
    }
}

