/*
 * Decompiled with CFR 0.152.
 */
package fuku.eb4j.io;

import fuku.eb4j.EBException;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.io.FileInfo;
import java.io.IOException;

public class PlainInputStream
extends BookInputStream {
    protected PlainInputStream(FileInfo info) throws EBException {
        super(info);
        this.open();
        this.cache = new byte[2048];
    }

    @Override
    protected void initFileInfo() throws EBException {
        try {
            this.info.setRealFileSize(this.stream.length());
            this.info.setFileSize(this.info.getRealFileSize());
        }
        catch (IOException e) {
            throw new EBException(4, this.info.getPath(), e);
        }
        super.initFileInfo();
    }

    @Override
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            int rest;
            if (this.info.getFileSize() <= this.filePos) {
                if (rlen == 0) {
                    return -1;
                }
                return rlen;
            }
            if (this.cachePos < 0L || this.filePos < this.cachePos || this.cachePos + 2048L <= this.filePos) {
                this.cachePos = this.filePos - this.filePos % 2048L;
                try {
                    this.stream.seek(this.cachePos);
                }
                catch (IOException e) {
                    throw new EBException(6, this.info.getPath(), e);
                }
                int readLen = 2048;
                if (this.info.getFileSize() < this.cachePos + 2048L) {
                    readLen = (int)(this.info.getFileSize() - this.cachePos);
                }
                this.readRawFully(this.cache, 0, readLen);
            }
            int cacheLen = 2048;
            if (this.info.getFileSize() < this.cachePos + 2048L) {
                cacheLen = (int)(this.info.getFileSize() - this.cachePos);
            }
            if (len - rlen < (rest = (int)((long)cacheLen - this.filePos % 2048L))) {
                rest = len - rlen;
            }
            if (this.info.getFileSize() - this.filePos < (long)rest) {
                rest = (int)(this.info.getFileSize() - this.filePos);
            }
            int p = (int)(this.filePos % 2048L);
            System.arraycopy(this.cache, p, b, off + rlen, rest);
            rlen += rest;
            this.filePos += (long)rest;
        }
        return rlen;
    }
}

