/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.WdicUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdicDirList {
    private static final String ENCODING = "UTF-8";
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private File _file = null;
    private Map<String, String> _map = null;
    private Map<String, String> _alias = null;

    public WdicDirList(File file) {
        this._file = file;
        this._map = new LinkedHashMap<String, String>();
        this._alias = new HashMap<String, String>();
        this._load();
    }

    public List<String> getChildren(String parent) {
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = parent.length();
        for (String key : this._map.keySet()) {
            String str;
            if (!key.startsWith(parent) || key.equals(parent) || (str = key.substring(len)).contains("/")) continue;
            list.add(key);
        }
        return list;
    }

    public String getName(String dir) {
        return this._map.get(dir);
    }

    public boolean hasAlias(String dir) {
        return this._alias.containsKey(dir);
    }

    public String getAlias(String dir) {
        return this._alias.get(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _load() {
        LineIterator it = null;
        try {
            this._logger.info("load file: " + this._file.getPath());
            it = FileUtils.lineIterator((File)this._file, (String)ENCODING);
            while (it.hasNext()) {
                String line = WdicUtil.sanitize(it.nextLine());
                String[] item = line.split("\\t");
                int n = item.length;
                if (n == 3) {
                    this._map.put(item[0], item[2]);
                    this._alias.put(item[0], item[1]);
                    continue;
                }
                if (n == 2) {
                    this._map.put(item[0], item[1]);
                    continue;
                }
                this._logger.warn("too many items in line: " + line);
            }
            LineIterator.closeQuietly((LineIterator)it);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            LineIterator.closeQuietly(it);
        }
    }
}

