/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.converter.wdic;

import fuku.xml2eb.converter.wdic.WdicItem;
import fuku.xml2eb.converter.wdic.WdicTableItem;
import fuku.xml2eb.converter.wdic.WdicTableRow;
import fuku.xml2eb.converter.wdic.WdicUtil;
import fuku.xml2eb.util.WaitImageObserver;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdicTable {
    private Logger _logger = null;
    private WdicItem _item = null;
    private String _id = null;
    List<String> _list = new ArrayList<String>();
    private BufferedImage _img = null;

    public WdicTable(WdicItem item) {
        this._logger = LoggerFactory.getLogger(this.getClass());
        this._item = item;
        String grpId = this._item.getWdic().getGroupId();
        String partId = this._item.getWdic().getPartId();
        this._id = grpId + ":" + partId + ":" + this._item.getHead();
    }

    public void add(String line) {
        this._list.add(line);
    }

    public BufferedImage getImage() {
        if (this._img == null) {
            this._makeImage();
        }
        return this._img;
    }

    private void _makeImage() {
        int i;
        int h;
        int w;
        WdicTableItem item;
        int j;
        WdicTableRow row;
        int i2;
        List<WdicTableRow> rowList = this._parse();
        int size = rowList.size();
        int cols = -1;
        for (int i3 = 0; i3 < size; ++i3) {
            WdicTableRow row2 = rowList.get(i3);
            int n = row2.size();
            if (cols == -1) {
                cols = n;
                continue;
            }
            if (n == cols) continue;
            this._logger.warn("different column size: " + this._id + " [" + cols + "," + n + "]");
            if (n >= cols) continue;
            cols = n;
        }
        if (cols < 1) {
            this._logger.warn("column data unavailable: " + this._id);
            return;
        }
        int hpad = 4;
        int vpad = 2;
        int[] width = new int[cols];
        int[] height = new int[size];
        for (i2 = 0; i2 < size; ++i2) {
            row = rowList.get(i2);
            for (j = 0; j < cols; ++j) {
                item = row.get(j);
                if (item.isHBonding() || item.isVBonding()) continue;
                if (!(j + 1 < cols && row.get(j + 1).isHBonding() || (w = item.getWidth()) <= width[j])) {
                    width[j] = w;
                }
                if (i2 + 1 < size && rowList.get(i2 + 1).get(j).isVBonding() || (h = item.getHeight()) <= height[i2]) continue;
                height[i2] = h;
            }
        }
        for (i2 = 0; i2 < size; ++i2) {
            row = rowList.get(i2);
            for (j = 0; j < cols; ++j) {
                int k;
                int k2;
                int cnt;
                item = row.get(j);
                if (item.isHBonding() || item.isVBonding()) continue;
                if (j + 1 < cols && row.get(j + 1).isHBonding()) {
                    w = item.getWidth();
                    cnt = 2;
                    int tw = width[j] + width[j + 1] + hpad * 2 + 1;
                    for (k2 = j + 2; k2 < cols && row.get(k2).isHBonding(); ++k2) {
                        ++cnt;
                        tw += width[k2] + hpad * 2 + 1;
                    }
                    if (w > tw) {
                        int dw = (w - tw) / cnt;
                        for (k = 0; k < cnt; ++k) {
                            int n = j + k;
                            width[n] = width[n] + dw;
                        }
                    }
                }
                if (i2 + 1 >= size || !rowList.get(i2 + 1).get(j).isVBonding()) continue;
                h = item.getHeight();
                cnt = 2;
                int th = height[i2] + height[i2 + 1] + vpad * 2 + 1;
                for (k2 = i2 + 2; k2 < size && rowList.get(k2).get(j).isVBonding(); ++k2) {
                    ++cnt;
                    th += height[k2] + vpad * 2 + 1;
                }
                if (h <= th) continue;
                int dh = (h - th) / cnt;
                for (k = 0; k < cnt; ++k) {
                    int n = i2 + k;
                    height[n] = height[n] + dh;
                }
            }
        }
        int imageWidth = (cols + 1) * (1 + hpad * 2);
        for (int i4 = 0; i4 < cols; ++i4) {
            imageWidth += width[i4];
        }
        int imageHeight = (size + 1) * (1 + vpad * 2);
        for (int i5 = 0; i5 < size; ++i5) {
            imageHeight += height[i5];
        }
        this._img = new BufferedImage(imageWidth, imageHeight, 13);
        Graphics2D g2 = this._img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, imageWidth, imageHeight);
        g2.setColor(Color.BLACK);
        int y = 1 + vpad * 2;
        for (i = 0; i < size; ++i) {
            WdicTableRow row3 = rowList.get(i);
            int x = 1 + hpad * 2;
            int h2 = height[i];
            for (int j2 = 0; j2 < cols; ++j2) {
                WdicTableItem item2 = row3.get(j2);
                int w2 = width[j2];
                if (!item2.isHBonding() && !item2.isVBonding()) {
                    int tw = w2;
                    for (int k = j2 + 1; k < cols && row3.get(k).isHBonding(); ++k) {
                        tw += width[k] + hpad * 2 + 1;
                    }
                    int th = h2;
                    for (int k = i + 1; k < size && rowList.get(k).get(j2).isVBonding(); ++k) {
                        th += height[k] + vpad * 2 + 1;
                    }
                    BufferedImage[] imgs = item2.getImage();
                    int n = imgs.length;
                    int dy = (th - item2.getHeight()) / 2;
                    for (int k = 0; k < n; ++k) {
                        int dx = 0;
                        switch (item2.getAlign()) {
                            case 1: {
                                dx = (tw - imgs[k].getWidth()) / 2;
                                break;
                            }
                            case 2: {
                                dx = tw - imgs[k].getWidth();
                                break;
                            }
                        }
                        WaitImageObserver obs = new WaitImageObserver();
                        if (!g2.drawImage((Image)imgs[k], x + dx, y + dy, (ImageObserver)obs)) {
                            obs.waitFor();
                        }
                        dy += imgs[k].getHeight();
                    }
                }
                if (!item2.isHBonding()) {
                    g2.drawLine(x - hpad - 1, y - vpad - 1, x - hpad - 1, y + h2 + vpad);
                }
                if (!item2.isVBonding()) {
                    g2.drawLine(x - hpad - 1, y - vpad - 1, x + w2 + hpad, y - vpad - 1);
                }
                x += w2 + 1 + hpad * 2;
            }
            y += h2 + 1 + vpad * 2;
        }
        g2.drawRect(hpad, vpad, imageWidth - hpad * 2, imageHeight - vpad * 2);
        g2.dispose();
        for (i = 0; i < size; ++i) {
            WdicTableRow row4 = rowList.get(i);
            for (int j3 = 0; j3 < cols; ++j3) {
                row4.get(j3).destroy();
            }
        }
    }

    private List<WdicTableRow> _parse() {
        List<Object> rowList = null;
        if (!this._list.isEmpty()) {
            try {
                String str = this._list.get(0);
                rowList = str.startsWith("| ") ? this._parseFullSpec() : this._parseSimple();
            }
            catch (Exception e) {
                String sep = System.getProperty("line.separator", "\n");
                StringBuilder buf = new StringBuilder();
                int len = this._list.size();
                for (int i = 0; i < len; ++i) {
                    buf.append(this._list.get(i));
                    buf.append(sep);
                }
                this._logger.warn("unexpected table format: " + this._id + sep + buf.toString(), (Throwable)e);
            }
        }
        if (rowList == null) {
            rowList = new ArrayList();
        }
        return rowList;
    }

    private List<WdicTableRow> _parseFullSpec() {
        ArrayList<WdicTableRow> rowList = new ArrayList<WdicTableRow>();
        int len = this._list.size();
        int col = -1;
        int hnum = -1;
        int vnum = -1;
        WdicTableRow row = null;
        for (int i = 1; i < len; ++i) {
            int idx;
            String line = this._list.get(i).trim();
            if ("|>".equals(line)) {
                row = new WdicTableRow();
                rowList.add(row);
                continue;
            }
            if (vnum > 0 && row.size() == col) {
                --vnum;
                for (int j = 0; j < hnum; ++j) {
                    WdicTableItem item = new WdicTableItem(this._item, false, null);
                    item.setHBonding(true);
                    if (vnum > 0) {
                        item.setVBonding(true);
                    }
                    row.add(item);
                }
            }
            if ((idx = WdicUtil.indexOf(line, "|", 1)) == 2) {
                row.add(new WdicTableItem(this._item, false, line.substring(2)));
                continue;
            }
            String str = line.substring(1, idx);
            row.add(new WdicTableItem(this._item, false, line.substring(idx + 1)));
            idx = WdicUtil.indexOf(str, ".", 1);
            hnum = Integer.parseInt(str.substring(0, idx)) - 1;
            vnum = Integer.parseInt(str.substring(idx + 1)) - 1;
            for (int j = 0; j < hnum; ++j) {
                WdicTableItem item = new WdicTableItem(this._item, false, null);
                item.setHBonding(true);
                if (vnum > 0) {
                    item.setVBonding(true);
                }
                row.add(item);
            }
            col = row.size();
        }
        return rowList;
    }

    private List<WdicTableRow> _parseSimple() {
        ArrayList<WdicTableRow> rowList = new ArrayList<WdicTableRow>();
        int len = this._list.size();
        for (int i = 0; i < len; ++i) {
            WdicTableItem item;
            int j;
            int n2;
            String str;
            WdicTableRow row = new WdicTableRow();
            rowList.add(row);
            String line = this._list.get(i).trim();
            boolean header = false;
            if (line.startsWith("|= ")) {
                header = true;
            }
            int idx1 = 3;
            int idx2 = WdicUtil.indexOf(line, "|", idx1);
            while (idx2 != -1) {
                str = line.substring(idx1, idx2);
                row.add(new WdicTableItem(this._item, header, str));
                idx1 = idx2 + 1;
                idx2 = WdicUtil.indexOf(line, "|", idx1);
            }
            str = line.substring(idx1);
            row.add(new WdicTableItem(this._item, header, str));
            int n = rowList.size();
            if (n < 2) continue;
            WdicTableRow prevRow = (WdicTableRow)rowList.get(n - 2);
            int n1 = prevRow.size();
            if (n1 != (n2 = row.size())) {
                for (j = 0; j < n2; ++j) {
                    int k;
                    item = row.get(j);
                    if (!item.isVBonding()) continue;
                    int cnt = 0;
                    for (k = j + 1; k < n1 && prevRow.get(k).isHBonding(); ++k) {
                        ++cnt;
                    }
                    for (k = 0; k < cnt; ++k) {
                        WdicTableItem padItem = new WdicTableItem(this._item, item.isHeader());
                        padItem.setVBonding(true);
                        padItem.setHBonding(true);
                        row.add(j + 1, padItem);
                    }
                    n2 += cnt;
                    j += cnt;
                }
            }
            for (j = 1; j < n1; ++j) {
                item = row.get(j);
                if (!item.isHBonding() || !row.get(j - 1).isVBonding()) continue;
                item.setVBonding(true);
            }
            for (j = 0; j < n1; ++j) {
                WdicTableItem item1 = prevRow.get(j);
                WdicTableItem item2 = row.get(j);
                if (!item2.isVBonding() || !item1.isHBonding()) continue;
                item2.setHBonding(true);
            }
        }
        return rowList;
    }
}

