/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BlockOutputStream
extends FilterOutputStream {
    private long _size = 0L;

    public BlockOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void close() throws IOException {
        try {
            int pad = (int)(this._size % 2048L);
            if (pad > 0) {
                pad = 2048 - pad;
                byte[] b = new byte[pad];
                Arrays.fill(b, (byte)0);
                this.out.write(b, 0, b.length);
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this._size += (long)len;
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] val = new byte[]{(byte)(b & 0xFF)};
        this.write(val, 0, val.length);
    }

    public long getSize() {
        return this._size;
    }
}

