/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import fuku.eb4j.util.HexUtil;
import fuku.xml2eb.BlockOutputStream;
import fuku.xml2eb.Position;
import fuku.xml2eb.Reference;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Linker {
    private static final int BODY = 0;
    private static final int MENU = 1;
    private static final int COPYRIGHT = 2;
    private static final int HEAD = 3;
    private static final int WORD = 4;
    private static final int ENDWORD = 5;
    private static final int KEYWORD = 6;
    private static final int GRAPHIC = 7;
    private static final int SOUND = 8;
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private File _outfile = null;
    private File[] _infile = null;
    private long[] _startBlock = null;
    private Reference _ref = null;
    private Map<File, RandomAccessFile> _fileMap = null;

    public Linker(File file) {
        this._outfile = file;
        this._infile = new File[9];
        this._startBlock = new long[9];
        this._fileMap = new HashMap<File, RandomAccessFile>();
    }

    public void setHeadFile(File file) {
        this._infile[3] = file;
    }

    public void setBodyFile(File file) {
        this._infile[0] = file;
    }

    public void setCopyrightFile(File file) {
        this._infile[2] = file;
    }

    public void setMenuFile(File file) {
        this._infile[1] = file;
    }

    public void setWordFile(File file) {
        this._infile[4] = file;
    }

    public void setEndwordFile(File file) {
        this._infile[5] = file;
    }

    public void setKeywordFile(File file) {
        this._infile[6] = file;
    }

    public void setGraphicFile(File file) {
        this._infile[7] = file;
    }

    public void setSoundFile(File file) {
        this._infile[8] = file;
    }

    public void setReference(Reference ref) {
        this._ref = ref;
    }

    private long _getPosition(Position pos) {
        File file = pos.getFile();
        int len = this._infile.length;
        for (int i = 0; i < len; ++i) {
            if (!file.equals(this._infile[i])) continue;
            return pos.getPosition(this._startBlock[i]);
        }
        this._logger.warn("unknown file position: " + pos);
        return pos.getPosition();
    }

    private boolean _isIndex(File file) {
        String name = file.getName();
        int len = this._infile.length;
        for (int i = 0; i < len; ++i) {
            if (this._infile[i] == null) continue;
            if (file.equals(this._infile[i])) {
                return false;
            }
            String base = this._infile[i].getName();
            if (!name.startsWith(base)) continue;
            return true;
        }
        return false;
    }

    private File[] _getFileList(File file) {
        ArrayList<File> list = new ArrayList<File>();
        String name = file.getName();
        File dir = file.getParentFile();
        if (dir == null) {
            dir = new File(".");
        }
        File[] files = dir.listFiles();
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (!files[i].getName().startsWith(name)) continue;
            list.add(files[i]);
        }
        return list.toArray(new File[list.size()]);
    }

    public void delete() {
        int len = this._infile.length;
        for (int i = 0; i < len; ++i) {
            if (this._infile[i] == null) continue;
            if (this._infile[i].exists()) {
                this._logger.info("delete file" + this._infile[i].getPath());
                if (this._infile[i].delete()) continue;
                this._logger.error("failed to delete file: " + this._infile[i].getPath());
                continue;
            }
            File[] files = this._getFileList(this._infile[i]);
            int n = files.length;
            for (int j = 0; j < n; ++j) {
                this._logger.info("delete file" + files[j].getPath());
                if (files[j].delete()) continue;
                this._logger.error("failed to delete file: " + files[j].getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link() {
        long size;
        byte[] control = new byte[2048];
        Arrays.fill(control, (byte)0);
        int off = 16;
        int cnt = 0;
        long block = 2L;
        if (this._infile[0] != null) {
            this._logger.debug("body start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[0] = block;
            size = this._setControlEntry(control, off, this._infile[0], 0, block, 0x2000000L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[1] != null) {
            this._logger.debug("menu start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[1] = block;
            size = this._setControlEntry(control, off, this._infile[1], 1, block, 0x2000000L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[2] != null) {
            this._logger.debug("copyright start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[2] = block;
            size = this._setControlEntry(control, off, this._infile[2], 2, block, 0x2000000L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[3] != null) {
            this._logger.debug("head start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[3] = block;
            size = this._setControlEntry(control, off, this._infile[3], 5, block, 0x2000000L);
            ++cnt;
            size = this._setControlEntry(control, off += 16, this._infile[3], 7, block, 0x2000000L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[4] != null) {
            this._logger.debug("word start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[4] = block;
            size = this._setControlEntry(control, off, this._getFileList(this._infile[4]), 145, block, 37836116L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[5] != null) {
            this._logger.debug("endword start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[5] = block;
            size = this._setControlEntry(control, off, this._getFileList(this._infile[5]), 113, block, 37836116L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[6] != null) {
            this._logger.debug("keyword start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[6] = block;
            size = this._setControlEntry(control, off, this._getFileList(this._infile[6]), 128, block, 37836116L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[7] != null) {
            this._logger.debug("graphic start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[7] = block;
            size = this._setControlEntry(control, off, this._infile[7], 210, block, 0L);
            off += 16;
            ++cnt;
            block += size;
        }
        if (this._infile[8] != null) {
            this._logger.debug("sound start block: 0x" + HexUtil.toHexString((long)block));
            this._startBlock[8] = block;
            size = this._setControlEntry(control, off, this._infile[8], 216, block, 0L);
            off += 16;
            ++cnt;
            block += size;
        }
        control[0] = (byte)(cnt >>> 8 & 0xFF);
        control[1] = (byte)(cnt & 0xFF);
        this._fixBodyReference();
        this._fixHeadReference();
        this._fixIndexReference();
        this._fixGraphicReference();
        this._fixSoundReference();
        for (RandomAccessFile stream : this._fileMap.values()) {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
        this._fileMap.clear();
        this._logger.info("link file: " + this._outfile.getPath());
        BlockOutputStream out = null;
        try {
            out = new BlockOutputStream(new BufferedOutputStream(new FileOutputStream(this._outfile)));
            out.write(control, 0, control.length);
            out.flush();
            int len = this._infile.length;
            for (int i = 0; i < len; ++i) {
                if (this._infile[i] == null) continue;
                this._link(out, this._infile[i]);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    private long _setControlEntry(byte[] b, int off, File file, int id, long start, long param) {
        File[] files = new File[]{file};
        return this._setControlEntry(b, off, files, id, start, param);
    }

    private long _setControlEntry(byte[] b, int off, File[] file, int id, long start, long param) {
        long size = 0L;
        int n = file.length;
        for (int i = 0; i < n; ++i) {
            long len = file[i].length();
            size += (len + 2047L) / 2048L;
        }
        b[off++] = (byte)id;
        b[off++] = 0;
        b[off++] = (byte)(start >>> 24 & 0xFFL);
        b[off++] = (byte)(start >>> 16 & 0xFFL);
        b[off++] = (byte)(start >>> 8 & 0xFFL);
        b[off++] = (byte)(start & 0xFFL);
        b[off++] = (byte)(size >>> 24 & 0xFFL);
        b[off++] = (byte)(size >>> 16 & 0xFFL);
        b[off++] = (byte)(size >>> 8 & 0xFFL);
        b[off++] = (byte)(param & 0xFFL);
        b[off++] = (byte)(param >>> 24 & 0xFFL);
        b[off++] = (byte)(param >>> 16 & 0xFFL);
        b[off++] = (byte)(param >>> 8 & 0xFFL);
        b[off++] = (byte)(param & 0xFFL);
        return size;
    }

    private void _fixBodyReference() {
        Map<Position, String> map = this._ref.getBodyRef();
        this._logger.info("resolve body reference: " + map.size());
        for (Map.Entry<Position, String> entry : map.entrySet()) {
            Position pos = entry.getKey();
            String tag = entry.getValue();
            if (this._ref.hasBodyTag(tag)) {
                Position tpos = this._ref.getBodyTag(tag);
                this._fixPosition(pos, this._getPosition(tpos));
                continue;
            }
            this._logger.error("undefined body tag: " + tag);
        }
    }

    private void _fixHeadReference() {
        Map<Position, String> map = this._ref.getHeadRef();
        this._logger.info("resolve head reference: " + map.size());
        for (Map.Entry<Position, String> entry : map.entrySet()) {
            Position pos = entry.getKey();
            String tag = entry.getValue();
            if (this._ref.hasHeadTag(tag)) {
                Position tpos = this._ref.getHeadTag(tag);
                this._fixPosition(pos, this._getPosition(tpos));
                continue;
            }
            this._logger.error("undefined head tag: " + tag);
        }
    }

    private void _fixIndexReference() {
        Map<Position, String> map = this._ref.getIndexRef();
        this._logger.info("resolve index reference: " + map.size());
        for (Map.Entry<Position, String> entry : map.entrySet()) {
            Position pos = entry.getKey();
            String tag = entry.getValue();
            this._fixPosition(pos, tag);
        }
    }

    private void _fixGraphicReference() {
        Map<Position, String> map = this._ref.getGraphicRef();
        this._logger.info("resolve graphic reference: " + map.size());
        for (Map.Entry<Position, String> entry : map.entrySet()) {
            Position pos = entry.getKey();
            String tag = entry.getValue();
            if (this._ref.hasGraphicTag(tag)) {
                Position tpos = this._ref.getGraphicTag(tag);
                this._fixPosition(pos, this._getPosition(tpos));
                continue;
            }
            this._logger.error("undefined graphic tag: " + tag);
        }
    }

    private void _fixSoundReference() {
        Map<Position, String> map = this._ref.getSoundRef();
        this._logger.info("resolve sound reference:" + map.size());
        for (Map.Entry<Position, String> entry : map.entrySet()) {
            Position pos = entry.getKey();
            String tag = entry.getValue();
            if (this._ref.hasSoundTag(tag)) {
                Position[] tpos = this._ref.getSoundTag(tag);
                this._fixPosition(pos, this._getPosition(tpos[0]), this._getPosition(tpos[1]));
                continue;
            }
            this._logger.error("undefined sound tag: " + tag);
        }
    }

    private void _fixPosition(Position pos, long target) {
        File file = pos.getFile();
        byte[] b = new byte[6];
        long block = target / 2048L + 1L;
        int off = (int)(target % 2048L);
        if (!this._isIndex(file)) {
            block = this._toBCD4(block);
            off = this._toBCD2(off);
        }
        b[0] = (byte)(block >>> 24 & 0xFFL);
        b[1] = (byte)(block >>> 16 & 0xFFL);
        b[2] = (byte)(block >>> 8 & 0xFFL);
        b[3] = (byte)(block & 0xFFL);
        b[4] = (byte)(off >>> 8 & 0xFF);
        b[5] = (byte)(off & 0xFF);
        try {
            RandomAccessFile stream = this._fileMap.get(file);
            if (stream == null) {
                stream = new RandomAccessFile(file, "rw");
                this._fileMap.put(file, stream);
            }
            stream.seek(pos.getPosition());
            stream.write(b, 0, b.length);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void _fixPosition(Position pos, long start, long end) {
        byte[] b = new byte[12];
        long block = start / 2048L + 1L;
        int off = (int)(start % 2048L);
        block = this._toBCD4(block);
        off = this._toBCD2(off);
        b[0] = (byte)(block >>> 24 & 0xFFL);
        b[1] = (byte)(block >>> 16 & 0xFFL);
        b[2] = (byte)(block >>> 8 & 0xFFL);
        b[3] = (byte)(block & 0xFFL);
        b[4] = (byte)(off >>> 8 & 0xFF);
        b[5] = (byte)(off & 0xFF);
        block = end / 2048L + 1L;
        off = (int)(end % 2048L);
        block = this._toBCD4(block);
        off = this._toBCD2(off);
        b[6] = (byte)(block >>> 24 & 0xFFL);
        b[7] = (byte)(block >>> 16 & 0xFFL);
        b[8] = (byte)(block >>> 8 & 0xFFL);
        b[9] = (byte)(block & 0xFFL);
        b[10] = (byte)(off >>> 8 & 0xFF);
        b[11] = (byte)(off & 0xFF);
        try {
            File file = pos.getFile();
            RandomAccessFile stream = this._fileMap.get(file);
            if (stream == null) {
                stream = new RandomAccessFile(file, "rw");
                this._fileMap.put(file, stream);
            }
            stream.seek(pos.getPosition());
            stream.write(b, 0, b.length);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void _fixPosition(Position pos, String tag) {
        File file = pos.getFile();
        File dir = file.getParentFile();
        if (dir == null) {
            dir = new File(".");
        }
        String name = file.getName();
        String base = null;
        int level = 0;
        long block = 0L;
        try {
            int idx = name.lastIndexOf(".");
            level = Integer.parseInt(name.substring(idx + 1));
            base = name.substring(0, idx);
            block = Integer.parseInt(tag);
        }
        catch (NumberFormatException e) {
            this._logger.warn(e.getMessage(), (Throwable)e);
        }
        if (level <= 0) {
            this._logger.error("unknown index file: " + name);
            return;
        }
        if (block <= 0L) {
            this._logger.error("unknown index tag: " + tag);
            return;
        }
        long size = 0L;
        Object[] indexFile = this._getFileList(new File(dir, base));
        Arrays.sort(indexFile);
        int len = indexFile.length;
        for (int i = len - 1; i >= 0; --i) {
            try {
                String str = ((File)indexFile[i]).getName();
                int idx = str.lastIndexOf(".");
                int no = Integer.parseInt(str.substring(idx + 1));
                if (no < level) break;
                size += ((File)indexFile[i]).length();
                continue;
            }
            catch (NumberFormatException e) {
                this._logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        block += size / 2048L;
        if (this._infile[4] != null && base.equals(this._infile[4].getName())) {
            block += this._startBlock[4];
        } else if (this._infile[5] != null && base.equals(this._infile[5].getName())) {
            block += this._startBlock[5];
        } else if (this._infile[6] != null && base.equals(this._infile[6].getName())) {
            block += this._startBlock[6];
        } else {
            this._logger.error("unknown index file: " + name);
            return;
        }
        this._logger.debug(pos + ": 0x" + HexUtil.toHexString((long)(--block)) + " tag=" + tag);
        byte[] b = new byte[]{(byte)(block >>> 24 & 0xFFL), (byte)(block >>> 16 & 0xFFL), (byte)(block >>> 8 & 0xFFL), (byte)(block & 0xFFL)};
        try {
            RandomAccessFile stream = this._fileMap.get(file);
            if (stream == null) {
                stream = new RandomAccessFile(file, "rw");
                this._fileMap.put(file, stream);
            }
            stream.seek(pos.getPosition());
            stream.write(b, 0, b.length);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _link(OutputStream out, File file) {
        if (!file.exists()) {
            Object[] files = this._getFileList(file);
            Arrays.sort(files);
            int len = files.length;
            for (int i = len - 1; i >= 0; --i) {
                this._link(out, (File)files[i]);
            }
            return;
        }
        this._logger.info("link file: " + file.getPath());
        byte[] b = new byte[2048];
        BufferedInputStream bis = null;
        try {
            int n;
            bis = new BufferedInputStream(new FileInputStream(file));
            while ((n = bis.read(b, 0, b.length)) >= 0) {
                out.write(b, 0, n);
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bis);
        }
        IOUtils.closeQuietly((InputStream)bis);
    }

    private long _toBCD4(long val) {
        long bcd = 0L;
        bcd += val % 10L;
        bcd += val / 10L % 10L << 4;
        bcd += val / 100L % 10L << 8;
        bcd += val / 1000L % 10L << 12;
        bcd += val / 10000L % 10L << 16;
        bcd += val / 100000L % 10L << 20;
        bcd += val / 1000000L % 10L << 24;
        return bcd += val / 10000000L % 10L << 28;
    }

    private int _toBCD2(int val) {
        int bcd = 0;
        bcd += val % 10;
        bcd += val / 10 % 10 << 4;
        bcd += val / 100 % 10 << 8;
        return bcd += val / 1000 % 10 << 12;
    }
}

