/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb;

import fuku.eb4j.util.ByteUtil;
import fuku.xml2eb.BlockOutputStream;
import fuku.xml2eb.CatalogInfo;
import fuku.xml2eb.IndexWriter;
import fuku.xml2eb.Linker;
import fuku.xml2eb.LoggingErrorHandler;
import fuku.xml2eb.Reference;
import fuku.xml2eb.TextOutputStream;
import fuku.xml2eb.WordSet;
import fuku.xml2eb.Xbm;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Xml2Eb {
    private static final String _PROGRAM = Xml2Eb.class.getName();
    private static final String HONMON_FILE = "honmon";
    private static final String DATA_DIR = "data";
    private static final String EXT_FONT_DIR = "gaiji";
    private static final String COPYRIGHT_FILE = "copyright.tmp";
    private static final String MENU_FILE = "menu.tmp";
    private static final String BODY_FILE = "body.tmp";
    private static final String HEAD_FILE = "head.tmp";
    private static final String WORD_FILE = "word.tmp";
    private static final String ENDWORD_FILE = "endword.tmp";
    private static final String KEYWORD_FILE = "keyword.tmp";
    private static final String GRAPHIC_FILE = "graphic.tmp";
    private static final String SOUND_FILE = "sound.tmp";
    private static final int MAX_FONT = 8836;
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private File _basedir = null;
    private File _xmlfile = null;
    private File _outdir = null;
    private Document _doc = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("java " + _PROGRAM + " [xml-file]");
        } else {
            new Xml2Eb(args[0]).convert();
        }
    }

    public Xml2Eb(String path) {
        this(new File(path));
    }

    public Xml2Eb(File file) {
        this._xmlfile = file;
        this._basedir = file.getParentFile();
        if (this._basedir == null) {
            this._basedir = new File(".");
        }
        this._outdir = new File(this._basedir, "build");
    }

    public void setOutDir(File dir) {
        this._outdir = dir;
    }

    public void convert() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new LoggingErrorHandler());
        this._logger.info("load file: " + this._xmlfile.getPath());
        this._doc = builder.parse(this._xmlfile);
        Node root = this._doc.getFirstChild();
        if (root.getNodeType() != 1) {
            this._logger.error("root element node not found");
            return;
        }
        if (!"book".equals(root.getNodeName())) {
            this._logger.error("book element node not found");
            return;
        }
        Element book = (Element)root;
        NodeList nlist = book.getElementsByTagName("subbook");
        int len = nlist.getLength();
        CatalogInfo[] info = new CatalogInfo[len];
        for (int i = 0; i < len; ++i) {
            Element subbook = (Element)nlist.item(i);
            info[i] = this._convert(subbook);
        }
        File file = new File(this._outdir, "catalogs");
        this._writeCatalogs(file, info);
    }

    private CatalogInfo _convert(Element subbook) {
        NodeList contentList;
        Element soundElem;
        NodeList dataList;
        int n;
        NodeList soundList;
        Element graphicElem;
        NodeList dataList2;
        int n2;
        String type = subbook.getAttribute("type");
        String title = subbook.getAttribute("title");
        String dir = subbook.getAttribute("dir");
        String prefix = dir + "-";
        File dicdir = new File(this._outdir, dir);
        File datadir = new File(dicdir, DATA_DIR);
        File fontdir = new File(dicdir, EXT_FONT_DIR);
        if (!datadir.exists() && !datadir.mkdirs()) {
            this._logger.error("failed to create directories: " + datadir.getPath());
        }
        if (!fontdir.exists() && !fontdir.mkdirs()) {
            this._logger.error("failed to create directories: " + fontdir.getPath());
        }
        Reference ref = new Reference();
        CatalogInfo info = new CatalogInfo();
        try {
            info.setType(Integer.decode(type));
        }
        catch (NumberFormatException e) {
            this._logger.warn("unknown subbook type: " + type);
        }
        info.setTitle(title);
        info.setDirectory(dir);
        NodeList fontList = subbook.getElementsByTagName("font");
        if (fontList.getLength() >= 1) {
            File file;
            String name;
            HashMap<Integer, ArrayList<String>> hmap = new HashMap<Integer, ArrayList<String>>();
            HashMap fmap = new HashMap();
            int hcode = 41249;
            int fcode = 41249;
            Element fontElem = (Element)fontList.item(0);
            NodeList charList = fontElem.getElementsByTagName("char");
            int len = charList.getLength();
            for (int i = 0; i < len; ++i) {
                Element charElem = (Element)charList.item(i);
                String name2 = charElem.getAttribute("name");
                String wtype = charElem.getAttribute("type");
                HashMap<Integer, ArrayList<String>> map = null;
                if (ref.hasNarrowChar(name2) || ref.hasWideChar(name2)) {
                    this._logger.warn("character name has already been defined: " + name2);
                    continue;
                }
                if ("narrow".equals(wtype)) {
                    ref.putNarrowChar(name2, hcode);
                    if ((++hcode & 0xFF) > 126) {
                        hcode = (hcode & 0xFF00) + 289;
                    }
                    map = hmap;
                } else if ("wide".equals(wtype)) {
                    ref.putWideChar(name2, fcode);
                    if ((++fcode & 0xFF) > 126) {
                        fcode = (fcode & 0xFF00) + 289;
                    }
                    map = fmap;
                } else {
                    this._logger.warn("unknown font type: " + wtype);
                    continue;
                }
                NodeList dataList3 = charElem.getElementsByTagName(DATA_DIR);
                int n3 = dataList3.getLength();
                for (int j = 0; j < n3; ++j) {
                    Element dataElem = (Element)dataList3.item(j);
                    String size = dataElem.getAttribute("size");
                    String src = dataElem.getAttribute("src");
                    int key = 0;
                    try {
                        key = Integer.parseInt(size);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (key != 16 && key != 24 && key != 30 && key != 48) {
                        this._logger.warn("unknown font size: " + size);
                        continue;
                    }
                    ArrayList<String> list = (ArrayList<String>)map.get(key);
                    if (list == null) {
                        list = new ArrayList<String>();
                        map.put(key, list);
                    }
                    list.add(src);
                }
            }
            for (Map.Entry entry : hmap.entrySet()) {
                int size = (Integer)entry.getKey();
                name = null;
                int width = 0;
                switch (size) {
                    case 16: {
                        name = "gai16h";
                        width = 8;
                        info.setExtFont(4, name);
                        break;
                    }
                    case 24: {
                        name = "gai24h";
                        width = 16;
                        info.setExtFont(5, name);
                        break;
                    }
                    case 30: {
                        name = "gai30h";
                        width = 16;
                        info.setExtFont(6, name);
                        break;
                    }
                    case 48: {
                        name = "gai48h";
                        width = 24;
                        info.setExtFont(7, name);
                        break;
                    }
                }
                file = new File(fontdir, name);
                List list = (List)entry.getValue();
                String[] src = list.toArray(new String[list.size()]);
                this._writeExtFont(file, src, width, size);
            }
            for (Map.Entry entry : fmap.entrySet()) {
                int size = (Integer)entry.getKey();
                name = null;
                int width = 0;
                switch (size) {
                    case 16: {
                        name = "gai16f";
                        width = 16;
                        info.setExtFont(0, name);
                        break;
                    }
                    case 24: {
                        name = "gai24f";
                        width = 24;
                        info.setExtFont(1, name);
                        break;
                    }
                    case 30: {
                        name = "gai30f";
                        width = 32;
                        info.setExtFont(2, name);
                        break;
                    }
                    case 48: {
                        name = "gai48f";
                        width = 48;
                        info.setExtFont(3, name);
                        break;
                    }
                }
                file = new File(fontdir, name);
                List list = (List)entry.getValue();
                String[] src = list.toArray(new String[list.size()]);
                this._writeExtFont(file, src, width, size);
            }
        }
        File honmonFile = new File(datadir, HONMON_FILE);
        Linker linker = new Linker(honmonFile);
        NodeList graphicList = subbook.getElementsByTagName("graphic");
        if (graphicList.getLength() >= 1 && (n2 = (dataList2 = (graphicElem = (Element)graphicList.item(0)).getElementsByTagName(DATA_DIR)).getLength()) > 0) {
            String[] src = new String[n2];
            String[] name = new String[n2];
            String[] format = new String[n2];
            for (int j = 0; j < n2; ++j) {
                Element dataElem = (Element)dataList2.item(j);
                src[j] = dataElem.getAttribute("src");
                name[j] = dataElem.getAttribute("name");
                format[j] = dataElem.getAttribute("format");
            }
            File file = new File(this._basedir, prefix + GRAPHIC_FILE);
            this._writeGraphic(file, src, name, format, ref);
            linker.setGraphicFile(file);
        }
        if ((soundList = subbook.getElementsByTagName("sound")).getLength() >= 1 && (n = (dataList = (soundElem = (Element)soundList.item(0)).getElementsByTagName(DATA_DIR)).getLength()) > 0) {
            String[] src = new String[n];
            String[] name = new String[n];
            String[] format = new String[n];
            for (int j = 0; j < n; ++j) {
                Element dataElem = (Element)dataList.item(j);
                src[j] = dataElem.getAttribute("src");
                name[j] = dataElem.getAttribute("name");
                format[j] = dataElem.getAttribute("format");
            }
            File file = new File(this._basedir, prefix + SOUND_FILE);
            this._writeSound(file, src, name, format, ref);
            linker.setSoundFile(file);
        }
        if ((contentList = subbook.getElementsByTagName("content")).getLength() >= 1) {
            File keywordFile;
            File endwordFile;
            NodeList menuList;
            Element contentElem = (Element)contentList.item(0);
            NodeList copyList = contentElem.getElementsByTagName("copyright");
            if (copyList.getLength() >= 1) {
                Element copyElem = (Element)copyList.item(0);
                File copyFile = new File(this._basedir, prefix + COPYRIGHT_FILE);
                this._writeCopyright(copyFile, copyElem, ref);
                linker.setCopyrightFile(copyFile);
            }
            if ((menuList = contentElem.getElementsByTagName("menu")).getLength() >= 1) {
                Element menuElem = (Element)menuList.item(0);
                File menuFile = new File(this._basedir, prefix + MENU_FILE);
                this._writeMenu(menuFile, menuElem, ref);
                linker.setMenuFile(menuFile);
            }
            NodeList itemList = contentElem.getElementsByTagName("item");
            File headFile = new File(this._basedir, prefix + HEAD_FILE);
            this._writeHead(headFile, itemList, ref);
            linker.setHeadFile(headFile);
            File bodyFile = new File(this._basedir, prefix + BODY_FILE);
            this._writeBody(bodyFile, itemList, ref);
            linker.setBodyFile(bodyFile);
            File wordFile = new File(this._basedir, prefix + WORD_FILE);
            if (this._writeWordIndex(wordFile, itemList, 0, ref)) {
                linker.setWordFile(wordFile);
            }
            if (this._writeWordIndex(endwordFile = new File(this._basedir, prefix + ENDWORD_FILE), itemList, 1, ref)) {
                linker.setEndwordFile(endwordFile);
            }
            if (this._writeKeywordIndex(keywordFile = new File(this._basedir, prefix + KEYWORD_FILE), itemList, 0, ref)) {
                linker.setKeywordFile(keywordFile);
            }
        }
        linker.setReference(ref);
        linker.link();
        linker.delete();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeCopyright(File file, Node node, Reference ref) {
        this._logger.info("write file: " + file.getPath());
        TextOutputStream stream = null;
        try {
            stream = new TextOutputStream(file, new BufferedOutputStream(new FileOutputStream(file)));
            stream.setReference(ref);
            stream.beginContext();
            this._writeNode(stream, node, 1, ref);
            stream.endContext();
            IOUtils.closeQuietly((OutputStream)stream);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeMenu(File file, Element menu, Reference ref) {
        NodeList layerList = menu.getElementsByTagName("layer");
        this._logger.info("write file: " + file.getPath());
        TextOutputStream stream = null;
        try {
            stream = new TextOutputStream(file, new BufferedOutputStream(new FileOutputStream(file)));
            stream.setReference(ref);
            int len = layerList.getLength();
            this._logger.info("layer count: " + len);
            for (int i = 0; i < len; ++i) {
                Element layerElem = (Element)layerList.item(i);
                String id = layerElem.getAttribute("id");
                ref.putBodyTag(id, file, stream.getSize());
                this._logger.trace("layer: '" + id + "'");
                stream.beginContext();
                stream.setIndent(1);
                this._writeNode(stream, layerElem, 2, ref);
                stream.endContext();
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeHead(File file, NodeList itemList, Reference ref) {
        this._logger.info("write file: " + file.getPath());
        TextOutputStream stream = null;
        try {
            stream = new TextOutputStream(file, new BufferedOutputStream(new FileOutputStream(file)));
            stream.setReference(ref);
            stream.beginContext();
            int len = itemList.getLength();
            this._logger.info("item count: " + len);
            for (int i = 0; i < len; ++i) {
                Element itemElem = (Element)itemList.item(i);
                String id = itemElem.getAttribute("id");
                ref.putHeadTag(id, file, stream.getSize());
                this._logger.trace("head: '" + id + "'");
                NodeList headList = itemElem.getElementsByTagName("head");
                int n = headList.getLength();
                for (int j = 0; j < n; ++j) {
                    Element headElem = (Element)headList.item(j);
                    this._writeNode(stream, headElem, 1, ref);
                    stream.newLine();
                }
            }
            stream.endContext();
            IOUtils.closeQuietly((OutputStream)stream);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeBody(File file, NodeList itemList, Reference ref) {
        this._logger.info("write file: " + file.getPath());
        TextOutputStream stream = null;
        try {
            stream = new TextOutputStream(file, new BufferedOutputStream(new FileOutputStream(file)));
            stream.setReference(ref);
            stream.beginContext();
            int len = itemList.getLength();
            this._logger.info("item count: " + len);
            for (int i = 0; i < len; ++i) {
                Element itemElem = (Element)itemList.item(i);
                String id = itemElem.getAttribute("id");
                ref.putBodyTag(id, file, stream.getSize());
                this._logger.trace("body: '" + id + "'");
                NodeList bodyList = itemElem.getElementsByTagName("body");
                int n = bodyList.getLength();
                for (int j = 0; j < n; ++j) {
                    Element bodyElem = (Element)bodyList.item(j);
                    stream.setIndent(1);
                    this._writeNode(stream, bodyElem, 2, ref);
                }
            }
            stream.endContext();
            IOUtils.closeQuietly((OutputStream)stream);
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _writeWordIndex(File file, NodeList itemList, int direction, Reference ref) {
        this._logger.info("write file: " + file.getPath());
        IndexWriter iw = null;
        boolean avail = false;
        try {
            WordSet wordSet = new WordSet(direction);
            int len = itemList.getLength();
            for (int i = 0; i < len; ++i) {
                Element itemElem = (Element)itemList.item(i);
                String id = itemElem.getAttribute("id");
                NodeList wordList = itemElem.getElementsByTagName("word");
                int n = wordList.getLength();
                for (int j = 0; j < n; ++j) {
                    Element wordElem = (Element)wordList.item(j);
                    String str = wordElem.getTextContent();
                    this._logger.trace("word: '" + str + "'");
                    wordSet.add(str, id);
                }
            }
            this._logger.info("word count: " + wordSet.size());
            boolean bl = avail = !wordSet.isEmpty();
            if (avail) {
                iw = new IndexWriter(file);
                iw.setReference(ref);
                iw.write(wordSet);
            }
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (iw != null) {
                iw.close();
            }
        }
        return avail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _writeKeywordIndex(File file, NodeList itemList, int direction, Reference ref) {
        this._logger.info("write file: " + file.getPath());
        IndexWriter iw = null;
        boolean avail = false;
        try {
            WordSet wordSet = new WordSet(direction);
            int len = itemList.getLength();
            for (int i = 0; i < len; ++i) {
                Element itemElem = (Element)itemList.item(i);
                String id = itemElem.getAttribute("id");
                NodeList wordList = itemElem.getElementsByTagName("keyword");
                int n = wordList.getLength();
                for (int j = 0; j < n; ++j) {
                    Element wordElem = (Element)wordList.item(j);
                    String str = wordElem.getTextContent();
                    this._logger.trace("keyword: '" + str + "'");
                    wordSet.add(str, id);
                }
            }
            this._logger.info("word count: " + wordSet.size());
            boolean bl = avail = !wordSet.isEmpty();
            if (avail) {
                iw = new IndexWriter(file);
                iw.setReference(ref);
                iw.write(wordSet);
            }
        }
        catch (IOException e) {
            this._logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (iw != null) {
                iw.close();
            }
        }
        return avail;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _writeNode(TextOutputStream stream, Node node, int indent, Reference ref) throws IOException {
        short ntype = node.getNodeType();
        if (ntype == 3) {
            Text text = (Text)node;
            try {
                String str = text.getData();
                if (str.trim().length() <= 0) return;
                stream.append(str);
                return;
            }
            catch (DOMException e) {
                if (e.code != 2) throw new IOException(e);
                int len = text.getLength();
                for (int i = 0; i < len; ++i) {
                    String str = text.substringData(i, i + 1);
                    stream.append(str);
                }
                return;
            }
        } else {
            String data;
            String type;
            if (ntype != 1) return;
            Element e = (Element)node;
            String tag = e.getTagName();
            if ("b".equals(tag)) {
                stream.beginDecoration(3);
            } else if ("i".equals(tag)) {
                stream.beginDecoration(1);
            } else if ("em".equals(tag)) {
                stream.beginEmphasis();
            } else if ("key".equals(tag)) {
                stream.beginKeyword();
            } else if ("sup".equals(tag)) {
                stream.beginSuperscript();
            } else if ("sub".equals(tag)) {
                stream.beginSubscript();
            } else if ("nobr".equals(tag)) {
                stream.beginNoNewLine();
            } else if ("indent".equals(tag)) {
                stream.setIndent(indent);
                ++indent;
            } else if ("br".equals(tag)) {
                stream.newLine();
            } else if ("char".equals(tag)) {
                String name = e.getAttribute("name");
                type = e.getAttribute("type");
                if ("narrow".equals(type)) {
                    stream.appendNarrowChar(name);
                } else {
                    if (!"wide".equals(type)) throw new IOException("unknown font type: " + type);
                    stream.appendWideChar(name);
                }
            } else if ("ref".equals(tag)) {
                if (e.hasAttribute("id")) {
                    stream.beginReference();
                } else if (e.hasAttribute(DATA_DIR)) {
                    String format;
                    data = e.getAttribute(DATA_DIR);
                    type = e.getAttribute("type");
                    if ("inlineGraphic".equals(type)) {
                        if (ref.hasGraphicTag(data)) {
                            format = ref.getGraphicFormat(data);
                            stream.beginInlineColorGraphic(data, format);
                        }
                    } else if ("graphic".equals(type)) {
                        if (ref.hasGraphicTag(data)) {
                            format = ref.getGraphicFormat(data);
                            stream.beginColorGraphic(data, format);
                        }
                    } else if ("sound".equals(type) && ref.hasSoundTag(data)) {
                        format = ref.getSoundFormat(data);
                        stream.beginSound(data, format);
                    }
                }
            }
            if (node.hasChildNodes()) {
                NodeList list = node.getChildNodes();
                int len = list.getLength();
                for (int i = 0; i < len; ++i) {
                    this._writeNode(stream, list.item(i), indent, ref);
                }
            }
            if ("b".equals(tag)) {
                stream.endDecoration();
                return;
            } else if ("i".equals(tag)) {
                stream.endDecoration();
                return;
            } else if ("em".equals(tag)) {
                stream.endEmphasis();
                return;
            } else if ("key".equals(tag)) {
                stream.endKeyword();
                return;
            } else if ("sup".equals(tag)) {
                stream.endSuperscript();
                return;
            } else if ("sub".equals(tag)) {
                stream.endSubscript();
                return;
            } else if ("nobr".equals(tag)) {
                stream.endNoNewLine();
                return;
            } else if ("indent".equals(tag)) {
                stream.setIndent(indent -= 2);
                return;
            } else {
                if (!"ref".equals(tag)) return;
                if (e.hasAttribute("id")) {
                    String id = e.getAttribute("id");
                    stream.endReference(id);
                    return;
                } else {
                    if (!e.hasAttribute(DATA_DIR)) return;
                    data = e.getAttribute(DATA_DIR);
                    String type2 = e.getAttribute("type");
                    if ("inlineGraphic".equals(type2)) {
                        if (!ref.hasGraphicTag(data)) return;
                        stream.endInlineColorGraphic();
                        return;
                    } else if ("graphic".equals(type2)) {
                        if (!ref.hasGraphicTag(data)) return;
                        stream.endColorGraphic();
                        return;
                    } else {
                        if (!"sound".equals(type2) || !ref.hasSoundTag(data)) return;
                        stream.endSound();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeGraphic(File file, String[] src, String[] key, String[] format, Reference ref) {
        this._logger.info("write file: " + file.getPath());
        BlockOutputStream stream = null;
        long pos = 0L;
        try {
            stream = new BlockOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            byte[] header = new byte[8];
            header[0] = 100;
            header[1] = 97;
            header[2] = 116;
            header[3] = 97;
            int len = src.length;
            this._logger.info("graphic file count: " + len);
            for (int i = 0; i < len; ++i) {
                File imgfile = new File(this._basedir, src[i]);
                byte[] buf = null;
                try {
                    buf = FileUtils.readFileToByteArray((File)imgfile);
                }
                catch (IOException e) {
                    buf = new byte[]{};
                    this._logger.warn("failed to load graphic file: " + imgfile.getPath());
                }
                int size = buf.length;
                header[4] = (byte)(size & 0xFF);
                header[5] = (byte)(size >> 8 & 0xFF);
                header[6] = (byte)(size >> 16 & 0xFF);
                header[7] = (byte)(size >> 24 & 0xFF);
                stream.write(header);
                stream.write(buf);
                stream.flush();
                ref.putGraphicTag(key[i], format[i], file, pos);
                pos = stream.getSize();
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeSound(File file, String[] src, String[] key, String[] format, Reference ref) {
        this._logger.info("write file: " + file.getPath());
        BlockOutputStream stream = null;
        long pos1 = 0L;
        long pos2 = 0L;
        try {
            stream = new BlockOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            int len = src.length;
            this._logger.info("sound file count: " + len);
            for (int i = 0; i < len; ++i) {
                File sndfile = new File(this._basedir, src[i]);
                byte[] buf = null;
                try {
                    buf = FileUtils.readFileToByteArray((File)sndfile);
                }
                catch (IOException e) {
                    buf = new byte[]{};
                    this._logger.warn("failed to load sound file: " + sndfile.getPath());
                }
                int size = buf.length;
                int off = 0;
                if ("wav".equals(format[i]) && size > 4 && "RIFF".equals(new String(buf, 0, 4))) {
                    off = 12;
                    size -= off;
                }
                stream.write(buf, off, size);
                stream.flush();
                pos2 = stream.getSize();
                ref.putSoundTag(key[i], format[i], file, pos1, pos2);
                if ("wav".equals(format[i])) {
                    try {
                        AudioFormat audioFormat = AudioSystem.getAudioFileFormat(sndfile).getFormat();
                        ref.putAudioFormat(key[i], audioFormat);
                    }
                    catch (UnsupportedAudioFileException e) {
                        // empty catch block
                    }
                }
                pos1 = pos2;
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeExtFont(File file, String[] src, int width, int height) {
        this._logger.info("write file: " + file.getPath());
        BlockOutputStream stream = null;
        try {
            stream = new BlockOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            int len = src.length;
            if (len > 8836) {
                this._logger.warn("too many fonts defined: " + width + "x" + height + " = " + len + " (max=" + 8836 + ")");
                len = 8836;
            }
            this._logger.info(width + "x" + height + " xbm file count: " + len);
            byte[] buf = new byte[2048];
            Arrays.fill(buf, (byte)0);
            buf[8] = (byte)width;
            buf[9] = (byte)height;
            buf[10] = -95;
            buf[11] = 33;
            buf[12] = (byte)(len >>> 8 & 0xFF);
            buf[13] = (byte)(len & 0xFF);
            stream.write(buf);
            buf = new byte[1024];
            int size = width / 8 * height;
            int cnt = 1024 / size;
            int page = (len + cnt - 1) / cnt;
            for (int i = 0; i < page; ++i) {
                int idx;
                Arrays.fill(buf, (byte)0);
                int off = 0;
                for (int j = 0; j < cnt && (idx = i * cnt + j) < len; ++j) {
                    File xbmfile = new File(this._basedir, src[idx]);
                    try {
                        Xbm xbm = new Xbm(xbmfile);
                        byte[] b = xbm.getBitmap();
                        int n = Math.min(b.length, size);
                        System.arraycopy(b, 0, buf, off, n);
                    }
                    catch (IOException e) {
                        this._logger.warn("failed to load XBM file: " + xbmfile.getPath(), (Throwable)e);
                    }
                    off += size;
                }
                stream.write(buf);
                stream.flush();
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeCatalogs(File file, CatalogInfo[] info) {
        this._logger.info("write file: " + file.getPath());
        BlockOutputStream stream = null;
        try {
            stream = new BlockOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            int len = info.length;
            if (len > 12) {
                this._logger.warn("maximum subbook count is 12: " + len);
                len = 12;
            }
            byte[] buf = new byte[16];
            buf[0] = (byte)(len >>> 8 & 0xFF);
            buf[1] = (byte)(len & 0xFF);
            buf[3] = 1;
            stream.write(buf);
            buf = new byte[164];
            for (int i = 0; i < len; ++i) {
                int idx = 0;
                Arrays.fill(buf, (byte)0);
                buf[idx++] = (byte)(info[i].getType() & 0xFF);
                buf[idx++] = 1;
                byte[] b = ByteUtil.stringToJISX0208((String)info[i].getTitle());
                int n = b.length;
                if (n > 80) {
                    this._logger.warn("[subbook #" + (i + 1) + "] title is too long");
                    n = 80;
                }
                System.arraycopy(b, 0, buf, idx, n);
                idx += 80;
                b = info[i].getDirectory().getBytes("ISO-8859-1");
                n = b.length;
                if (n > 8) {
                    this._logger.warn("[subbook #" + (i + 1) + "] directory name is too long");
                    n = 8;
                }
                System.arraycopy(b, 0, buf, idx, n);
                idx += 8;
                buf[(idx += 4) + 1] = 1;
                idx += 2;
                idx += 4;
                String[] font = info[i].getExtFont();
                int m = font.length;
                for (int j = 0; j < m; ++j) {
                    if (!StringUtils.isBlank((String)font[j])) {
                        b = font[j].getBytes("ISO-8859-1");
                        n = b.length;
                        if (n > 8) {
                            this._logger.warn("[subbook #" + (i + 1) + "] font name is too long");
                            n = 8;
                        }
                        System.arraycopy(b, 0, buf, idx, n);
                    }
                    idx += 8;
                }
                stream.write(buf);
                stream.flush();
            }
        }
        catch (IOException e) {
            try {
                this._logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }
}

