/*
 * Decompiled with CFR 0.152.
 */
package fuku.xml2eb.util;

import fuku.xml2eb.util.WaitImageObserver;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmpUtil {
    private static final Logger _logger = LoggerFactory.getLogger(BmpUtil.class);

    private BmpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(BufferedImage img, File file) throws IOException {
        Iterator<ImageWriter> it;
        if (file.exists() && !file.delete()) {
            _logger.error("failed to delete file: " + file.getPath());
        }
        if (!(it = ImageIO.getImageWritersByFormatName("bmp")).hasNext()) {
            throw new IOException("unsupported BMP format");
        }
        ImageWriter writer = it.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        BufferedImage img2 = BmpUtil._convertImage(img);
        int bits = 0;
        bits = img2 == null ? img.getColorModel().getPixelSize() : img2.getColorModel().getPixelSize();
        if (bits == 8) {
            iwp.setCompressionType("BI_RLE8");
        } else {
            iwp.setCompressionType(null);
        }
        IIOImage image = null;
        image = img2 == null ? new IIOImage(img, null, null) : new IIOImage(img2, null, null);
        FileImageOutputStream fios = null;
        try {
            fios = new FileImageOutputStream(file);
            writer.setOutput(fios);
            writer.write(null, image, iwp);
        }
        finally {
            writer.dispose();
            if (fios != null) {
                try {
                    fios.flush();
                    fios.close();
                }
                catch (IOException e) {}
            }
            if (img2 != null) {
                img2.flush();
            }
        }
    }

    private static BufferedImage _convertImage(BufferedImage img) {
        BufferedImage img2 = null;
        ColorModel cm1 = img.getColorModel();
        int bits = cm1.getPixelSize();
        _logger.debug("image info: " + cm1.getClass().getSimpleName() + ", " + bits + "bits" + ", hasAlpha=" + cm1.hasAlpha());
        Color bg = null;
        if (cm1 instanceof IndexColorModel) {
            if (bits == 8) {
                return null;
            }
            _logger.info("convert image: " + bits + "bits -> 8bits");
            int size = 256;
            byte[] r = new byte[size];
            byte[] g = new byte[size];
            byte[] b = new byte[size];
            IndexColorModel icm1 = (IndexColorModel)cm1;
            icm1.getReds(r);
            icm1.getGreens(g);
            icm1.getBlues(b);
            img2 = new BufferedImage(img.getWidth(), img.getHeight(), 13, new IndexColorModel(8, size, r, g, b));
            int idx = icm1.getTransparentPixel();
            if (idx != -1) {
                bg = new Color(r[idx] & 0xFF, g[idx] & 0xFF, b[idx] & 0xFF);
            }
        } else {
            if (bits == 24) {
                return null;
            }
            _logger.info("convert image: " + bits + "bits -> 24bits");
            img2 = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        }
        Graphics2D g2 = img2.createGraphics();
        WaitImageObserver obs = new WaitImageObserver();
        if (!g2.drawImage(img, 0, 0, bg, obs)) {
            obs.waitFor();
        }
        g2.dispose();
        return img2;
    }
}

