/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp;

import com.xerox.amazonws.ec2.ImageDescription;
import java.util.ArrayList;
import java.util.List;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.image.OpenImageEditorAction;
import jp.open.cloud.studio.rcp.image.UpdateImageJob;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.ViewPart;

public class ImageView
extends ViewPart
implements IPartListener,
IPropertyChangeListener {
    private ProfileModel profile;
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ImageLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ImageContentProvider());
        DragSource source = new DragSource((Control)this.viewer.getTree(), 19);
        source.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(ImageView.this.viewer.getSelection());
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.hookPartListener();
        this.hookDoubleClickAction();
    }

    private void hookPartListener() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        page.addPartListener((IPartListener)this);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ImageView.this.viewer.getSelection();
                ImageDescription image = (ImageDescription)selection.getFirstElement();
                OpenImageEditorAction action = new OpenImageEditorAction(ImageView.this.profile, image);
                action.run();
            }
        });
    }

    public void setFocus() {
    }

    public void partActivated(IWorkbenchPart part) {
        ProfileModel model;
        Object object;
        if (part instanceof EditorPart && (object = part.getAdapter(ProfileModel.class)) instanceof ProfileModel && !(model = (ProfileModel)object).equals(this.profile)) {
            this.profile = model;
            UpdateImageJob job = new UpdateImageJob(model, this);
            job.schedule();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("images".equals(event.getProperty())) {
            final List values = (List)event.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ImageView.this.viewer.setInput((Object)values);
                }
            });
        }
    }

    class ImageContentProvider
    implements ITreeContentProvider {
        ImageContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ArrayList) {
                List descriptions = (List)parentElement;
                return descriptions.toArray(new ImageDescription[descriptions.size()]);
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ArrayList;
        }
    }

    class ImageLabelProvider
    extends LabelProvider {
        ImageLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ImageDescription) {
                return Activator.getImage("image");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ImageDescription) {
                ImageDescription description = (ImageDescription)element;
                return description.getImageId();
            }
            return super.getText(element);
        }
    }
}

