/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.cloud.animation;

import java.util.ArrayList;
import java.util.List;
import jp.open.cloud.studio.rcp.cloud.model.AttachedAddress;
import jp.open.cloud.studio.rcp.cloud.model.CloudCanvas;
import jp.open.cloud.studio.rcp.cloud.model.CloudElement;
import jp.open.cloud.studio.rcp.cloud.model.InstanceElement;
import org.eclipse.swt.widgets.Display;

public class AnimationHelper {
    public void layout(CloudCanvas canvas) {
        List<CloudElement> cloudElements = canvas.getCloudElements();
        int x = 0;
        int y = 0;
        int offset = 15;
        int offsetYY = 35;
        int offsetY = 75;
        for (CloudElement element : cloudElements) {
            if (element.isOverlay()) continue;
            element.setX(offset * (x + 1) + x * element.getDefaultWidth());
            element.setY(offsetY + offsetYY * (y + 1) + y * element.getDefaultHeight());
            element.setWidth(element.getDefaultWidth());
            element.setHeight(element.getDefaultHeight());
            element.animationStart();
            if (element instanceof InstanceElement) {
                AttachedAddress pubAddress;
                InstanceElement instance = (InstanceElement)element;
                AttachedAddress address = instance.getPrivateAddress();
                if (address != null) {
                    address.setX(element.getX());
                    address.setY(element.getY() + element.getDefaultHeight());
                    address.setWidth(address.getDefaultWidth());
                    address.setHeight(address.getDefaultHeight());
                    address.animationStart();
                }
                if ((pubAddress = instance.getPublicAddress()) != null) {
                    pubAddress.setX(element.getX());
                    pubAddress.setY(element.getY() - 20);
                    pubAddress.setWidth(pubAddress.getDefaultWidth());
                    pubAddress.setHeight(pubAddress.getDefaultHeight());
                    pubAddress.animationStart();
                }
            }
            if (++x <= 4) continue;
            x = 0;
            ++y;
        }
    }

    public boolean animate(CloudCanvas canvas) {
        List<CloudElement> elements = canvas.getCloudElements();
        final ArrayList<CloudElement> animted = new ArrayList<CloudElement>();
        for (CloudElement element : elements) {
            if (!element.animate()) continue;
            animted.add(element);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (CloudElement cloudElement : animted) {
                    cloudElement.refresh();
                }
            }
        });
        return true;
    }
}

