/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.cloud.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.cloud.editpart.BaseEditPart;
import jp.open.cloud.studio.rcp.cloud.editpolicy.CloudCanvasLayoutEditPolicy;
import jp.open.cloud.studio.rcp.cloud.model.CloudCanvas;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class CloudCanvasEditPart
extends BaseEditPart {
    private FormColors colors = new FormColors(Display.getDefault());

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshChildren();
        this.refreshVisuals();
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setBackgroundColor(ColorConstants.white);
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        IFigure layer = this.getLayer("Primary Layer");
        layer.setOpaque(true);
        layer.setBackgroundColor(ColorConstants.white);
        connLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)f));
        CloudCanvas model = (CloudCanvas)this.getModel();
        ProfileModel profile = model.getModel();
        Label header = new Label(String.valueOf(profile.getName()) + ":" + profile.getEc2Url(), Activator.getImage("lcloud"));
        header.setForegroundColor(this.colors.getColor("org.eclipse.ui.forms.TITLE"));
        header.setFont(JFaceResources.getHeaderFont());
        header.setLabelAlignment(1);
        header.setBorder((Border)new LineBorder(ColorConstants.darkBlue){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                tempRect.setBounds(1.getPaintRectangle((IFigure)figure, (Insets)insets));
                if (this.getWidth() % 2 == 1) {
                    --1.tempRect.width;
                    --1.tempRect.height;
                }
                tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
                1.tempRect.y += 1.tempRect.height - 1;
                graphics.setLineWidth(this.getWidth());
                graphics.setLineStyle(this.getStyle());
                if (this.getColor() != null) {
                    graphics.setForegroundColor(this.getColor());
                    graphics.setBackgroundColor(this.getColor());
                }
                graphics.fillRectangle(tempRect);
            }
        });
        f.add((IFigure)header);
        f.setConstraint((IFigure)header, (Object)new Rectangle(5, 5, 920, 60));
        return f;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CloudCanvasLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){});
    }

    protected List getModelChildren() {
        CloudCanvas canvas = (CloudCanvas)this.getModel();
        return canvas.getCloudElements();
    }
}

