/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.cloud.model;

import java.util.ArrayList;
import java.util.List;
import jp.open.cloud.studio.rcp.cloud.model.CloudElement;
import jp.open.cloud.studio.rcp.model.AbstractModel;
import jp.open.cloud.studio.rcp.profile.ProfileModel;

public class CloudCanvas
extends AbstractModel {
    private List<CloudElement> cloudElements = new ArrayList<CloudElement>();
    private final ProfileModel model;

    public CloudCanvas(ProfileModel model) {
        this.model = model;
    }

    public ProfileModel getModel() {
        return this.model;
    }

    public List<CloudElement> getCloudElements() {
        return this.cloudElements;
    }

    public void setCloudElements(List<CloudElement> cloudElements) {
        this.cloudElements = cloudElements;
    }

    public void addCloudElement(CloudElement element) {
        element.setCurrentX((int)(Math.random() * 1024.0));
        element.setCurrentY((int)(Math.random() * 1024.0));
        this.cloudElements.add(element);
    }

    public void prepareToUpdate() {
        for (CloudElement element : this.cloudElements) {
            element.setMaybeDelete(true);
        }
    }

    public boolean contains(CloudElement e) {
        return this.cloudElements.contains(e);
    }

    public void update(CloudElement e) {
        for (CloudElement elem : this.cloudElements) {
            if (!elem.equals(e)) continue;
            elem.setMaybeDelete(false);
            elem.update(e);
        }
    }

    public void postUpdate() {
        ArrayList<CloudElement> dt = new ArrayList<CloudElement>();
        for (CloudElement e : this.cloudElements) {
            if (!e.isMaybeDelete()) continue;
            dt.add(e);
        }
        this.cloudElements.removeAll(dt);
    }
}

