/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.cloud.model;

import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.util.ArrayList;
import java.util.List;
import jp.open.cloud.studio.rcp.cloud.model.Group;
import jp.open.cloud.studio.rcp.cloud.model.Reservation;
import jp.open.cloud.studio.rcp.cloud.model.VirtualMachine;
import jp.open.cloud.studio.rcp.cloud.model.XYModel;

public class InstancePool
extends XYModel {
    private List<Group> groups = new ArrayList<Group>();
    private List<Reservation> reservations = new ArrayList<Reservation>();

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
        this.refresh();
    }

    @Override
    public int getDefaultWidth() {
        return 300;
    }

    @Override
    public int getDefaultHeight() {
        return 180;
    }

    public void addGroup(GroupDescription groupDescription) {
        String name = groupDescription.getName();
        String owner = groupDescription.getOwner();
        Group group = new Group(name);
        group.setOwner(owner);
        if (!this.groups.contains(group)) {
            this.groups.add(group);
        }
        group.setDescription(groupDescription.getDescription());
    }

    public void addReserve(ReservationDescription description) {
        String id = description.getReservationId();
        Reservation reservation = new Reservation(id);
        reservation.setOwner(description.getOwner());
        if (!this.reservations.contains(reservation)) {
            this.reservations.add(reservation);
        } else {
            reservation = this.reservations.get(this.reservations.indexOf(reservation));
        }
        List instances = description.getInstances();
        for (ReservationDescription.Instance instance : instances) {
            VirtualMachine vm = new VirtualMachine(instance.getInstanceId());
            if (!reservation.getVirtualMachines().contains(vm)) {
                reservation.addVirtualMachine(vm);
            } else {
                vm = reservation.getVirtualMachines().get(reservation.getVirtualMachines().indexOf(vm));
            }
            vm.setImageId(instance.getImageId());
            vm.setState(instance.getInstanceLifecycle());
            vm.setInstanceType(instance.getInstanceType());
        }
    }
}

