/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.connector;

import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.VolumeInfo;
import java.util.Iterator;
import java.util.List;
import jp.open.cloud.studio.common.ConnectionConfig;
import jp.open.cloud.studio.common.ConnectionException;
import jp.open.cloud.studio.common.TypicaWrapper;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.SimpleLog;
import jp.open.cloud.studio.rcp.cloud.animation.AnimationHelper;
import jp.open.cloud.studio.rcp.cloud.model.AddressElement;
import jp.open.cloud.studio.rcp.cloud.model.AttachedAddress;
import jp.open.cloud.studio.rcp.cloud.model.CloudCanvas;
import jp.open.cloud.studio.rcp.cloud.model.CloudElement;
import jp.open.cloud.studio.rcp.cloud.model.InstanceElement;
import jp.open.cloud.studio.rcp.cloud.model.SecurityGroupElement;
import jp.open.cloud.studio.rcp.cloud.model.VolumeElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class CloudConnector
extends Job {
    private final CloudCanvas canvas;
    private final ConnectionConfig model;

    public CloudConnector(CloudCanvas canvas, ConnectionConfig model) {
        super(String.valueOf(model.getHost()) + "\u3078\u306e\u63a5\u7d9a...");
        this.canvas = canvas;
        this.model = model;
    }

    protected IStatus run(IProgressMonitor monitor) {
        TypicaWrapper wrapper = new TypicaWrapper();
        this.canvas.prepareToUpdate();
        try {
            CloudElement e;
            Activator.info(String.valueOf(this.model.getHost()) + "\u304b\u3089\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u4e00\u89a7\u3092\u53d6\u5f97.");
            List<ReservationDescription> reserves = wrapper.describeInstance(this.model);
            Activator.info(String.valueOf(reserves.size()) + "\u306e\u30ea\u30b6\u30fc\u30d6\u3092\u53d6\u5f97.");
            for (ReservationDescription rs : reserves) {
                List instances = rs.getInstances();
                Iterator<Object> iterator = instances.iterator();
                while (iterator.hasNext()) {
                    ReservationDescription.Instance instance = (ReservationDescription.Instance)iterator.next();
                    e = new InstanceElement();
                    ((InstanceElement)e).setId(instance.getInstanceId());
                    ((InstanceElement)e).setImageId(instance.getImageId());
                    ((InstanceElement)e).setType(instance.getInstanceType());
                    ((InstanceElement)e).setState(instance.getState());
                    ((InstanceElement)e).setInstance(instance);
                    if (!this.canvas.contains(e)) {
                        this.canvas.addCloudElement(e);
                    } else {
                        this.canvas.update(e);
                    }
                    AttachedAddress padd = ((InstanceElement)e).getPrivateAddress();
                    if (!this.canvas.contains(padd)) {
                        this.canvas.addCloudElement(padd);
                    } else {
                        this.canvas.update(padd);
                    }
                    AttachedAddress add = ((InstanceElement)e).getPublicAddress();
                    if (!this.canvas.contains(add)) {
                        this.canvas.addCloudElement(add);
                        continue;
                    }
                    this.canvas.update(add);
                }
            }
            Activator.info(String.valueOf(this.model.getHost()) + "\u304b\u3089\u30b0\u30eb\u30fc\u30d7\u4e00\u89a7\u3092\u53d6\u5f97.");
            List<GroupDescription> groups = wrapper.describeGroup(this.model);
            Activator.info(String.valueOf(groups.size()) + "\u306e\u30b0\u30eb\u30fc\u30d7\u3092\u53d6\u5f97.");
            for (GroupDescription g : groups) {
                SecurityGroupElement e2 = new SecurityGroupElement();
                e2.setName(g.getName());
                e2.setOwner(g.getOwner());
                e2.setDescription(g.getDescription());
                if (!this.canvas.contains(e2)) {
                    this.canvas.addCloudElement(e2);
                    continue;
                }
                this.canvas.update(e2);
            }
            Activator.info(String.valueOf(this.model.getHost()) + "\u304b\u3089\u30a2\u30c9\u30ec\u30b9\u4e00\u89a7\u3092\u53d6\u5f97");
            List<AddressInfo> addresses = wrapper.describeAddress(this.model);
            Activator.info(String.valueOf(addresses.size()) + "\u306e\u30a2\u30c9\u30ec\u30b9\u3092\u53d6\u5f97");
            for (AddressInfo a : addresses) {
                AddressElement e3 = new AddressElement();
                e3.setAddress(a.getPublicIp());
                if (!this.canvas.contains(e3)) {
                    this.canvas.addCloudElement(e3);
                    continue;
                }
                this.canvas.update(e3);
            }
            Activator.info(String.valueOf(this.model.getHost()) + "\u304b\u3089\u30dc\u30ea\u30e5\u30fc\u30e0\u4e00\u89a7\u3092\u53d6\u5f97");
            List<VolumeInfo> volumes = wrapper.describeVolume(this.model);
            Activator.info(String.valueOf(volumes.size()) + "\u306e\u30dc\u30ea\u30e5\u30fc\u30e0\u3092\u53d6\u5f97");
            for (VolumeInfo v : volumes) {
                e = new VolumeElement();
                ((VolumeElement)e).setId(v.getVolumeId());
                ((VolumeElement)e).setSize(v.getSize());
                ((VolumeElement)e).setStatus(v.getStatus());
                if (!this.canvas.contains(e)) {
                    this.canvas.addCloudElement(e);
                    continue;
                }
                this.canvas.update(e);
            }
        }
        catch (ConnectionException e) {
            SimpleLog.error("\u63a5\u7d9a\u5931\u6557", e);
            Activator.warn("\u30db\u30b9\u30c8\u3078\u306e\u63a5\u7d9a\u3001EC2 API\u306e\u5b9f\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", e);
        }
        this.canvas.postUpdate();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AnimationHelper helper = new AnimationHelper();
                helper.layout(CloudConnector.this.canvas);
                CloudConnector.this.canvas.refresh();
            }
        });
        return Status.OK_STATUS;
    }
}

