/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.editor;

import jp.open.cloud.studio.common.ConnectionConfig;
import jp.open.cloud.studio.rcp.action.OpenElasticIPEditorAction;
import jp.open.cloud.studio.rcp.action.RebootInstanceAction;
import jp.open.cloud.studio.rcp.action.StartInstanceAction;
import jp.open.cloud.studio.rcp.action.StopInstanceAction;
import jp.open.cloud.studio.rcp.action.TerminateInstanceAction;
import jp.open.cloud.studio.rcp.cloud.editpart.InstanceEditPart;
import jp.open.cloud.studio.rcp.cloud.model.CloudCanvas;
import jp.open.cloud.studio.rcp.cloud.model.InstanceElement;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CloudContextMenuProvider
extends ContextMenuProvider {
    private final ActionRegistry registry;
    private final ConnectionConfig config;
    private final CloudCanvas canvas;

    public CloudContextMenuProvider(EditPartViewer viewer, ActionRegistry registry, ConnectionConfig config, CloudCanvas canvas) {
        super(viewer);
        this.registry = registry;
        this.config = config;
        this.canvas = canvas;
    }

    public void buildContextMenu(IMenuManager menu) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof InstanceEditPart) {
            InstanceEditPart editPart = (InstanceEditPart)element;
            InstanceElement i = (InstanceElement)editPart.getModel();
            if (i.getState().equals("running")) {
                menu.add((IAction)new StopInstanceAction(this.config, i.getId()));
                menu.add((IAction)new TerminateInstanceAction(this.config, i.getId()));
                menu.add((IAction)new RebootInstanceAction(this.config, i.getId()));
            } else if (i.getState().equals("pending")) {
                menu.add((IAction)new TerminateInstanceAction(this.config, i.getId()));
                menu.add((IAction)new RebootInstanceAction(this.config, i.getId()));
            } else if (i.getState().equals("pause")) {
                menu.add((IAction)new StartInstanceAction(this.config, i.getId()));
                menu.add((IAction)new TerminateInstanceAction(this.config, i.getId()));
                menu.add((IAction)new RebootInstanceAction(this.config, i.getId()));
            }
        }
        menu.add((IContributionItem)new Separator("openeditor"));
        menu.add((IAction)new OpenElasticIPEditorAction(this.canvas.getModel()));
    }
}

