/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.elasticip;

import com.xerox.amazonws.ec2.AddressInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.action.AllocateAddressAction;
import jp.open.cloud.studio.rcp.action.ReleaseAddressAction;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AddressPage
extends FormPage
implements PropertyChangeListener {
    private List<AddressInfo> addresses;
    private AllocateAddressAction allocateAddressAction;
    private ReleaseAddressAction releaseAddressAction;
    private TableViewer viewer;
    private Button releaseButton;
    private Button allocateButton;

    public AddressPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void setAddresses(List<AddressInfo> addresses) {
        this.addresses = addresses;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Address");
        form.setImage(Activator.getImage("address"));
        form.setBackgroundImage(Activator.getImage("background"));
        form.getBody().setLayout((Layout)new GridLayout());
        final IToolBarManager manager = form.getToolBarManager();
        this.fillToolbar(manager);
        manager.update(true);
        Section addressSection = toolkit.createSection(form.getBody(), 450);
        addressSection.setText("\u30a2\u30c9\u30ec\u30b9\u60c5\u5831");
        addressSection.setDescription("\u30d1\u30d6\u30ea\u30c3\u30afIP\u306e\u78ba\u4fdd\u3084\u30ea\u30ea\u30fc\u30b9\u3092\u884c\u3044\u307e\u3059\u3002");
        addressSection.setLayoutData((Object)new GridData(768));
        Composite addressComposite = toolkit.createComposite((Composite)addressSection);
        addressComposite.setLayout((Layout)new GridLayout(2, false));
        Table table = toolkit.createTable(addressComposite, 0);
        table.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AddressLabelProvider());
        this.viewer.setInput(this.addresses);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AddressPage.this.viewer.getSelection();
                AddressInfo info = (AddressInfo)selection.getFirstElement();
                if (info != null) {
                    AddressPage.this.releaseAddressAction.setPublicIp(info.getPublicIp());
                    AddressPage.this.releaseButton.setEnabled(true);
                    manager.update(true);
                }
            }
        });
        Composite buttons = toolkit.createComposite(addressComposite);
        buttons.setLayout((Layout)new RowLayout(512));
        this.allocateButton = toolkit.createButton(buttons, "\u78ba\u4fdd", 0);
        this.allocateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddressPage.this.allocateAddressAction.run();
            }
        });
        this.releaseButton = toolkit.createButton(buttons, "\u30ea\u30ea\u30fc\u30b9", 0);
        this.releaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddressPage.this.releaseAddressAction.run();
            }
        });
        this.releaseButton.setEnabled(false);
        addressSection.setClient((Control)addressComposite);
        form.pack();
    }

    public void dispose() {
        super.dispose();
    }

    private void fillToolbar(IToolBarManager manager) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ProfileModel model = (ProfileModel)page.getActiveEditor().getAdapter(ProfileModel.class);
        this.allocateAddressAction = new AllocateAddressAction(model.toEc2Config());
        this.allocateAddressAction.setListener(this);
        this.releaseAddressAction = new ReleaseAddressAction(model.toEc2Config());
        this.releaseAddressAction.setListener(this);
        manager.add((IAction)this.allocateAddressAction);
        manager.add((IAction)this.releaseAddressAction);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        List newValue = (List)arg0.getNewValue();
        this.viewer.setInput((Object)newValue);
    }

    class AddressLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AddressLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof AddressInfo) {
                switch (columnIndex) {
                    case 0: {
                        return Activator.getImage("address");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AddressInfo) {
                AddressInfo info = (AddressInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return info.getPublicIp();
                    }
                    case 1: {
                        return info.getInstanceId();
                    }
                }
            }
            return null;
        }
    }
}

