/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.elasticip;

import com.xerox.amazonws.ec2.AddressInfo;
import java.util.List;
import jp.open.cloud.studio.common.ConnectionException;
import jp.open.cloud.studio.common.TypicaWrapper;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.elasticip.AddressPage;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;

public class ElasticIpEditor
extends FormEditor {
    public static final String PLUGIN_ID = "jp.open.cloud.studio.rcp.elasticip.editor";
    private ProfileModel model;
    private List<AddressInfo> addresses;

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        this.model = (ProfileModel)input.getAdapter(ProfileModel.class);
        try {
            TypicaWrapper wrapper = new TypicaWrapper();
            this.addresses = wrapper.describeAddress(this.model.toEc2Config());
        }
        catch (ConnectionException e) {
            Activator.warn("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u8a73\u7d30\u60c5\u5831\u53d6\u5f97\u306b\u5931\u6557.", e);
        }
    }

    protected void addPages() {
        AddressPage page = new AddressPage(this, "instance", "Instance");
        page.setAddresses(this.addresses);
        try {
            this.addPage((IFormPage)page);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        IUndoContext context = this.getSite().getWorkbenchWindow().getWorkbench().getOperationSupport().getUndoContext();
        UndoActionHandler undo = new UndoActionHandler(this.getSite(), context);
        RedoActionHandler redo = new RedoActionHandler(this.getSite(), context);
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)redo);
    }

    protected void createPages() {
        super.createPages();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ProfileModel.class) {
            return this.model;
        }
        return super.getAdapter(adapter);
    }
}

